

<?php $__env->startSection('title', 'Students'); ?>
<?php $__env->startSection('page-title', 'Student Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>All Students</h3>
            <a href="<?php echo e(route('admin.students.create')); ?>" class="btn btn-primary">Add New Student</a>
        </div>
        
        <!-- Search Form -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="<?php echo e(route('admin.students.index')); ?>" style="display: flex; gap: 10px;">
                <input 
                    type="text" 
                    name="search" 
                    placeholder="Search by name, email, school ID, or phone..." 
                    value="<?php echo e(request('search')); ?>"
                    style="flex: 1; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;"
                >
                <button type="submit" class="btn btn-primary">Search</button>
                <?php if(request('search')): ?>
                    <a href="<?php echo e(route('admin.students.index')); ?>" class="btn btn-secondary">Clear</a>
                <?php endif; ?>
            </form>
        </div>
        
        <!-- Students Table -->
        <div style="padding: 0 30px 30px 30px;">
            <?php if($students->count() > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>School ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Registered</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><strong><?php echo e($student->school_id); ?></strong></td>
                                <td><?php echo e($student->name); ?></td>
                                <td><?php echo e($student->email); ?></td>
                                <td><?php echo e($student->phone ?? 'N/A'); ?></td>
                                <td><?php echo e($student->created_at->format('M d, Y')); ?></td>
                                <td>
                                    <div style="display: flex; gap: 8px;">
                                        <a href="<?php echo e(route('admin.students.show', $student->id)); ?>" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">View</a>
                                        <a href="<?php echo e(route('admin.students.edit', $student->id)); ?>" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">Edit</a>
                                        <button type="button" onclick="openConfirmationModal('Delete Student', 'Are you sure you want to delete <?php echo e(addslashes($student->name)); ?>? This action cannot be undone.', '<?php echo e(route('admin.students.destroy', $student->id)); ?>', 'DELETE')" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px; background: #dc3545; border: none;">
                                            <i class="fas fa-trash"></i> Delete
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                
                <!-- Pagination -->
                <div style="margin-top: 20px;">
                    <?php echo e($students->links()); ?>

                </div>
            <?php else: ?>
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p>No students found.</p>
                    <a href="<?php echo e(route('admin.students.create')); ?>" class="btn btn-primary" style="margin-top: 15px;">Add First Student</a>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .pagination {
        display: flex;
        gap: 8px;
        justify-content: center;
        list-style: none;
        padding: 0;
    }
    
    .pagination li {
        display: inline-block;
    }
    
    .pagination a, .pagination span {
        padding: 8px 12px;
        background: #2d2d2d;
        border: 1px solid #404040;
        border-radius: 5px;
        color: #e0e0e0;
        text-decoration: none;
        display: inline-block;
    }
    
    .pagination a:hover {
        background: #4a9eff;
        border-color: #4a9eff;
    }
    
    .pagination .active span {
        background: #4a9eff;
        border-color: #4a9eff;
        color: white;
    }
</style>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/admin/students/index.blade.php ENDPATH**/ ?>