

<?php $__env->startSection('title', 'Create Class Video'); ?>
<?php $__env->startSection('page-title', 'Create New Class Video'); ?>

<?php $__env->startSection('content'); ?>
    <div style="margin-bottom: 20px;">
        <a href="<?php echo e(route('instructor.videos.index')); ?>" class="btn btn-secondary">← Back to Videos</a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-video"></i> Create New Class Video</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <!-- Success/Error Messages -->
            <?php if(session('success')): ?>
                <div style="margin-bottom: 20px; padding: 15px; background: #1a4d1a; border: 1px solid #6bff6b; border-radius: 5px; color: #6bff6b;">
                    <i class="fas fa-check-circle"></i> <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>
            
            <?php if($errors->any()): ?>
                <div style="margin-bottom: 20px; padding: 15px; background: #4d1a1a; border: 1px solid #ff6b6b; border-radius: 5px; color: #ff6b6b;">
                    <strong>Error:</strong>
                    <ul style="margin: 10px 0 0 0; padding-left: 20px;">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
            
            <form method="POST" action="<?php echo e(route('instructor.videos.store')); ?>">
                <?php echo csrf_field(); ?>
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="course_id">Course *</label>
                        <select id="course_id" name="course_id" required onchange="loadCourseOfferings(this.value)">
                            <option value="">Select Course</option>
                            <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($course->id); ?>" <?php echo e(old('course_id') == $course->id ? 'selected' : ''); ?>>
                                    <?php echo e($course->name); ?> (<?php echo e($course->code); ?>)
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['course_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="course_offering_id">Course Offering (Optional)</label>
                        <select id="course_offering_id" name="course_offering_id">
                            <option value="">Select Course Offering (Optional)</option>
                            <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($course->courseOfferings && $course->courseOfferings->count() > 0): ?>
                                    <?php $__currentLoopData = $course->courseOfferings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offering): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($offering->id); ?>" 
                                            data-course="<?php echo e($course->id); ?>"
                                            <?php echo e(old('course_offering_id') == $offering->id ? 'selected' : ''); ?>

                                            style="display: none;">
                                            <?php echo e($offering->name ?? 'Offering ' . $offering->id); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['course_offering_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label for="title">Video Title *</label>
                    <input 
                        type="text" 
                        id="title" 
                        name="title" 
                        value="<?php echo e(old('title')); ?>" 
                        required
                        autofocus
                        placeholder="e.g., Introduction to Flutter Widgets"
                    >
                    <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div class="form-group">
                    <label for="description">Description</label>
                    <textarea 
                        id="description" 
                        name="description" 
                        rows="4"
                        placeholder="Brief description of the video content..."
                    ><?php echo e(old('description')); ?></textarea>
                    <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-top: 20px;">
                    <div class="form-group">
                        <label for="session_date">Session Date *</label>
                        <input 
                            type="date" 
                            id="session_date" 
                            name="session_date" 
                            value="<?php echo e(old('session_date', date('Y-m-d'))); ?>" 
                            required
                        >
                        <?php $__errorArgs = ['session_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="video_duration">Video Duration (HH:MM)</label>
                        <input 
                            type="time" 
                            id="video_duration" 
                            name="video_duration" 
                            value="<?php echo e(old('video_duration')); ?>"
                            step="1"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Format: HH:MM (e.g., 01:30 for 1 hour 30 minutes)</small>
                        <?php $__errorArgs = ['video_duration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label for="mega_storage_link">Mega Storage Link</label>
                    <input 
                        type="url" 
                        id="mega_storage_link" 
                        name="mega_storage_link" 
                        value="<?php echo e(old('mega_storage_link')); ?>" 
                        placeholder="https://mega.nz/..."
                    >
                    <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Full URL to the video on Mega storage</small>
                    <?php $__errorArgs = ['mega_storage_link'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div class="form-group">
                    <label for="download_key">Download Key</label>
                    <input 
                        type="text" 
                        id="download_key" 
                        name="download_key" 
                        value="<?php echo e(old('download_key')); ?>" 
                        placeholder="Enter download key if required"
                    >
                    <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Key required to download the video (if applicable)</small>
                    <?php $__errorArgs = ['download_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div class="form-group">
                    <label for="thumbnail_url">Thumbnail URL</label>
                    <input 
                        type="url" 
                        id="thumbnail_url" 
                        name="thumbnail_url" 
                        value="<?php echo e(old('thumbnail_url')); ?>" 
                        placeholder="https://example.com/thumbnail.jpg"
                    >
                    <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">URL to video thumbnail image</small>
                    <?php $__errorArgs = ['thumbnail_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div style="margin-top: 20px;">
                    <div class="form-group">
                        <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                            <input 
                                type="checkbox" 
                                name="is_published" 
                                value="1"
                                <?php echo e(old('is_published') ? 'checked' : ''); ?>

                                style="width: auto;"
                            >
                            <span>Publish Video (make visible to students)</span>
                        </label>
                    </div>
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 10px;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Create Video
                    </button>
                    <a href="<?php echo e(route('instructor.videos.index')); ?>" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
    
    <?php $__env->startPush('scripts'); ?>
    <script>
        function loadCourseOfferings(courseId) {
            const offeringSelect = document.getElementById('course_offering_id');
            const options = offeringSelect.querySelectorAll('option');
            
            // Reset offering selection
            offeringSelect.value = '';
            
            options.forEach(option => {
                if (option.value === '') {
                    option.style.display = 'block';
                } else {
                    const optionCourseId = option.getAttribute('data-course');
                    if (optionCourseId == courseId) {
                        option.style.display = 'block';
                    } else {
                        option.style.display = 'none';
                    }
                }
            });
        }
        
        // Load offerings if course is pre-selected
        const courseSelect = document.getElementById('course_id');
        if (courseSelect.value) {
            loadCourseOfferings(courseSelect.value);
        }
    </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.instructor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/instructor/videos/create.blade.php ENDPATH**/ ?>