

<?php $__env->startSection('title', 'Admins'); ?>
<?php $__env->startSection('page-title', 'Admin Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>All Admins</h3>
            <a href="<?php echo e(route('admin.admins.create')); ?>" class="btn btn-primary">Add New Admin</a>
        </div>
        
        <!-- Search Form -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="<?php echo e(route('admin.admins.index')); ?>" style="display: flex; gap: 10px;">
                <input 
                    type="text" 
                    name="search" 
                    placeholder="Search by name, email, or phone..." 
                    value="<?php echo e(request('search')); ?>"
                    style="flex: 1; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;"
                >
                <button type="submit" class="btn btn-primary">Search</button>
                <?php if(request('search')): ?>
                    <a href="<?php echo e(route('admin.admins.index')); ?>" class="btn btn-secondary">Clear</a>
                <?php endif; ?>
            </form>
        </div>
        
        <!-- Admins Table -->
        <div style="padding: 0 30px 30px 30px;">
            <?php if($admins->count() > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Registered</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <strong><?php echo e($admin->name); ?></strong>
                                    <?php if($admin->id === auth()->id()): ?>
                                        <span style="color: #4a9eff; font-size: 12px; margin-left: 8px;">(You)</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($admin->email); ?></td>
                                <td><?php echo e($admin->phone ?? 'N/A'); ?></td>
                                <td><?php echo e($admin->created_at->format('M d, Y')); ?></td>
                                <td>
                                    <div style="display: flex; gap: 8px;">
                                        <a href="<?php echo e(route('admin.admins.show', $admin->id)); ?>" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">View</a>
                                        <?php if($admin->id !== auth()->id()): ?>
                                            <a href="<?php echo e(route('admin.admins.edit', $admin->id)); ?>" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">Edit</a>
                                            <button type="button" onclick="openConfirmationModal('Delete Admin', 'Are you sure you want to delete <?php echo e(addslashes($admin->name)); ?>? This action cannot be undone.', '<?php echo e(route('admin.admins.destroy', $admin->id)); ?>', 'DELETE')" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px; background: #dc3545; border: none;">
                                                <i class="fas fa-trash"></i> Delete
                                            </button>
                                        <?php else: ?>
                                            <span style="color: #888; font-size: 12px; padding: 6px 12px;">Cannot edit self</span>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                
                <!-- Pagination -->
                <div style="margin-top: 20px;">
                    <?php echo e($admins->links()); ?>

                </div>
            <?php else: ?>
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p>No admins found.</p>
                    <a href="<?php echo e(route('admin.admins.create')); ?>" class="btn btn-primary" style="margin-top: 15px;">Add First Admin</a>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .pagination {
        display: flex;
        gap: 8px;
        justify-content: center;
        list-style: none;
        padding: 0;
    }
    
    .pagination li {
        display: inline-block;
    }
    
    .pagination a, .pagination span {
        padding: 8px 12px;
        background: #2d2d2d;
        border: 1px solid #404040;
        border-radius: 5px;
        color: #e0e0e0;
        text-decoration: none;
        display: inline-block;
    }
    
    .pagination a:hover {
        background: #4a9eff;
        border-color: #4a9eff;
    }
    
    .pagination .active span {
        background: #4a9eff;
        border-color: #4a9eff;
        color: white;
    }
</style>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/admin/admins/index.blade.php ENDPATH**/ ?>