

<?php $__env->startSection('title', 'Profile'); ?>
<?php $__env->startSection('page-title', 'My Profile'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-user"></i> Profile Information</h3>
        </div>
        
        <div style="padding: 30px;">
            <form method="POST" action="<?php echo e(route('admin.profile.update')); ?>" enctype="multipart/form-data" id="profileForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                
                <!-- Profile Picture Section -->
                <div style="margin-bottom: 30px; text-align: center;">
                    <div style="position: relative; display: inline-block;">
                        <div id="profilePreview" style="position: relative; display: inline-block;">
                            <?php if($user->profile_picture): ?>
                                <?php
                                    try {
                                        $decrypted = \Illuminate\Support\Facades\Crypt::decryptString($user->profile_picture);
                                    } catch (\Exception $e) {
                                        $decrypted = null;
                                    }
                                ?>
                                <?php if($decrypted): ?>
                                    <img src="<?php echo e($decrypted); ?>" alt="Profile Picture" 
                                         id="profileImage"
                                         style="width: 150px; height: 150px; border-radius: 50%; object-fit: cover; border: 3px solid #4a9eff;">
                                <?php else: ?>
                                    <div id="profilePlaceholder" style="width: 150px; height: 150px; border-radius: 50%; background: #2d2d2d; display: flex; align-items: center; justify-content: center; border: 3px solid #4a9eff; margin: 0 auto;">
                                        <i class="fas fa-user" style="font-size: 60px; color: #888;"></i>
                                    </div>
                                <?php endif; ?>
                            <?php else: ?>
                                <div id="profilePlaceholder" style="width: 150px; height: 150px; border-radius: 50%; background: #2d2d2d; display: flex; align-items: center; justify-content: center; border: 3px solid #4a9eff; margin: 0 auto;">
                                    <i class="fas fa-user" style="font-size: 60px; color: #888;"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <!-- Custom File Input Button -->
                        <label for="profile_picture" id="cameraLabel" style="position: absolute; bottom: 0; right: 50%; transform: translateX(50%) translateY(25%); background: #4a9eff; color: white; width: 40px; height: 40px; border-radius: 50%; display: flex; align-items: center; justify-content: center; cursor: pointer; border: 3px solid #1a1a1a; box-shadow: 0 2px 8px rgba(0,0,0,0.3); transition: all 0.3s ease; z-index: 10;">
                            <i class="fas fa-camera" style="font-size: 16px;"></i>
                        </label>
                        
                        <input 
                            type="file" 
                            id="profile_picture" 
                            name="profile_picture" 
                            accept="image/*"
                            style="display: none;"
                            onchange="previewProfilePicture(this)"
                        >
                    </div>
                    <div style="margin-top: 50px; text-align: center;">
                        <small style="color: #888; font-size: 12px;">Click the camera icon to change profile picture</small>
                        <br><small style="color: #888; font-size: 11px;">Max size: 1MB. Formats: JPG, PNG, GIF</small>
                        <?php $__errorArgs = ['profile_picture'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <br><span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                
                <!-- Personal Information Section -->
                <div style="margin-bottom: 30px;">
                    <h4 style="color: #4a9eff; margin-bottom: 20px; padding-bottom: 10px; border-bottom: 1px solid #404040;">
                        <i class="fas fa-user-circle"></i> Personal Information
                    </h4>
                    
                    <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 20px; margin-bottom: 20px;" class="profile-form-grid">
                        <div class="form-group">
                            <label for="name">
                                <i class="fas fa-user"></i> Full Name *
                            </label>
                            <input 
                                type="text" 
                                id="name" 
                                name="name" 
                                value="<?php echo e(old('name', $user->name)); ?>" 
                                required
                                placeholder="Enter your full name"
                            >
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="form-group">
                            <label for="email">
                                <i class="fas fa-envelope"></i> Email Address *
                            </label>
                            <input 
                                type="email" 
                                id="email" 
                                name="email" 
                                value="<?php echo e(old('email', $user->email)); ?>" 
                                required
                                placeholder="your.email@example.com"
                            >
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    
                    <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 20px;" class="profile-form-grid">
                        <div class="form-group">
                            <label for="phone">
                                <i class="fas fa-phone"></i> Phone Number
                            </label>
                            <input 
                                type="text" 
                                id="phone" 
                                name="phone" 
                                value="<?php echo e(old('phone', $user->phone)); ?>"
                                placeholder="+233 XX XXX XXXX"
                            >
                            <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="form-group">
                            <!-- Empty space for alignment -->
                        </div>
                    </div>
                </div>
                
                <!-- Address Section -->
                <div style="margin-bottom: 30px;">
                    <h4 style="color: #4a9eff; margin-bottom: 20px; padding-bottom: 10px; border-bottom: 1px solid #404040;">
                        <i class="fas fa-map-marker-alt"></i> Address Information
                    </h4>
                    
                    <div class="form-group">
                        <label for="address">
                            <i class="fas fa-home"></i> Address
                        </label>
                        <textarea 
                            id="address" 
                            name="address" 
                            rows="3"
                            placeholder="Enter your full address"
                        ><?php echo e(old('address', $user->address)); ?></textarea>
                        <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                
                <div style="margin-top: 30px;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Update Profile
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Password Update Section -->
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-lock"></i> Change Password</h3>
        </div>
        
        <div style="padding: 30px;">
            <form method="POST" action="<?php echo e(route('admin.profile.updatePassword')); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="current_password">Current Password *</label>
                        <input 
                            type="password" 
                            id="current_password" 
                            name="current_password" 
                            required
                        >
                        <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="password">New Password *</label>
                        <input 
                            type="password" 
                            id="password" 
                            name="password" 
                            required
                            minlength="8"
                        >
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="password_confirmation">Confirm New Password *</label>
                        <input 
                            type="password" 
                            id="password_confirmation" 
                            name="password_confirmation" 
                            required
                            minlength="8"
                        >
                    </div>
                </div>
                
                <div style="margin-top: 30px;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-key"></i> Update Password
                    </button>
                </div>
            </form>
        </div>
    </div>

    <?php $__env->startPush('styles'); ?>
    <style>
        @media (max-width: 768px) {
            .profile-form-grid {
                grid-template-columns: 1fr !important;
            }
        }
        
        .form-group label {
            display: flex;
            align-items: center;
            gap: 8px;
            margin-bottom: 8px;
        }
        
        .form-group label i {
            color: #4a9eff;
            font-size: 14px;
        }
    </style>
    <?php $__env->stopPush(); ?>

    <?php $__env->startPush('scripts'); ?>
    <script>
        // Profile picture preview
        function previewProfilePicture(input) {
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                
                reader.onload = function(e) {
                    const previewDiv = document.getElementById('profilePreview');
                    const placeholder = document.getElementById('profilePlaceholder');
                    let img = document.getElementById('profileImage');
                    
                    if (!img) {
                        // Create image element if it doesn't exist
                        img = document.createElement('img');
                        img.id = 'profileImage';
                        img.alt = 'Profile Picture';
                        img.style.cssText = 'width: 150px; height: 150px; border-radius: 50%; object-fit: cover; border: 3px solid #4a9eff;';
                        
                        if (placeholder) {
                            placeholder.parentNode.replaceChild(img, placeholder);
                        } else {
                            previewDiv.innerHTML = '';
                            previewDiv.appendChild(img);
                        }
                    }
                    
                    img.src = e.target.result;
                };
                
                reader.readAsDataURL(input.files[0]);
            }
        }
        
        // Camera button hover effect
        const cameraLabel = document.getElementById('cameraLabel');
        if (cameraLabel) {
            cameraLabel.addEventListener('mouseenter', function() {
                this.style.background = '#5bb5ff';
                this.style.transform = 'translateX(50%) translateY(25%) scale(1.1)';
            });
            
            cameraLabel.addEventListener('mouseleave', function() {
                this.style.background = '#4a9eff';
                this.style.transform = 'translateX(50%) translateY(25%) scale(1)';
            });
        }
    </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/admin/profile/index.blade.php ENDPATH**/ ?>