

<?php $__env->startSection('title', 'Settings'); ?>
<?php $__env->startSection('page-title', 'System Settings'); ?>

<?php $__env->startSection('content'); ?>
    <!-- General Settings -->
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-cog"></i> General Settings</h3>
        </div>
        
        <div style="padding: 30px;">
            <form method="POST" action="<?php echo e(route('admin.settings.update')); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <input type="hidden" name="group" value="general">
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="system_name">System Name *</label>
                        <input 
                            type="text" 
                            id="system_name" 
                            name="system_name" 
                            value="<?php echo e(old('system_name', \App\Models\Setting::get('system_name', 'Afrilen Technologies'))); ?>" 
                            required
                            placeholder="e.g., Afrilen Technologies"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">The name of your application/system</small>
                        <?php $__errorArgs = ['system_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="system_email">System Email *</label>
                        <input 
                            type="email" 
                            id="system_email" 
                            name="system_email" 
                            value="<?php echo e(old('system_email', \App\Models\Setting::get('system_email', 'noreply@afrilen.com'))); ?>" 
                            required
                            placeholder="noreply@afrilen.com"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Default system email address</small>
                        <?php $__errorArgs = ['system_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="system_phone">System Phone</label>
                        <input 
                            type="text" 
                            id="system_phone" 
                            name="system_phone" 
                            value="<?php echo e(old('system_phone', \App\Models\Setting::get('system_phone', ''))); ?>" 
                            placeholder="+233 XX XXX XXXX"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Contact phone number</small>
                        <?php $__errorArgs = ['system_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="system_description">System Description</label>
                    <textarea 
                        id="system_description" 
                        name="system_description" 
                        rows="3"
                        placeholder="Brief description of your system"
                    ><?php echo e(old('system_description', \App\Models\Setting::get('system_description', ''))); ?></textarea>
                    <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Brief description of the system</small>
                    <?php $__errorArgs = ['system_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div class="form-group">
                    <label for="system_address">System Address</label>
                    <textarea 
                        id="system_address" 
                        name="system_address" 
                        rows="2"
                        placeholder="Physical address"
                    ><?php echo e(old('system_address', \App\Models\Setting::get('system_address', ''))); ?></textarea>
                    <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Physical address</small>
                    <?php $__errorArgs = ['system_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div style="margin-top: 30px;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Save General Settings
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Email/SMTP Settings -->
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-envelope"></i> Email / SMTP Settings</h3>
        </div>
        
        <div style="padding: 30px;">
            <form method="POST" action="<?php echo e(route('admin.settings.update')); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <input type="hidden" name="group" value="email">
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="mail_mailer">Mail Driver *</label>
                        <select id="mail_mailer" name="mail_mailer" required>
                            <option value="smtp" <?php echo e(\App\Models\Setting::get('mail_mailer', 'smtp') == 'smtp' ? 'selected' : ''); ?>>SMTP</option>
                            <option value="mailgun" <?php echo e(\App\Models\Setting::get('mail_mailer') == 'mailgun' ? 'selected' : ''); ?>>Mailgun</option>
                            <option value="ses" <?php echo e(\App\Models\Setting::get('mail_mailer') == 'ses' ? 'selected' : ''); ?>>Amazon SES</option>
                            <option value="postmark" <?php echo e(\App\Models\Setting::get('mail_mailer') == 'postmark' ? 'selected' : ''); ?>>Postmark</option>
                            <option value="sendmail" <?php echo e(\App\Models\Setting::get('mail_mailer') == 'sendmail' ? 'selected' : ''); ?>>Sendmail</option>
                        </select>
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Email delivery method</small>
                        <?php $__errorArgs = ['mail_mailer'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="mail_host">SMTP Host *</label>
                        <input 
                            type="text" 
                            id="mail_host" 
                            name="mail_host" 
                            value="<?php echo e(old('mail_host', \App\Models\Setting::get('mail_host', ''))); ?>" 
                            required
                            placeholder="smtp.gmail.com"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">SMTP server address</small>
                        <?php $__errorArgs = ['mail_host'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="mail_port">SMTP Port *</label>
                        <input 
                            type="text" 
                            id="mail_port" 
                            name="mail_port" 
                            value="<?php echo e(old('mail_port', \App\Models\Setting::get('mail_port', '587'))); ?>" 
                            required
                            placeholder="587"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Common ports: 587 (TLS), 465 (SSL), 25</small>
                        <?php $__errorArgs = ['mail_port'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="mail_username">SMTP Username</label>
                        <input 
                            type="text" 
                            id="mail_username" 
                            name="mail_username" 
                            value="<?php echo e(old('mail_username', \App\Models\Setting::get('mail_username', ''))); ?>" 
                            placeholder="your-email@gmail.com"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">SMTP authentication username</small>
                        <?php $__errorArgs = ['mail_username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="mail_password">SMTP Password</label>
                        <input 
                            type="password" 
                            id="mail_password" 
                            name="mail_password" 
                            value=""
                            placeholder="Leave blank to keep current password"
                            autocomplete="new-password"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Leave blank to keep current password</small>
                        <?php $__errorArgs = ['mail_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="mail_encryption">Encryption</label>
                        <select id="mail_encryption" name="mail_encryption">
                            <option value="tls" <?php echo e(\App\Models\Setting::get('mail_encryption', 'tls') == 'tls' ? 'selected' : ''); ?>>TLS</option>
                            <option value="ssl" <?php echo e(\App\Models\Setting::get('mail_encryption') == 'ssl' ? 'selected' : ''); ?>>SSL</option>
                            <option value="null" <?php echo e(\App\Models\Setting::get('mail_encryption') == 'null' ? 'selected' : ''); ?>>None</option>
                        </select>
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Encryption method</small>
                        <?php $__errorArgs = ['mail_encryption'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="mail_from_address">From Email Address *</label>
                        <input 
                            type="email" 
                            id="mail_from_address" 
                            name="mail_from_address" 
                            value="<?php echo e(old('mail_from_address', \App\Models\Setting::get('mail_from_address', 'noreply@afrilen.com'))); ?>" 
                            required
                            placeholder="noreply@afrilen.com"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Email address to send from</small>
                        <?php $__errorArgs = ['mail_from_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="mail_from_name">From Name *</label>
                        <input 
                            type="text" 
                            id="mail_from_name" 
                            name="mail_from_name" 
                            value="<?php echo e(old('mail_from_name', \App\Models\Setting::get('mail_from_name', 'Afrilen Technologies'))); ?>" 
                            required
                            placeholder="Afrilen Technologies"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Display name for emails</small>
                        <?php $__errorArgs = ['mail_from_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                
                <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #404040;">
                    <div class="form-group">
                        <label for="test_email_address">Test Email Configuration</label>
                        <div style="display: flex; gap: 10px; align-items: flex-end;">
                            <div style="flex: 1;">
                                <input 
                                    type="email" 
                                    id="test_email_address" 
                                    name="test_email_address" 
                                    value="<?php echo e(old('test_email_address')); ?>" 
                                    placeholder="Enter email address to test"
                                >
                                <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Send a test email to verify configuration</small>
                            </div>
                            <button type="button" onclick="testEmail()" class="btn btn-secondary" style="white-space: nowrap;">
                                <i class="fas fa-paper-plane"></i> Send Test Email
                            </button>
                        </div>
                        <?php if(session('email_test_error')): ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e(session('email_test_error')); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div style="margin-top: 30px;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Save Email Settings
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <?php $__env->startPush('scripts'); ?>
    <script>
        function testEmail() {
            const email = document.getElementById('test_email_address').value;
            
            if (!email) {
                alert('Please enter an email address to test');
                return;
            }
            
            if (!confirm('This will send a test email to ' + email + '. Continue?')) {
                return;
            }
            
            // Create form data
            const formData = new FormData();
            formData.append('_token', '<?php echo e(csrf_token()); ?>');
            formData.append('test_email_address', email);
            
            // Show loading
            const btn = event.target.closest('button');
            const originalText = btn.innerHTML;
            btn.disabled = true;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
            
            fetch('<?php echo e(route('admin.settings.test-email')); ?>', {
                method: 'POST',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json',
                },
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                btn.disabled = false;
                btn.innerHTML = originalText;
                
                if (data.success) {
                    alert('Test email sent successfully! Please check your inbox.');
                } else {
                    alert('Error: ' + (data.message || 'Failed to send test email'));
                }
            })
            .catch(error => {
                btn.disabled = false;
                btn.innerHTML = originalText;
                console.error('Error:', error);
                alert('Error: Failed to send test email. Please check your SMTP settings.');
            });
        }
    </script>
    <?php $__env->stopPush(); ?>

    <!-- Payment Settings -->
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-money-bill-wave"></i> Payment Information</h3>
        </div>
        
        <div style="padding: 30px;">
            <form method="POST" action="<?php echo e(route('admin.settings.update')); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <input type="hidden" name="group" value="payment">
                
                <div class="form-group">
                    <label for="payment_info">Payment Instructions *</label>
                    <textarea 
                        id="payment_info" 
                        name="payment_info" 
                        rows="12"
                        placeholder="Enter payment instructions that will be shown to students when they want to make a payment. Include bank details, mobile money numbers, account numbers, etc."
                        style="width: 100%; padding: 12px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0; font-family: inherit; white-space: pre-line;"
                    ><?php echo e(old('payment_info', \App\Models\Setting::get('payment_info', '💳 Payment Methods

Merchant Number (Recommended):
📌 054 505 4754 — IKSOFT TECHNOLOGIES

MTN MoMo:
📌 0543261734 — ADU AMANKWAH ISAAC
📌 0550138086 — AGYEKUM MARY

Telecel Cash:
📌 0206934488 — ADU AMANKWAH ISAAC'))); ?></textarea>
                    <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">
                        This information will be displayed to students in the payment modal. Include bank details, mobile money numbers, account numbers, etc.
                    </small>
                    <?php $__errorArgs = ['payment_info'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div style="margin-top: 30px;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Save Payment Settings
                    </button>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/admin/settings/index.blade.php ENDPATH**/ ?>