

<?php $__env->startSection('title', 'Resource Details'); ?>
<?php $__env->startSection('page-title', 'Resource Details'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3><?php echo e($resource->title); ?></h3>
            <div style="display: flex; gap: 10px;">
                <a href="<?php echo e(route('admin.resources.edit', $resource->id)); ?>" class="btn btn-secondary">Edit</a>
                <a href="<?php echo e(route('admin.resources.index')); ?>" class="btn btn-secondary">Back</a>
            </div>
        </div>
        
        <div style="padding: 30px;">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-bottom: 30px;">
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Resource Type</strong>
                    <p style="font-size: 16px;"><?php echo e($resource->resource_type ?? 'N/A'); ?></p>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Uploaded By</strong>
                    <p style="font-size: 16px;"><?php echo e($resource->uploader->name ?? 'N/A'); ?></p>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Uploaded On</strong>
                    <p style="font-size: 16px;"><?php echo e($resource->created_at->format('M d, Y')); ?></p>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Status</strong>
                    <?php if($resource->is_active): ?>
                        <span style="color: #6bff6b; font-weight: bold;">Active</span>
                    <?php else: ?>
                        <span style="color: #888; font-weight: bold;">Inactive</span>
                    <?php endif; ?>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Downloads</strong>
                    <p style="font-size: 16px;"><?php echo e($resource->download_count); ?></p>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Accessible By</strong>
                    <div style="display: flex; gap: 5px; flex-wrap: wrap; margin-top: 5px;">
                        <?php $__currentLoopData = $resource->accessible_by_roles ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span style="display: inline-block; padding: 4px 10px; background: #2d2d2d; border-radius: 3px; font-size: 12px;">
                                <?php echo e(ucfirst($role)); ?>

                            </span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            
            <?php if($resource->description): ?>
                <div style="margin-bottom: 20px;">
                    <strong style="color: #888; display: block; margin-bottom: 10px;">Description</strong>
                    <p style="line-height: 1.6; white-space: pre-wrap;"><?php echo e($resource->description); ?></p>
                </div>
            <?php endif; ?>
            
            <div style="border-top: 1px solid #404040; padding-top: 20px;">
                <h4 style="margin-bottom: 15px;">Resource File</h4>
                <div style="background: #1a1a1a; padding: 15px; border-radius: 5px; display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 15px;">
                    <div>
                        <strong><?php echo e($resource->file_name); ?></strong>
                        <small style="display: block; color: #888; margin-top: 5px;">
                            <?php echo e($resource->formatted_file_size); ?> | <?php echo e(strtoupper($resource->file_extension ?? 'N/A')); ?>

                        </small>
                    </div>
                    <a href="<?php echo e(route('admin.resources.download', $resource->id)); ?>" class="btn btn-primary">
                        <i class="fas fa-download"></i> Download Resource
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/admin/resources/show.blade.php ENDPATH**/ ?>