

<?php $__env->startSection('title', 'Resources'); ?>
<?php $__env->startSection('page-title', 'Resources Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>All Resources</h3>
            <a href="<?php echo e(route('admin.resources.create')); ?>" class="btn btn-primary">
                <i class="fas fa-upload"></i> Upload New Resource
            </a>
        </div>
        
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="<?php echo e(route('admin.resources.index')); ?>" style="display: flex; gap: 10px; flex-wrap: wrap;">
                <input type="text" name="search" placeholder="Search resources..." value="<?php echo e(request('search')); ?>" style="flex: 1; min-width: 200px; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                <select name="status" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Status</option>
                    <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>Active</option>
                    <option value="inactive" <?php echo e(request('status') === 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                </select>
                <button type="submit" class="btn btn-primary">Search</button>
                <?php if(request('search') || request('status')): ?>
                    <a href="<?php echo e(route('admin.resources.index')); ?>" class="btn btn-secondary">Clear</a>
                <?php endif; ?>
            </form>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <?php if($resources->count() > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Type</th>
                            <th>File</th>
                            <th>Size</th>
                            <th>Accessible By</th>
                            <th>Uploaded By</th>
                            <th>Downloads</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $resources; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resource): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <strong><?php echo e($resource->title); ?></strong>
                                    <?php if($resource->description): ?>
                                        <br><small style="color: #888;"><?php echo e(Str::limit($resource->description, 50)); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($resource->resource_type ?? 'N/A'); ?></td>
                                <td>
                                    <i class="fas fa-file" style="color: #4a9eff;"></i>
                                    <small><?php echo e($resource->file_extension ?? 'N/A'); ?></small>
                                </td>
                                <td><?php echo e($resource->formatted_file_size); ?></td>
                                <td>
                                    <?php $__currentLoopData = $resource->accessible_by_roles ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span style="display: inline-block; padding: 2px 8px; background: #2d2d2d; border-radius: 3px; font-size: 11px; margin: 2px;">
                                            <?php echo e(ucfirst($role)); ?>

                                        </span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <td><?php echo e($resource->uploader->name ?? 'N/A'); ?></td>
                                <td><?php echo e($resource->download_count); ?></td>
                                <td>
                                    <?php if($resource->is_active): ?>
                                        <span style="color: #6bff6b;">Active</span>
                                    <?php else: ?>
                                        <span style="color: #888;">Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div style="display: flex; gap: 8px; flex-wrap: wrap;">
                                        <a href="<?php echo e(route('admin.resources.show', $resource->id)); ?>" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">View</a>
                                        <a href="<?php echo e(route('admin.resources.edit', $resource->id)); ?>" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">Edit</a>
                                        <a href="<?php echo e(route('admin.resources.download', $resource->id)); ?>" class="btn btn-primary" style="padding: 6px 12px; font-size: 12px;">
                                            <i class="fas fa-download"></i> Download
                                        </a>
                                        <form action="<?php echo e(route('admin.resources.destroy', $resource->id)); ?>" method="POST" style="display: inline;" onsubmit="return confirm('Are you sure you want to delete this resource?');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger" style="padding: 6px 12px; font-size: 12px;">Delete</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div style="margin-top: 20px;"><?php echo e($resources->links()); ?></div>
            <?php else: ?>
                <div style="text-align: center; padding: 40px; color: #888;">
                    <i class="fas fa-folder-open" style="font-size: 48px; margin-bottom: 15px; color: #404040;"></i>
                    <p>No resources found.</p>
                    <a href="<?php echo e(route('admin.resources.create')); ?>" class="btn btn-primary" style="margin-top: 15px;">
                        <i class="fas fa-upload"></i> Upload First Resource
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/admin/resources/index.blade.php ENDPATH**/ ?>