

<?php $__env->startSection('title', 'Class Videos'); ?>
<?php $__env->startSection('page-title', 'Class Videos'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3><i class="fas fa-video"></i> My Class Videos</h3>
            <a href="<?php echo e(route('instructor.videos.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add New Video
            </a>
        </div>
        
        <!-- Filters -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="<?php echo e(route('instructor.videos.index')); ?>" style="display: flex; gap: 10px; flex-wrap: wrap;">
                <select name="course_id" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Courses</option>
                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($course->id); ?>" <?php echo e(request('course_id') == $course->id ? 'selected' : ''); ?>><?php echo e($course->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <select name="published" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Status</option>
                    <option value="1" <?php echo e(request('published') == '1' ? 'selected' : ''); ?>>Published</option>
                    <option value="0" <?php echo e(request('published') == '0' ? 'selected' : ''); ?>>Draft</option>
                </select>
                <button type="submit" class="btn btn-primary">Filter</button>
                <?php if(request()->anyFilled(['course_id', 'published'])): ?>
                    <a href="<?php echo e(route('instructor.videos.index')); ?>" class="btn btn-secondary">Clear</a>
                <?php endif; ?>
            </form>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <?php if($videos->count() > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Course</th>
                            <th>Session Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><strong><?php echo e($video->title); ?></strong></td>
                                <td><?php echo e($video->course->name); ?></td>
                                <td><?php echo e($video->session_date ? \Carbon\Carbon::parse($video->session_date)->format('M d, Y') : 'N/A'); ?></td>
                                <td>
                                    <?php if($video->is_published): ?>
                                        <span style="color: #6bff6b;">Published</span>
                                    <?php else: ?>
                                        <span style="color: #888;">Draft</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div style="display: flex; gap: 8px;">
                                        <a href="<?php echo e(route('instructor.videos.show', $video->id)); ?>" class="btn btn-primary" style="padding: 6px 12px; font-size: 12px;">
                                            <i class="fas fa-eye"></i> View
                                        </a>
                                        <a href="<?php echo e(route('instructor.videos.edit', $video->id)); ?>" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>
                                        <button type="button" onclick="openConfirmationModal('Delete Video', 'Are you sure you want to delete <?php echo e(addslashes($video->title)); ?>? This action cannot be undone.', '<?php echo e(route('instructor.videos.destroy', $video->id)); ?>', 'DELETE')" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px; background: #dc3545; border: none;">
                                            <i class="fas fa-trash"></i> Delete
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div style="margin-top: 20px;"><?php echo e($videos->links()); ?></div>
            <?php else: ?>
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p><i class="fas fa-video" style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;"></i></p>
                    <p>No class videos found.</p>
                    <a href="<?php echo e(route('instructor.videos.create')); ?>" class="btn btn-primary" style="margin-top: 15px;">
                        <i class="fas fa-plus"></i> Add First Video
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.instructor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/instructor/videos/index.blade.php ENDPATH**/ ?>