

<?php $__env->startSection('title', 'Course Details'); ?>
<?php $__env->startSection('page-title', 'Course Details'); ?>

<?php $__env->startSection('content'); ?>
    <div style="margin-bottom: 20px;">
        <a href="<?php echo e(route('instructor.courses.index')); ?>" class="btn btn-secondary">← Back to My Courses</a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3><?php echo e($course->name); ?> (<?php echo e($course->code); ?>)</h3>
        </div>
        
        <div style="padding: 30px;">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px; margin-bottom: 30px;">
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Course Information</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Course Code</strong>
                        <span style="color: #e0e0e0; font-size: 16px; font-weight: 600;"><?php echo e($course->code); ?></span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Course Name</strong>
                        <span style="color: #e0e0e0; font-size: 16px;"><?php echo e($course->name); ?></span>
                    </div>
                    <?php if($course->description): ?>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Description</strong>
                        <span style="color: #e0e0e0; font-size: 16px;"><?php echo e($course->description); ?></span>
                    </div>
                    <?php endif; ?>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Credits</strong>
                        <span style="color: #e0e0e0; font-size: 16px;"><?php echo e($course->credits); ?></span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Fees</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">₵<?php echo e(number_format($course->fees, 2)); ?></span>
                    </div>
                </div>
                
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Statistics</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Enrolled Students</strong>
                        <span style="color: #e0e0e0; font-size: 24px; font-weight: 600;"><?php echo e($enrolledStudents); ?></span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Total Chapters</strong>
                        <span style="color: #e0e0e0; font-size: 24px; font-weight: 600;"><?php echo e($totalChapters); ?></span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Published Chapters</strong>
                        <span style="color: #e0e0e0; font-size: 24px; font-weight: 600;"><?php echo e($publishedChapters); ?></span>
                    </div>
                </div>
            </div>
            
            <!-- Course Chapters Section -->
            <div style="margin-top: 30px;">
                <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Course Chapters</h4>
                <?php if($course->chapters->count() > 0): ?>
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Chapter #</th>
                                <th>Title</th>
                                <th>Session</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $course->chapters->sortBy('order'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chapter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($chapter->chapter_number); ?></td>
                                    <td><strong><?php echo e($chapter->title); ?></strong></td>
                                    <td>Session <?php echo e($chapter->session_number); ?></td>
                                    <td>
                                        <?php if($chapter->is_published): ?>
                                            <span style="color: #6bff6b;">Published</span>
                                        <?php else: ?>
                                            <span style="color: #888;">Draft</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <p style="color: #888; text-align: center; padding: 20px;">No chapters added yet. Contact admin to add chapters.</p>
                <?php endif; ?>
            </div>
            
            <!-- Enrolled Students Section -->
            <div style="margin-top: 30px;">
                <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Enrolled Students</h4>
                <a href="<?php echo e(route('instructor.students.index')); ?>?course=<?php echo e($course->id); ?>" class="btn btn-primary" style="margin-bottom: 15px;">
                    <i class="fas fa-users"></i> View All Students
                </a>
                <?php if($course->enrollments->count() > 0): ?>
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Student Name</th>
                                <th>Email</th>
                                <th>School ID</th>
                                <th>Enrollment Date</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $course->enrollments->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enrollment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><a href="<?php echo e(route('instructor.students.show', $enrollment->student_id)); ?>" style="color: #4a9eff; text-decoration: none;"><?php echo e($enrollment->student->name); ?></a></td>
                                    <td><?php echo e($enrollment->student->email); ?></td>
                                    <td><?php echo e($enrollment->student->school_id ?? 'N/A'); ?></td>
                                    <td><?php echo e($enrollment->enrollment_date ? $enrollment->enrollment_date->format('M d, Y') : 'N/A'); ?></td>
                                    <td>
                                        <?php if($enrollment->status == 'active'): ?>
                                            <span style="color: #6bff6b;">Active</span>
                                        <?php else: ?>
                                            <span style="color: #888;"><?php echo e(ucfirst($enrollment->status)); ?></span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php if($course->enrollments->count() > 10): ?>
                        <p style="color: #888; text-align: center; margin-top: 15px;">
                            Showing first 10 of <?php echo e($course->enrollments->count()); ?> enrolled students. 
                            <a href="<?php echo e(route('instructor.students.index')); ?>?course=<?php echo e($course->id); ?>" style="color: #4a9eff;">View all students</a>
                        </p>
                    <?php endif; ?>
                <?php else: ?>
                    <p style="color: #888; text-align: center; padding: 20px;">No students enrolled yet.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.instructor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/instructor/courses/show.blade.php ENDPATH**/ ?>