

<?php $__env->startSection('title', 'Books'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-area">
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-book"></i> Available Books</h3>
        </div>

        <?php if($books->isEmpty()): ?>
            <div style="text-align: center; padding: 40px; color: #888;">
                <i class="fas fa-book-open" style="font-size: 48px; margin-bottom: 20px; opacity: 0.5;"></i>
                <p>No books available at the moment.</p>
            </div>
        <?php else: ?>
            <div class="books-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 25px; margin-top: 20px;">
                <?php $__currentLoopData = $books; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $book): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="book-card" style="background: linear-gradient(135deg, #2d2d2d 0%, #1a1a1a 100%); border: 1px solid #404040; border-radius: 12px; padding: 25px; transition: all 0.3s; cursor: pointer; position: relative; overflow: hidden;">
                        <a href="<?php echo e(route('student.books.show', $book)); ?>" style="text-decoration: none; color: inherit; display: block;">
                            <div style="position: relative; margin-bottom: 20px;">
                                <?php if($book->cover_image): ?>
                                    <img src="<?php echo e(asset($book->cover_image)); ?>" alt="<?php echo e($book->title); ?>" style="width: 100%; height: 200px; object-fit: cover; border-radius: 8px; border: 1px solid #404040;">
                                <?php else: ?>
                                    <div style="width: 100%; height: 200px; background: linear-gradient(135deg, #4a9eff 0%, #3a8eef 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                                        <i class="fas fa-book" style="font-size: 64px; color: white; opacity: 0.8;"></i>
                                    </div>
                                <?php endif; ?>
                                <div style="position: absolute; top: 10px; right: 10px; background: rgba(0,0,0,0.7); padding: 5px 10px; border-radius: 5px; font-size: 12px; color: #4a9eff;">
                                    <i class="fas fa-book-open"></i> <?php echo e($book->chapters->count()); ?> Chapters
                                </div>
                            </div>
                            
                            <h4 style="color: #4a9eff; font-size: 18px; margin-bottom: 10px; font-weight: 600;"><?php echo e($book->title); ?></h4>
                            
                            <?php if($book->author): ?>
                                <p style="color: #888; font-size: 13px; margin-bottom: 10px;">
                                    <i class="fas fa-user"></i> <?php echo e($book->author); ?>

                                </p>
                            <?php endif; ?>
                            
                            <?php if($book->description): ?>
                                <p style="color: #aaa; font-size: 14px; line-height: 1.5; margin-bottom: 15px; display: -webkit-box; -webkit-line-clamp: 3; -webkit-box-orient: vertical; overflow: hidden;">
                                    <?php echo e($book->description); ?>

                                </p>
                            <?php endif; ?>
                            
                            <div style="display: flex; align-items: center; justify-content: space-between; margin-top: 15px; padding-top: 15px; border-top: 1px solid #404040;">
                                <span style="color: #888; font-size: 12px;">
                                    <i class="fas fa-clock"></i> Last updated <?php echo e($book->updated_at->diffForHumans()); ?>

                                </span>
                                <span style="color: #4a9eff; font-size: 14px; font-weight: 500;">
                                    Read <i class="fas fa-arrow-right"></i>
                                </span>
                            </div>
                        </a>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
    .book-card:hover {
        transform: translateY(-5px);
        border-color: #4a9eff;
        box-shadow: 0 8px 30px rgba(74, 158, 255, 0.3);
    }

    @media (max-width: 768px) {
        .books-grid {
            grid-template-columns: 1fr !important;
        }
    }
</style>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.student', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/student/books/index.blade.php ENDPATH**/ ?>