

<?php $__env->startSection('title', 'Assignment Details'); ?>
<?php $__env->startSection('page-title', 'Assignment Details'); ?>

<?php $__env->startSection('content'); ?>
    <div style="margin-bottom: 20px; display: flex; gap: 10px;">
        <a href="<?php echo e(route('instructor.assignments.index')); ?>" class="btn btn-secondary">← Back to Assignments</a>
        <a href="<?php echo e(route('instructor.assignments.edit', $assignment->id)); ?>" class="btn btn-primary">
            <i class="fas fa-edit"></i> Edit
        </a>
        <a href="<?php echo e(route('instructor.assignments.submissions', $assignment->id)); ?>" class="btn btn-primary">
            <i class="fas fa-file-alt"></i> View Submissions (<?php echo e($totalSubmissions); ?>)
        </a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3><?php echo e($assignment->title); ?></h3>
        </div>
        
        <div style="padding: 30px;">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px; margin-bottom: 30px;">
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Assignment Information</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Course</strong>
                        <span style="color: #e0e0e0; font-size: 16px;"><?php echo e($assignment->course->name); ?> (<?php echo e($assignment->course->code); ?>)</span>
                    </div>
                    <?php if($assignment->chapter): ?>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Chapter</strong>
                        <span style="color: #e0e0e0; font-size: 16px;"><?php echo e($assignment->chapter->title); ?> (Chapter <?php echo e($assignment->chapter->chapter_number); ?>)</span>
                    </div>
                    <?php endif; ?>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Total Points</strong>
                        <span style="color: #e0e0e0; font-size: 16px;"><?php echo e(number_format($assignment->total_points, 0)); ?> points</span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Status</strong>
                        <?php if($assignment->is_published): ?>
                            <span style="color: #6bff6b; font-size: 16px;">Published</span>
                        <?php else: ?>
                            <span style="color: #888; font-size: 16px;">Draft</span>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Due Date & Statistics</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Due Date</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">
                            <?php echo e($assignment->due_date->format('M d, Y')); ?>

                            <?php if($assignment->due_time): ?>
                                <?php
                                    $dueTimeStr = is_string($assignment->due_time) ? $assignment->due_time : (is_object($assignment->due_time) ? $assignment->due_time->format('H:i') : $assignment->due_time);
                                ?>
                                at <?php echo e(date('h:i A', strtotime($dueTimeStr))); ?>

                            <?php endif; ?>
                        </span>
                        <?php if($assignment->isPastDue()): ?>
                            <span style="color: #ff6b6b; font-size: 14px; display: block; margin-top: 5px;">⚠ Past Due</span>
                        <?php endif; ?>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Enrolled Students</strong>
                        <span style="color: #e0e0e0; font-size: 24px; font-weight: 600;"><?php echo e($enrolledStudents); ?></span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Total Submissions</strong>
                        <span style="color: #e0e0e0; font-size: 24px; font-weight: 600;"><?php echo e($totalSubmissions); ?></span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Graded</strong>
                        <span style="color: #6bff6b; font-size: 24px; font-weight: 600;"><?php echo e($gradedSubmissions); ?></span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Pending</strong>
                        <span style="color: #ffc107; font-size: 24px; font-weight: 600;"><?php echo e($pendingSubmissions); ?></span>
                    </div>
                    <?php if($assignment->allow_late_submission): ?>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Late Submission</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">Allowed (<?php echo e($assignment->late_penalty_percentage); ?>% penalty per day)</span>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <?php if($assignment->description): ?>
            <div style="margin-top: 30px;">
                <h4 style="color: #4a9eff; margin-bottom: 15px;">Description</h4>
                <p style="color: #e0e0e0; line-height: 1.6;"><?php echo e($assignment->description); ?></p>
            </div>
            <?php endif; ?>
            
            <?php if($assignment->instructions): ?>
            <div style="margin-top: 30px;">
                <h4 style="color: #4a9eff; margin-bottom: 15px;">Instructions</h4>
                <div style="color: #e0e0e0; line-height: 1.6; white-space: pre-wrap;"><?php echo e($assignment->instructions); ?></div>
            </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.instructor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/instructor/assignments/show.blade.php ENDPATH**/ ?>