

<?php $__env->startSection('title', 'Student Finances'); ?>
<?php $__env->startSection('page-title', 'Student Finances Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>All Student Finances</h3>
            <a href="<?php echo e(route('admin.fee-payments.index')); ?>" class="btn btn-primary">View All Payments</a>
        </div>
        
        <!-- Summary Cards -->
        <div style="padding: 0 30px 20px 30px;">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 20px;">
                <div style="background: #1a1a1a; padding: 20px; border-radius: 8px; border: 1px solid #404040;">
                    <strong style="color: #888; display: block; margin-bottom: 8px;">Total Fees</strong>
                    <p style="font-size: 24px; font-weight: bold; color: #4a9eff;">₵<?php echo e(number_format($grandTotalFees, 2)); ?></p>
                </div>
                <div style="background: #1a1a1a; padding: 20px; border-radius: 8px; border: 1px solid #404040;">
                    <strong style="color: #888; display: block; margin-bottom: 8px;">Total Paid</strong>
                    <p style="font-size: 24px; font-weight: bold; color: #6bff6b;">₵<?php echo e(number_format($grandTotalPaid, 2)); ?></p>
                </div>
                <div style="background: #1a1a1a; padding: 20px; border-radius: 8px; border: 1px solid #404040;">
                    <strong style="color: #888; display: block; margin-bottom: 8px;">Total Balance</strong>
                    <p style="font-size: 24px; font-weight: bold; color: <?php echo e(($grandTotalFees - $grandTotalPaid) > 0 ? '#ff6b6b' : '#6bff6b'); ?>;">₵<?php echo e(number_format($grandTotalFees - $grandTotalPaid, 2)); ?></p>
                </div>
                <div style="background: #1a1a1a; padding: 20px; border-radius: 8px; border: 1px solid #404040;">
                    <strong style="color: #888; display: block; margin-bottom: 8px;">Actual Money at Hand</strong>
                    <p style="font-size: 24px; font-weight: bold; color: #4a9eff;">₵<?php echo e(number_format($grandTotalActualMoney, 2)); ?></p>
                    <small style="color: #888;">Excludes scholarships and refunds</small>
                </div>
            </div>
        </div>
        
        <!-- Filters -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="<?php echo e(route('admin.student-finances.index')); ?>" style="display: flex; flex-wrap: wrap; gap: 10px;">
                <input 
                    type="text" 
                    name="search" 
                    placeholder="Search by student name or school ID..." 
                    value="<?php echo e(request('search')); ?>"
                    style="flex: 1; min-width: 200px; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;"
                >
                <select name="course_id" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Courses</option>
                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($course->id); ?>" <?php echo e(request('course_id') == $course->id ? 'selected' : ''); ?>>
                            <?php echo e($course->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <select name="status" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Status</option>
                    <option value="paid" <?php echo e(request('status') == 'paid' ? 'selected' : ''); ?>>Paid</option>
                    <option value="partial" <?php echo e(request('status') == 'partial' ? 'selected' : ''); ?>>Partial</option>
                    <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                    <option value="overpaid" <?php echo e(request('status') == 'overpaid' ? 'selected' : ''); ?>>Overpaid</option>
                </select>
                <button type="submit" class="btn btn-primary">Filter</button>
                <?php if(request()->anyFilled(['search', 'course_id', 'status'])): ?>
                    <a href="<?php echo e(route('admin.student-finances.index')); ?>" class="btn btn-secondary">Clear</a>
                <?php endif; ?>
            </form>
        </div>
        
        <!-- Student Finances Table -->
        <div style="padding: 0 30px 30px 30px;">
            <?php if(count($studentFinances) > 0): ?>
                <?php $__currentLoopData = $studentFinances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $finance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card" style="margin-bottom: 20px;">
                        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
                            <div>
                                <h4 style="margin: 0; color: #e0e0e0;"><?php echo e($finance['student']->name); ?></h4>
                                <small style="color: #888;"><?php echo e($finance['student']->school_id ?? 'No School ID'); ?></small>
                            </div>
                            <div style="display: flex; gap: 20px; align-items: center;">
                                <div style="text-align: right;">
                                    <small style="color: #888; display: block;">Total Fees</small>
                                    <strong style="color: #4a9eff;">₵<?php echo e(number_format($finance['total_fees'], 2)); ?></strong>
                                </div>
                                <div style="text-align: right;">
                                    <small style="color: #888; display: block;">Paid</small>
                                    <strong style="color: #6bff6b;">₵<?php echo e(number_format($finance['total_paid'], 2)); ?></strong>
                                </div>
                                <div style="text-align: right;">
                                    <small style="color: #888; display: block;">Balance</small>
                                    <strong style="color: <?php echo e($finance['total_balance'] > 0 ? '#ff6b6b' : '#6bff6b'); ?>;">₵<?php echo e(number_format($finance['total_balance'], 2)); ?></strong>
                                </div>
                                <span style="padding: 6px 12px; border-radius: 4px; font-size: 12px; font-weight: bold;
                                    <?php if($finance['total_balance'] <= 0): ?>
                                        background: #1a3a1a; color: #6bff6b;
                                    <?php elseif($finance['total_paid'] > 0): ?>
                                        background: #3a3a1a; color: #ffa500;
                                    <?php else: ?>
                                        background: #3a1a1a; color: #ff6b6b;
                                    <?php endif; ?>
                                ">
                                    <?php if($finance['total_balance'] <= 0 && $finance['total_balance'] >= 0): ?>
                                        Paid
                                    <?php elseif($finance['total_balance'] < 0): ?>
                                        Overpaid
                                    <?php elseif($finance['total_paid'] > 0): ?>
                                        Partial
                                    <?php else: ?>
                                        Pending
                                    <?php endif; ?>
                                </span>
                            </div>
                        </div>
                        
                        <div style="padding: 20px;">
                            <table class="table" style="margin: 0;">
                                <thead>
                                    <tr>
                                        <th>Course</th>
                                        <th>Offering</th>
                                        <th>Fee</th>
                                        <th>Paid</th>
                                        <th>Balance</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $finance['courses']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courseFinance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><strong><?php echo e($courseFinance['course']->name); ?></strong><br><small><?php echo e($courseFinance['course']->code); ?></small></td>
                                            <td><?php echo e($courseFinance['offering']->name ?? 'N/A'); ?></td>
                                            <td>₵<?php echo e(number_format($courseFinance['fee'], 2)); ?></td>
                                            <td style="color: #6bff6b;">₵<?php echo e(number_format($courseFinance['paid'], 2)); ?></td>
                                            <td style="color: <?php echo e($courseFinance['balance'] > 0 ? '#ff6b6b' : '#6bff6b'); ?>;">₵<?php echo e(number_format($courseFinance['balance'], 2)); ?></td>
                                            <td>
                                                <button type="button" onclick="openPaymentModal(<?php echo e($finance['student']->id); ?>, '<?php echo e(addslashes($finance['student']->name)); ?>', <?php echo e($courseFinance['course']->id); ?>, '<?php echo e(addslashes($courseFinance['course']->name)); ?>', <?php echo e($courseFinance['fee']); ?>, <?php echo e($courseFinance['paid']); ?>, <?php echo e($courseFinance['balance']); ?>, <?php echo e($courseFinance['offering'] ? $courseFinance['offering']->id : 'null'); ?>)" 
                                                    class="btn btn-primary" style="padding: 6px 12px; font-size: 12px;">
                                                    Record Payment
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p>No student finances found.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Payment Modal -->
    <div id="paymentModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.8); z-index: 10000; align-items: center; justify-content: center;">
        <div style="background: #2d2d2d; padding: 30px; border-radius: 10px; max-width: 500px; width: 90%; max-height: 90vh; overflow-y: auto;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
                <h3>Record Payment</h3>
                <button onclick="closePaymentModal()" style="background: none; border: none; color: #e0e0e0; font-size: 24px; cursor: pointer;"><i class="fas fa-times"></i></button>
            </div>
            
            <form id="paymentForm" method="POST" action="<?php echo e(route('admin.fee-payments.store')); ?>">
                <?php echo csrf_field(); ?>
                <input type="hidden" id="student_id" name="student_id">
                <input type="hidden" id="course_id" name="course_id">
                <input type="hidden" id="course_offering_id" name="course_offering_id">
                
                <div style="margin-bottom: 20px; padding: 15px; background: #1a1a1a; border-radius: 5px;">
                    <strong>Student:</strong> <span id="student_name"></span><br>
                    <strong>Course:</strong> <span id="course_name"></span><br>
                    <strong>Course Fee:</strong> ₵<span id="course_fee"></span><br>
                    <strong>Already Paid:</strong> ₵<span id="already_paid"></span><br>
                    <strong>Balance:</strong> ₵<span id="balance"></span>
                </div>
                
                <div class="form-group">
                    <label for="amount">Payment Amount *</label>
                    <input type="number" id="amount" name="amount" step="0.01" min="0.01" required>
                </div>
                
                <div class="form-group">
                    <label for="payment_date">Payment Date *</label>
                    <input type="date" id="payment_date" name="payment_date" value="<?php echo e(date('Y-m-d')); ?>" required>
                </div>
                
                <div class="form-group">
                    <label for="payment_method">Payment Method *</label>
                    <select id="payment_method" name="payment_method" required>
                        <option value="cash">Cash</option>
                        <option value="bank_transfer">Bank Transfer</option>
                        <option value="card">Card</option>
                        <option value="online">Online</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="payment_status">Payment Status *</label>
                    <select id="payment_status" name="payment_status" required>
                        <option value="regular">Regular Payment</option>
                        <option value="scholarship">Scholarship</option>
                        <option value="refunded">Refunded</option>
                    </select>
                    <small style="color: #888; display: block; margin-top: 5px;">
                        Scholarship and Refunded payments don't count toward actual money at hand.
                    </small>
                </div>
                
                <div class="form-group">
                    <label for="transaction_reference">Transaction Reference</label>
                    <input type="text" id="transaction_reference" name="transaction_reference">
                </div>
                
                <div class="form-group">
                    <label for="notes">Notes</label>
                    <textarea id="notes" name="notes" rows="3"></textarea>
                </div>
                
                <div style="margin-top: 20px; display: flex; gap: 10px;">
                    <button type="submit" class="btn btn-primary">Record Payment</button>
                    <button type="button" onclick="closePaymentModal()" class="btn btn-secondary">Cancel</button>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    function openPaymentModal(studentId, studentName, courseId, courseName, courseFee, alreadyPaid, balance, offeringId) {
        console.log('Opening payment modal with:', {studentId, studentName, courseId, courseName, courseFee, alreadyPaid, balance, offeringId});
        
        var modal = document.getElementById('paymentModal');
        if (!modal) {
            alert('Payment modal not found! Please refresh the page.');
            console.error('Payment modal element not found in DOM');
            return;
        }
        
        try {
            document.getElementById('student_id').value = studentId || '';
            document.getElementById('course_id').value = courseId || '';
            document.getElementById('course_offering_id').value = (offeringId && offeringId !== 'null' && offeringId !== null) ? offeringId : '';
            document.getElementById('student_name').textContent = studentName || '';
            document.getElementById('course_name').textContent = courseName || '';
            document.getElementById('course_fee').textContent = parseFloat(courseFee || 0).toFixed(2);
            document.getElementById('already_paid').textContent = parseFloat(alreadyPaid || 0).toFixed(2);
            document.getElementById('balance').textContent = parseFloat(balance || 0).toFixed(2);
            
            var amountInput = document.getElementById('amount');
            if (amountInput) {
                amountInput.max = balance || 0;
                amountInput.value = '';
            }
            
            modal.style.display = 'flex';
            modal.style.zIndex = '10000';
            console.log('Modal should now be visible');
        } catch (error) {
            console.error('Error opening payment modal:', error);
            alert('Error opening payment form: ' + error.message);
        }
    }
    
    function closePaymentModal() {
        document.getElementById('paymentModal').style.display = 'none';
        document.getElementById('paymentForm').reset();
    }
    
    // Close modal when clicking outside
    document.getElementById('paymentModal')?.addEventListener('click', function(e) {
        if (e.target === this) {
            closePaymentModal();
        }
    });
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/admin/student-finances/index.blade.php ENDPATH**/ ?>