<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($notification->title); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background: linear-gradient(135deg, #4a9eff 0%, #6bff6b 100%);
            color: white;
            padding: 30px;
            text-align: center;
            border-radius: 10px 10px 0 0;
        }
        .content {
            background: #f9f9f9;
            padding: 30px;
            border: 1px solid #ddd;
            border-top: none;
        }
        .footer {
            background: #2d2d2d;
            color: #888;
            padding: 20px;
            text-align: center;
            font-size: 12px;
            border-radius: 0 0 10px 10px;
        }
        .priority-badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: bold;
            margin-bottom: 15px;
        }
        .priority-high {
            background: #ff6b6b;
            color: white;
        }
        .priority-urgent {
            background: #dc3545;
            color: white;
        }
        .priority-normal {
            background: #4a9eff;
            color: white;
        }
        .priority-low {
            background: #888;
            color: white;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1><?php echo e(\App\Models\Setting::get('system_name', config('app.name', 'Afrilen Technologies'))); ?></h1>
        <p>Announcement</p>
    </div>
    
    <div class="content">
        <div class="priority-badge priority-<?php echo e($notification->priority); ?>">
            <?php echo e(strtoupper($notification->priority)); ?>

        </div>
        
        <h2><?php echo e($notification->title); ?></h2>
        
        <div style="white-space: pre-wrap; margin-top: 20px;">
            <?php echo nl2br(e($notification->message)); ?>

        </div>
        
        <?php if($notification->sender): ?>
            <p style="margin-top: 30px; color: #888; font-size: 14px;">
                <strong>From:</strong> <?php echo e($notification->sender->name); ?>

            </p>
        <?php endif; ?>
    </div>
    
    <div class="footer">
        <p>This is an automated message from <?php echo e(\App\Models\Setting::get('system_name', config('app.name', 'Afrilen Technologies'))); ?></p>
        <p>Please do not reply to this email.</p>
    </div>
</body>
</html>

<?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/emails/announcement.blade.php ENDPATH**/ ?>