

<?php $__env->startSection('title', 'Edit Resource'); ?>
<?php $__env->startSection('page-title', 'Edit Resource'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3>Edit Resource</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <form method="POST" action="<?php echo e(route('admin.resources.update', $resource->id)); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                
                <div class="form-group">
                    <label for="title">Resource Title *</label>
                    <input 
                        type="text" 
                        id="title" 
                        name="title" 
                        value="<?php echo e(old('title', $resource->title)); ?>" 
                        required
                        autofocus
                        placeholder="e.g., Course Material - Flutter Basics"
                    >
                    <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label for="resource_type">What is this resource? (Optional)</label>
                    <input 
                        type="text" 
                        id="resource_type" 
                        name="resource_type" 
                        value="<?php echo e(old('resource_type', $resource->resource_type)); ?>" 
                        placeholder="e.g., Course Material, Assignment Template, Study Guide, Reference Document"
                    >
                    <?php $__errorArgs = ['resource_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label for="description">Description (Optional)</label>
                    <textarea 
                        id="description" 
                        name="description" 
                        rows="4"
                        placeholder="Provide a detailed description of this resource..."
                    ><?php echo e(old('description', $resource->description)); ?></textarea>
                    <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label>Current File</label>
                    <div style="background: #1a1a1a; padding: 15px; border-radius: 5px; margin-top: 10px;">
                        <strong><?php echo e($resource->file_name); ?></strong>
                        <small style="display: block; color: #888; margin-top: 5px;">
                            <?php echo e($resource->formatted_file_size); ?> | <?php echo e(strtoupper($resource->file_extension ?? 'N/A')); ?>

                        </small>
                    </div>
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label for="file">Replace File (Optional)</label>
                    <input 
                        type="file" 
                        id="file" 
                        name="file" 
                        accept="*/*"
                    >
                    <small style="color: #888; display: block; margin-top: 5px;">
                        Leave empty to keep current file. Maximum file size: 100MB. All file formats are accepted.
                    </small>
                    <?php $__errorArgs = ['file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label>Who can access this resource? *</label>
                    <div style="display: flex; gap: 20px; margin-top: 10px; flex-wrap: wrap;">
                        <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                            <input 
                                type="checkbox" 
                                name="accessible_by_roles[]" 
                                value="admin"
                                <?php echo e(in_array('admin', old('accessible_by_roles', $resource->accessible_by_roles ?? [])) ? 'checked' : ''); ?>

                            >
                            <span>Admin</span>
                        </label>
                        <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                            <input 
                                type="checkbox" 
                                name="accessible_by_roles[]" 
                                value="instructor"
                                <?php echo e(in_array('instructor', old('accessible_by_roles', $resource->accessible_by_roles ?? [])) ? 'checked' : ''); ?>

                            >
                            <span>Instructor</span>
                        </label>
                        <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                            <input 
                                type="checkbox" 
                                name="accessible_by_roles[]" 
                                value="student"
                                <?php echo e(in_array('student', old('accessible_by_roles', $resource->accessible_by_roles ?? [])) ? 'checked' : ''); ?>

                            >
                            <span>Student</span>
                        </label>
                    </div>
                    <?php $__errorArgs = ['accessible_by_roles'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <?php $__errorArgs = ['accessible_by_roles.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                        <input 
                            type="checkbox" 
                            name="is_active" 
                            value="1"
                            <?php echo e(old('is_active', $resource->is_active) ? 'checked' : ''); ?>

                        >
                        <span>Active (Resource will be visible to users)</span>
                    </label>
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 10px;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Update Resource
                    </button>
                    <a href="<?php echo e(route('admin.resources.index')); ?>" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/admin/resources/edit.blade.php ENDPATH**/ ?>