

<?php $__env->startSection('title', 'Course Offerings'); ?>
<?php $__env->startSection('page-title', 'Course Offerings Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>All Course Offerings</h3>
            <a href="<?php echo e(route('admin.course-offerings.create')); ?>" class="btn btn-primary">Add New Offering</a>
        </div>
        
        <!-- Filters and Search Form -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="<?php echo e(route('admin.course-offerings.index')); ?>" style="display: flex; flex-wrap: wrap; gap: 10px;">
                <input 
                    type="text" 
                    name="search" 
                    placeholder="Search by name or course..." 
                    value="<?php echo e(request('search')); ?>"
                    style="flex: 1; min-width: 200px; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;"
                >
                <select name="course_id" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Courses</option>
                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($course->id); ?>" <?php echo e(request('course_id') == $course->id ? 'selected' : ''); ?>>
                            <?php echo e($course->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <select name="status" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Status</option>
                    <option value="upcoming" <?php echo e(request('status') == 'upcoming' ? 'selected' : ''); ?>>Upcoming</option>
                    <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                    <option value="completed" <?php echo e(request('status') == 'completed' ? 'selected' : ''); ?>>Completed</option>
                    <option value="cancelled" <?php echo e(request('status') == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                </select>
                <button type="submit" class="btn btn-primary">Search</button>
                <?php if(request()->anyFilled(['search', 'course_id', 'status'])): ?>
                    <a href="<?php echo e(route('admin.course-offerings.index')); ?>" class="btn btn-secondary">Clear</a>
                <?php endif; ?>
            </form>
        </div>
        
        <!-- Course Offerings Table -->
        <div style="padding: 0 30px 30px 30px;">
            <?php if($offerings->count() > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Offering Name</th>
                            <th>Course</th>
                            <th>Start Date</th>
                            <th>End Date</th>
                            <th>Students</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $offerings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offering): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><strong><?php echo e($offering->name); ?></strong></td>
                                <td><?php echo e($offering->course->name); ?> (<?php echo e($offering->course->code); ?>)</td>
                                <td><?php echo e($offering->start_date->format('M d, Y')); ?></td>
                                <td><?php echo e($offering->end_date->format('M d, Y')); ?></td>
                                <td><?php echo e($offering->current_students); ?> / <?php echo e($offering->max_students > 0 ? $offering->max_students : '∞'); ?></td>
                                <td>
                                    <?php if($offering->status == 'active'): ?>
                                        <span style="color: #6bff6b;">Active</span>
                                    <?php elseif($offering->status == 'upcoming'): ?>
                                        <span style="color: #4a9eff;">Upcoming</span>
                                    <?php elseif($offering->status == 'completed'): ?>
                                        <span style="color: #888;">Completed</span>
                                    <?php else: ?>
                                        <span style="color: #ff6b6b;">Cancelled</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div style="display: flex; gap: 8px;">
                                        <a href="<?php echo e(route('admin.course-offerings.show', $offering->id)); ?>" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">View</a>
                                        <a href="<?php echo e(route('admin.course-offerings.edit', $offering->id)); ?>" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">Edit</a>
                                        <button type="button" onclick="openConfirmationModal('Delete Course Offering', 'Are you sure you want to delete <?php echo e(addslashes($offering->name)); ?>? This action cannot be undone.', '<?php echo e(route('admin.course-offerings.destroy', $offering->id)); ?>', 'DELETE')" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px; background: #dc3545; border: none;">
                                            <i class="fas fa-trash"></i> Delete
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                
                <!-- Pagination -->
                <div style="margin-top: 20px;">
                    <?php echo e($offerings->links()); ?>

                </div>
            <?php else: ?>
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p>No course offerings found.</p>
                    <a href="<?php echo e(route('admin.course-offerings.create')); ?>" class="btn btn-primary" style="margin-top: 15px;">Add First Offering</a>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .pagination {
        display: flex;
        gap: 8px;
        justify-content: center;
        list-style: none;
        padding: 0;
    }
    
    .pagination li {
        display: inline-block;
    }
    
    .pagination a, .pagination span {
        padding: 8px 12px;
        background: #2d2d2d;
        border: 1px solid #404040;
        border-radius: 5px;
        color: #e0e0e0;
        text-decoration: none;
        display: inline-block;
    }
    
    .pagination a:hover {
        background: #4a9eff;
        border-color: #4a9eff;
    }
    
    .pagination .active span {
        background: #4a9eff;
        border-color: #4a9eff;
        color: white;
    }
</style>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/admin/course-offerings/index.blade.php ENDPATH**/ ?>