<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Afrilen Technologies')); ?> - <?php echo $__env->yieldContent('title', 'Portal'); ?></title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Styles -->
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Figtree', sans-serif;
            background: #1a1a1a;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #e0e0e0;
        }
        
        .container {
            width: 100%;
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        .card {
            background: #2d2d2d;
            border-radius: 8px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.5);
            padding: 40px;
            border: 1px solid #404040;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: #e0e0e0;
        }
        
        input[type="text"],
        input[type="email"],
        input[type="password"],
        select {
            width: 100%;
            padding: 12px;
            background: #1a1a1a;
            border: 1px solid #404040;
            border-radius: 5px;
            font-size: 16px;
            color: #e0e0e0;
            transition: border-color 0.3s;
        }
        
        input:focus,
        select:focus {
            outline: none;
            border-color: #4a9eff;
        }
        
        input::placeholder {
            color: #888;
        }
        
        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .btn-primary {
            background: #4a9eff;
            color: white;
            width: 100%;
        }
        
        .btn-primary:hover {
            background: #3a8eef;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(74, 158, 255, 0.3);
        }
        
        .alert {
            padding: 12px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        
        .alert-danger {
            background: #3d1f1f;
            color: #ff6b6b;
            border: 1px solid #5a2a2a;
        }
        
        .alert-success {
            background: #1f3d1f;
            color: #6bff6b;
            border: 1px solid #2a5a2a;
        }
        
        .text-center {
            text-align: center;
        }
        
        .mb-4 {
            margin-bottom: 1.5rem;
        }
        
        .remember-me {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
        }
        
        .remember-me input {
            width: auto;
            margin-right: 8px;
        }
        
        .remember-me label {
            margin: 0;
        }
        
        h1, h2 {
            color: #e0e0e0;
        }
        
        a {
            color: #4a9eff;
            text-decoration: none;
        }
        
        a:hover {
            color: #3a8eef;
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="container">
        <?php echo $__env->yieldContent('content'); ?>
    </div>
    
    <!--Start of Tawk.to Script-->
    <script type="text/javascript">
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
    (function(){
    var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
    s1.async=true;
    s1.src='https://embed.tawk.to/692f31c7e58f1d197d894370/1jbg5ktd9';
    s1.charset='UTF-8';
    s1.setAttribute('crossorigin','*');
    s0.parentNode.insertBefore(s1,s0);
    })();
    </script>
    <!--End of Tawk.to Script-->
    
    <!-- Tawk.to Diagnostic Script (Remove after widget works) -->
    <script>
    setTimeout(function() {
        console.log('=== Tawk.to Diagnostic ===');
        if (typeof Tawk_API !== 'undefined') {
            console.log('✅ Tawk_API loaded');
        } else {
            console.log('❌ Tawk_API NOT loaded - Check domain restrictions in Tawk.to dashboard');
        }
        var iframe = document.querySelector('iframe[id*="tawk"]');
        console.log(iframe ? '✅ Widget iframe found' : '❌ Widget iframe NOT found - Check domain/agent status');
    }, 3000);
    </script>
</body>
</html>
<?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/layouts/app.blade.php ENDPATH**/ ?>