

<?php $__env->startSection('title', 'Assignments'); ?>
<?php $__env->startSection('page-title', 'My Assignments'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-tasks"></i> My Assignments</h3>
        </div>
        
        <!-- Filters -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="<?php echo e(route('student.assignments.index')); ?>" style="display: flex; gap: 10px; flex-wrap: wrap;">
                <select name="course_id" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Courses</option>
                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($course->id); ?>" <?php echo e(request('course_id') == $course->id ? 'selected' : ''); ?>><?php echo e($course->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <select name="status" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Status</option>
                    <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                    <option value="submitted" <?php echo e(request('status') == 'submitted' ? 'selected' : ''); ?>>Submitted</option>
                    <option value="graded" <?php echo e(request('status') == 'graded' ? 'selected' : ''); ?>>Graded</option>
                    <option value="overdue" <?php echo e(request('status') == 'overdue' ? 'selected' : ''); ?>>Overdue</option>
                </select>
                <button type="submit" class="btn btn-primary">Filter</button>
                <?php if(request()->anyFilled(['course_id', 'status'])): ?>
                    <a href="<?php echo e(route('student.assignments.index')); ?>" class="btn btn-secondary">Clear</a>
                <?php endif; ?>
            </form>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <?php if($assignments->count() > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Assignment</th>
                            <th>Course</th>
                            <th>Due Date</th>
                            <th>Points</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $assignments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $submission = $assignment->submissions->first();
                                $isSubmitted = $submission && in_array($submission->status, ['submitted', 'graded']);
                                $isPastDue = $assignment->due_date < now()->toDateString() && !$isSubmitted;
                            ?>
                            <tr>
                                <td>
                                    <strong><?php echo e($assignment->title); ?></strong>
                                    <?php if($assignment->chapter): ?>
                                        <br><small style="color: #888;">Chapter: <?php echo e($assignment->chapter->title); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($assignment->course->name); ?></td>
                                <td>
                                    <?php echo e($assignment->due_date->format('M d, Y')); ?>

                                    <?php if($assignment->due_time): ?>
                                        <br><small style="color: #888;"><?php echo e(date('h:i A', strtotime($assignment->due_time))); ?></small>
                                    <?php endif; ?>
                                    <?php if($isPastDue): ?>
                                        <br><span style="color: #ff6b6b; font-size: 11px;">⚠ Overdue</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(number_format($assignment->total_points, 0)); ?> pts</td>
                                <td>
                                    <?php if($submission && $submission->status == 'graded'): ?>
                                        <span style="color: #6bff6b;">Graded</span>
                                        <br><small style="color: #888;">Score: <?php echo e(number_format($submission->score, 1)); ?>/<?php echo e(number_format($assignment->total_points, 1)); ?></small>
                                    <?php elseif($isSubmitted): ?>
                                        <span style="color: #ffc107;">Submitted</span>
                                    <?php elseif($isPastDue): ?>
                                        <span style="color: #ff6b6b;">Overdue</span>
                                    <?php else: ?>
                                        <span style="color: #888;">Pending</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('student.assignments.show', $assignment->id)); ?>" class="btn btn-primary" style="padding: 6px 12px; font-size: 12px;">
                                        <i class="fas fa-eye"></i> View
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div style="margin-top: 20px;"><?php echo e($assignments->links()); ?></div>
            <?php else: ?>
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p><i class="fas fa-tasks" style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;"></i></p>
                    <p>No assignments found.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.student', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/student/assignments/index.blade.php ENDPATH**/ ?>