

<?php $__env->startSection('title', 'Take Quiz: ' . $quiz->title); ?>
<?php $__env->startSection('page-title', 'Test Your Brain'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .resume-modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.8);
        z-index: 10000;
        align-items: center;
        justify-content: center;
    }
    
    .resume-modal.show {
        display: flex;
    }
    
    .resume-modal-content {
        background: #2d2d2d;
        padding: 40px;
        border-radius: 12px;
        border: 1px solid #404040;
        max-width: 500px;
        width: 90%;
        text-align: center;
    }
    
    .resume-modal-content h3 {
        color: #4a9eff;
        margin-bottom: 20px;
        font-size: 24px;
    }
    
    .resume-modal-content p {
        color: #888;
        margin-bottom: 30px;
        line-height: 1.6;
    }
    
    .resume-stats {
        background: #1a1a1a;
        padding: 20px;
        border-radius: 8px;
        margin-bottom: 30px;
        border: 1px solid #404040;
    }
    
    .resume-stats-item {
        display: flex;
        justify-content: space-between;
        margin-bottom: 10px;
        color: #e0e0e0;
    }
    
    .resume-stats-item:last-child {
        margin-bottom: 0;
    }
    
    .resume-modal-actions {
        display: flex;
        gap: 15px;
        justify-content: center;
    }
    
    .resume-modal-actions button {
        padding: 12px 30px;
        border-radius: 6px;
        border: none;
        cursor: pointer;
        font-size: 15px;
        font-weight: 500;
        transition: all 0.3s;
    }
    
    .btn-continue {
        background: #4a9eff;
        color: white;
    }
    
    .btn-continue:hover {
        background: #3a8eef;
    }
    
    .btn-start-over {
        background: #2d2d2d;
        color: #e0e0e0;
        border: 1px solid #404040;
    }
    
    .btn-start-over:hover {
        background: #3d3d3d;
        border-color: #4a9eff;
    }
    
    .quiz-container {
        max-width: 900px;
        margin: 0 auto;
    }
    
    .quiz-header {
        background: #2d2d2d;
        padding: 25px;
        border-radius: 8px;
        margin-bottom: 30px;
        border: 1px solid #404040;
    }
    
    .quiz-header h2 {
        color: #4a9eff;
        margin-bottom: 10px;
    }
    
    .quiz-info {
        display: flex; 
        flex-wrap: wrap; 
        gap: 20px; 
        margin-top: 15px;
        font-size: 14px;
        color: #888;
    }
    
    .question-container {
        background: #2d2d2d;
        padding: 30px;
        border-radius: 8px;
        margin-bottom: 25px;
        border: 1px solid #404040;
        min-height: 400px;
    }
    
    .question-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 25px;
        padding-bottom: 15px;
        border-bottom: 1px solid #404040;
    }
    
    .question-number {
        display: inline-block;
        background: #4a9eff;
        color: white;
        padding: 8px 16px;
        border-radius: 4px;
        font-size: 14px;
        font-weight: bold;
    }
    
    .question-text {
        font-size: 20px;
        font-weight: 500;
        margin-bottom: 30px;
        color: #e0e0e0;
        line-height: 1.6;
    }
    
    .answer-option {
        display: block;
        padding: 18px 25px;
        margin-bottom: 15px;
        background: #1a1a1a;
        border: 2px solid #404040;
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.3s;
        color: #e0e0e0;
        font-size: 16px;
    }
    
    .answer-option:hover:not(.disabled) {
        border-color: #4a9eff;
        background: #2a2a3a;
        transform: translateX(5px);
    }
    
    .answer-option.selected {
        border-color: #4a9eff;
        background: #2a2a3a;
    }
    
    .answer-option.correct {
        border-color: #6bff6b;
        background: #1a3a1a;
        color: #6bff6b;
    }
    
    .answer-option.incorrect {
        border-color: #ff6b6b;
        background: #3a1a1a;
        color: #ff6b6b;
    }
    
    .answer-option.disabled {
        cursor: not-allowed;
        opacity: 0.6;
    }
    
    .feedback-message {
        margin-top: 20px;
        padding: 20px;
        border-radius: 8px;
        display: none;
        animation: slideDown 0.3s ease;
    }
    
    @keyframes  slideDown {
        from {
            opacity: 0;
            transform: translateY(-10px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    .feedback-message.show {
        display: block;
    }
    
    .feedback-message.correct {
        background: #1a3a1a;
        border: 1px solid #6bff6b;
        color: #6bff6b;
    }
    
    .feedback-message.incorrect {
        background: #3a1a1a;
        border: 1px solid #ff6b6b;
        color: #ff6b6b;
    }
    
    .explanation {
        margin-top: 15px;
        padding-top: 15px;
        border-top: 1px solid #404040;
        color: #888;
        font-size: 14px;
        font-style: italic;
    }
    
    .quiz-progress {
        background: #2d2d2d;
        padding: 20px;
        border-radius: 8px;
        margin-bottom: 30px;
        border: 1px solid #404040;
    }
    
    .progress-bar {
        width: 100%;
        height: 10px;
        background: #1a1a1a;
        border-radius: 5px;
        overflow: hidden;
        margin-top: 10px;
    }
    
    .progress-fill {
        height: 100%;
        background: linear-gradient(90deg, #4a9eff, #6bff6b);
        transition: width 0.3s;
    }
    
    .quiz-navigation {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 30px;
        padding-top: 20px;
        border-top: 1px solid #404040;
    }
    
    .nav-button {
        padding: 12px 24px;
        border-radius: 6px;
        border: none;
        cursor: pointer;
        font-size: 15px;
        font-weight: 500;
        transition: all 0.3s;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .nav-button:disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }
    
    .btn-prev {
        background: #2d2d2d;
        color: #e0e0e0;
        border: 1px solid #404040;
    }
    
    .btn-prev:hover:not(:disabled) {
        background: #3d3d3d;
        border-color: #4a9eff;
    }
    
    .btn-next {
        background: #4a9eff;
        color: white;
    }
    
    .btn-next:hover:not(:disabled) {
        background: #3a8eef;
    }
    
    .btn-complete {
        background: #6bff6b;
        color: #1a1a1a;
        font-weight: bold;
    }
    
    .btn-complete:hover:not(:disabled) {
        background: #5bef5b;
    }
    
    .bookmark-btn {
        font-size: 13px;
    }
    
    .bookmark-btn:hover {
        border-color: #4a9eff !important;
        color: #4a9eff !important;
    }
    
    .bookmark-btn.bookmarked {
        background: #4a9eff !important;
        border-color: #4a9eff !important;
        color: white !important;
    }
    
    .quiz-actions {
        position: sticky;
        bottom: 0;
        background: #1a1a1a;
        padding: 20px;
        border-top: 1px solid #404040;
        margin-top: 30px;
        display: flex;
        justify-content: center;
        align-items: center;
        flex-wrap: wrap;
        gap: 15px;
    }
    
    .btn-back-quizzes {
        display: inline-flex;
        align-items: center;
        gap: 10px;
        padding: 14px 28px;
        background: linear-gradient(135deg, #2d2d2d 0%, #1a1a1a 100%);
        color: #e0e0e0;
        border: 2px solid #404040;
        border-radius: 8px;
        font-size: 15px;
        font-weight: 500;
        text-decoration: none;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.3);
    }
    
    .btn-back-quizzes:hover {
        background: linear-gradient(135deg, #3d3d3d 0%, #2d2d2d 100%);
        border-color: #4a9eff;
        color: #4a9eff;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(74, 158, 255, 0.2);
    }
    
    .btn-back-quizzes i {
        font-size: 16px;
        transition: transform 0.3s ease;
    }
    
    .btn-back-quizzes:hover i {
        transform: translateX(-3px);
    }
    
    @media (max-width: 768px) {
        .quiz-header {
            padding: 20px;
        }
        
        .question-container {
            padding: 20px;
            min-height: 300px;
        }
        
        .answer-option {
            padding: 15px 20px;
            font-size: 15px;
        }
        
        .quiz-navigation {
            flex-direction: column;
            gap: 15px;
        }
        
        .nav-button {
            width: 100%;
            justify-content: center;
        }
        
        .quiz-actions {
            flex-direction: column;
            padding: 15px;
        }
        
        .btn-back-quizzes {
            width: 100%;
            justify-content: center;
            padding: 12px 24px;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <?php
        $hasExistingAttempt = isset($answeredQuestionIds) && count($answeredQuestionIds) > 0;
        $progressPercentage = $hasExistingAttempt ? round((count($answeredQuestionIds) / $questions->count()) * 100, 1) : 0;
    ?>
    
    <!-- Resume Modal -->
    <?php if($hasExistingAttempt && !request()->has('start_over')): ?>
    <div class="resume-modal show" id="resume-modal">
        <div class="resume-modal-content">
            <h3><i class="fas fa-history"></i> Continue Quiz?</h3>
            <p>You have an incomplete attempt for this quiz. Would you like to continue where you left off or start over?</p>
            
            <div class="resume-stats">
                <div class="resume-stats-item">
                    <span>Questions Answered:</span>
                    <strong><?php echo e(count($answeredQuestionIds)); ?> / <?php echo e($questions->count()); ?></strong>
                </div>
                <div class="resume-stats-item">
                    <span>Progress:</span>
                    <strong><?php echo e($progressPercentage); ?>%</strong>
                </div>
                <div class="resume-stats-item">
                    <span>Started:</span>
                    <strong><?php echo e(($attempt->started_at ?? $attempt->created_at)->diffForHumans()); ?></strong>
                </div>
            </div>
            
            <div class="resume-modal-actions">
                <button type="button" class="btn-continue" onclick="continueQuiz()">
                    <i class="fas fa-play"></i> Continue
                </button>
                <button type="button" class="btn-start-over" onclick="startOver()">
                    <i class="fas fa-redo"></i> Start Over
                </button>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <div class="quiz-container" id="quiz-container" style="<?php echo e($hasExistingAttempt && !request()->has('start_over') ? 'display: none;' : ''); ?>; position: relative;">
        <?php if(isset($mode) && $mode === 'study'): ?>
        <div style="background: linear-gradient(135deg, #6bff6b 0%, #4a9eff 100%); padding: 15px; border-radius: 8px; margin-bottom: 20px; text-align: center; color: #1a1a1a; font-weight: bold;">
            <i class="fas fa-book-reader"></i> STUDY MODE - Practice without affecting your scores
        </div>
        <?php endif; ?>
        
        <div class="quiz-header">
            <h2><?php echo e($quiz->title); ?></h2>
            <?php if($quiz->description): ?>
                <p style="color: #888; margin-bottom: 10px;"><?php echo e($quiz->description); ?></p>
            <?php endif; ?>
            <div class="quiz-info">
                <span><i class="fas fa-layer-group"></i> Level: <strong><?php echo e($quiz->level_name); ?></strong></span>
                <span><i class="fas fa-question-circle"></i> Questions: <strong><?php echo e($questions->count()); ?></strong></span>
                <?php if($quiz->course): ?>
                    <span><i class="fas fa-book"></i> Course: <strong><?php echo e($quiz->course->name); ?></strong></span>
                <?php endif; ?>
            </div>
        </div>
        
        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 30px;">
            <div class="quiz-progress">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 5px;">
                    <span style="color: #888; font-size: 14px;">Progress</span>
                    <span id="progress-text" style="color: #4a9eff; font-weight: bold;">0 / <?php echo e($questions->count()); ?></span>
                </div>
                <div class="progress-bar">
                    <div class="progress-fill" id="progress-fill" style="width: 0%;"></div>
                </div>
            </div>
            
            <?php if($quiz->time_limit_minutes): ?>
            <div class="quiz-progress" id="timer-container">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 5px;">
                    <span style="color: #888; font-size: 14px;">Time Remaining</span>
                    <span id="timer-text" style="color: #4a9eff; font-weight: bold; font-size: 18px;"><?php echo e($quiz->time_limit_minutes); ?>:00</span>
                </div>
                <div class="progress-bar">
                    <div class="progress-fill" id="timer-fill" style="width: 100%; background: linear-gradient(90deg, #6bff6b, #4a9eff);"></div>
                </div>
            </div>
            <?php endif; ?>
        </div>
        
        <form id="quiz-form" method="POST" action="<?php echo e(route('student.quizzes.complete', $quiz->id)); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="attempt_id" value="<?php echo e($attempt->id); ?>">
            <input type="hidden" name="mode" value="<?php echo e($mode ?? 'regular'); ?>">
            
            <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="question-container" 
                     id="question-<?php echo e($question->id); ?>" 
                     data-question-id="<?php echo e($question->id); ?>"
                     data-question-index="<?php echo e($index); ?>"
                     style="display: <?php echo e($index === 0 ? 'block' : 'none'); ?>;">
                    <div class="question-header">
                        <span class="question-number">Question <?php echo e($index + 1); ?> of <?php echo e($questions->count()); ?></span>
                        <button type="button" 
                                class="bookmark-btn" 
                                id="bookmark-btn-<?php echo e($question->id); ?>"
                                onclick="toggleQuestionBookmark(<?php echo e($question->id); ?>)"
                                style="background: transparent; border: 1px solid #404040; color: #888; padding: 6px 12px; border-radius: 5px; cursor: pointer; transition: all 0.3s;">
                            <i class="far fa-bookmark"></i> Bookmark
                        </button>
                    </div>
                    
                    <div class="question-text"><?php echo e($question->question); ?></div>
                    
                    <div class="answers-container">
                        <?php $__currentLoopData = $question->answers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label class="answer-option" 
                                   data-answer-id="<?php echo e($answer->id); ?>" 
                                   data-is-correct="<?php echo e($answer->is_correct ? 'true' : 'false'); ?>">
                                <input type="radio" 
                                       name="question_<?php echo e($question->id); ?>" 
                                       value="<?php echo e($answer->id); ?>" 
                                       style="display: none;"
                                       data-question-id="<?php echo e($question->id); ?>">
                                <span><?php echo e($answer->answer_text); ?></span>
                            </label>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    
                    <div class="feedback-message" id="feedback-<?php echo e($question->id); ?>">
                        <div class="feedback-content"></div>
                        <?php if($question->explanation): ?>
                            <div class="explanation">
                                <strong>Explanation:</strong> <?php echo e($question->explanation); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="quiz-navigation">
                        <button type="button" 
                                class="nav-button btn-prev" 
                                onclick="showPreviousQuestion()"
                                <?php echo e($index === 0 ? 'disabled' : ''); ?>>
                            <i class="fas fa-arrow-left"></i> Previous
                        </button>
                        <?php if($index < $questions->count() - 1): ?>
                            <button type="button" 
                                    class="nav-button btn-next" 
                                    onclick="showNextQuestion()"
                                    id="next-btn-<?php echo e($question->id); ?>"
                                    disabled>
                                Next <i class="fas fa-arrow-right"></i>
                            </button>
                        <?php else: ?>
                            <button type="submit" 
                                    class="nav-button btn-complete" 
                                    id="submit-btn"
                                    <?php echo e($answeredQuestionIds && count($answeredQuestionIds) >= $questions->count() ? '' : 'disabled'); ?>>
                                <i class="fas fa-check-circle"></i> Complete Quiz
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </form>
        
        <div class="quiz-actions">
            <a href="<?php echo e(route('student.quizzes.index')); ?>" class="btn-back-quizzes">
                <i class="fas fa-arrow-left"></i> 
                <span>Back to Quizzes</span>
            </a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<!-- Confetti Library -->
<script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.9.2/dist/confetti.browser.min.js"></script>
<script>
    // Wait for confetti to load
    window.addEventListener('load', function() {
        if (typeof confetti === 'undefined') {
            console.warn('Confetti library failed to load');
        }
    });
</script>

<script>
    let currentQuestionIndex = 0;
    let answeredQuestions = new Set(<?php echo json_encode(array_map('strval', $answeredQuestionIds ?? []), 512) ?>);
    const totalQuestions = <?php echo e($questions->count()); ?>;
    const questions = <?php echo json_encode($questions->map(function($q) {
        return [
            'id' => $q->id, 'answers' => $q->answers->map(function($a) {
                return ['id' => $a->id, 'is_correct' => $a->is_correct];
            })
        ];
    })) ?>;
    
    // Load saved answers from attempt
    const savedAnswers = <?php echo json_encode($attempt->attemptAnswers->pluck('answer_id', 'question_id')->toArray(), 512) ?>;
    
    // Load bookmarked questions
    const bookmarkedQuestions = <?php echo json_encode($bookmarkedQuestionIds ?? [], 15, 512) ?>;
    
    // Initialize bookmarks on page load
    bookmarkedQuestions.forEach(questionId => {
        const btn = document.getElementById(`bookmark-btn-${questionId}`);
        if (btn) {
            btn.classList.add('bookmarked');
            btn.innerHTML = '<i class="fas fa-bookmark"></i> Bookmarked';
        }
    });
    
    // Toggle bookmark function
    function toggleQuestionBookmark(questionId) {
        const btn = document.getElementById(`bookmark-btn-${questionId}`);
        const isBookmarked = btn.classList.contains('bookmarked');
        
        fetch(`/student/quizzes/questions/${questionId}/bookmark`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                if (data.is_bookmarked) {
                    btn.classList.add('bookmarked');
                    btn.innerHTML = '<i class="fas fa-bookmark"></i> Bookmarked';
                } else {
                    btn.classList.remove('bookmarked');
                    btn.innerHTML = '<i class="far fa-bookmark"></i> Bookmark';
                }
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred. Please try again.');
        });
    }
    
    // Modal functions
    function continueQuiz() {
        document.getElementById('resume-modal').classList.remove('show');
        document.getElementById('quiz-container').style.display = 'block';
        restoreProgress();
    }
    
    function startOver() {
        window.location.href = '<?php echo e(route("student.quizzes.show", ["quiz" => $quiz->id, "start_over" => 1])); ?>';
    }
    
    // Restore progress when continuing
    function restoreProgress() {
        // Find first unanswered question
        let firstUnansweredIndex = 0;
        const questionContainers = document.querySelectorAll('.question-container');
        
        questionContainers.forEach((container, index) => {
            const questionId = parseInt(container.dataset.questionId);
            
            if (savedAnswers[questionId]) {
                // Restore this answered question
                restoreQuestionAnswer(container, questionId, savedAnswers[questionId]);
                
                // Check if this is the first unanswered question
                if (index >= firstUnansweredIndex && !answeredQuestions.has(questionId.toString())) {
                    firstUnansweredIndex = index + 1;
                }
            }
        });
        
        // Show first unanswered question or last question if all answered
        if (firstUnansweredIndex >= questionContainers.length) {
            firstUnansweredIndex = questionContainers.length - 1;
        }
        
        showQuestion(firstUnansweredIndex);
        updateProgress();
    }
    
    // Restore a single question's answer
    function restoreQuestionAnswer(container, questionId, answerId) {
        const answerOption = container.querySelector(`[data-answer-id="${answerId}"]`);
        if (!answerOption) return;
        
        const radio = answerOption.querySelector('input[type="radio"]');
        if (!radio) return;
        
        // Mark as selected
        radio.checked = true;
        answerOption.classList.add('selected');
        
        // Disable all options
        container.querySelectorAll('.answer-option').forEach(opt => {
            opt.classList.add('disabled');
            opt.style.pointerEvents = 'none';
        });
        
        // Get correct/incorrect status from saved answer
        const isCorrect = answerOption.dataset.isCorrect === 'true';
        
        if (isCorrect) {
            answerOption.classList.add('correct');
            container.classList.add('correct');
        } else {
            answerOption.classList.add('incorrect');
            container.classList.add('incorrect');
            
            // Highlight correct answer
            const correctOption = container.querySelector('[data-is-correct="true"]');
            if (correctOption) {
                correctOption.classList.add('correct');
            }
        }
        
        // Show feedback
        const feedbackDiv = document.getElementById(`feedback-${questionId}`);
        if (feedbackDiv) {
            feedbackDiv.classList.add('show');
            feedbackDiv.classList.add(isCorrect ? 'correct' : 'incorrect');
            
            const feedbackContent = feedbackDiv.querySelector('.feedback-content');
            if (feedbackContent) {
                if (isCorrect) {
                    feedbackContent.innerHTML = '<i class="fas fa-check-circle"></i> <strong>Correct!</strong> Well done.';
                } else {
                    const correctOption = container.querySelector('[data-is-correct="true"]');
                    const correctText = correctOption ? correctOption.querySelector('span').textContent : '';
                    feedbackContent.innerHTML = '<i class="fas fa-times-circle"></i> <strong>Incorrect.</strong> ' + 
                        (correctText ? 'The correct answer is: <strong>' + correctText + '</strong>' : '');
                }
            }
        }
        
        // Enable next button
        const nextBtn = container.querySelector('.btn-next');
        if (nextBtn) {
            nextBtn.disabled = false;
        }
        
        // Enable submit button if on last question
        const submitBtn = container.querySelector('.btn-complete');
        if (submitBtn && answeredQuestions.size === totalQuestions - 1) {
            submitBtn.disabled = false;
        }
        
        // Track as answered
        answeredQuestions.add(questionId.toString());
    }
    
    function showQuestion(index) {
        // Hide all questions
        document.querySelectorAll('.question-container').forEach(q => {
            q.style.display = 'none';
        });
        
        // Show current question
        const questionContainer = document.querySelectorAll('.question-container')[index];
        if (questionContainer) {
            questionContainer.style.display = 'block';
            currentQuestionIndex = index;
            
            // Update previous button
            const prevBtn = questionContainer.querySelector('.btn-prev');
            if (prevBtn) {
                prevBtn.disabled = index === 0;
            }
        }
        
        updateProgress();
    }
    
    function showNextQuestion() {
        if (currentQuestionIndex < totalQuestions - 1) {
            showQuestion(currentQuestionIndex + 1);
        }
    }
    
    function showPreviousQuestion() {
        if (currentQuestionIndex > 0) {
            showQuestion(currentQuestionIndex - 1);
        }
    }
    
    function updateProgress() {
        const answered = answeredQuestions.size;
        const percentage = (answered / totalQuestions) * 100;
        
        document.getElementById('progress-text').textContent = `${answered} / ${totalQuestions}`;
        document.getElementById('progress-fill').style.width = percentage + '%';
    }
    
    // Handle answer selection
    document.querySelectorAll('.answer-option').forEach(option => {
        option.addEventListener('click', function() {
            const questionContainer = this.closest('.question-container');
            const questionId = questionContainer.dataset.questionId;
            const answerId = this.dataset.answerId;
            const isCorrect = this.dataset.isCorrect === 'true';
            const radio = this.querySelector('input[type="radio"]');
            
            // If already answered, don't allow changes
            if (answeredQuestions.has(questionId)) {
                return;
            }
            
            // Disable all options in this question
            questionContainer.querySelectorAll('.answer-option').forEach(opt => {
                opt.classList.add('disabled');
                opt.style.pointerEvents = 'none';
            });
            
            // Mark selected answer
            radio.checked = true;
            this.classList.add('selected');
            
            // Submit answer via AJAX
            fetch('<?php echo e(route("student.quizzes.submit-answer", $quiz->id)); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Accept': 'application/json',
                },
                body: JSON.stringify({
                    question_id: parseInt(questionId),
                    answer_id: parseInt(answerId),
                    attempt_id: <?php echo e($attempt->id); ?>

                })
            })
            .then(async response => {
                // Check if response is ok
                if (!response.ok) {
                    let errorMessage = 'Server error';
                    try {
                        const errorData = await response.json();
                        errorMessage = errorData.error || errorData.message || errorMessage;
                    } catch (e) {
                        errorMessage = `HTTP ${response.status}: ${response.statusText}`;
                    }
                    throw new Error(errorMessage);
                }
                
                // Try to parse JSON
                try {
                    return await response.json();
                } catch (e) {
                    throw new Error('Invalid response from server');
                }
            })
            .then(data => {
                if (data.error) {
                    throw new Error(data.error);
                }
                
                // Mark correct/incorrect
                if (data.is_correct) {
                    this.classList.add('correct');
                    questionContainer.classList.add('correct');
                    
                    // Trigger confetti animation for correct answer (with delay to ensure DOM is updated)
                    setTimeout(() => {
                        if (typeof triggerConfetti === 'function') {
                            triggerConfetti();
                        } else {
                            console.warn('triggerConfetti function not found');
                        }
                    }, 100);
                } else {
                    this.classList.add('incorrect');
                    questionContainer.classList.add('incorrect');
                    
                    // Highlight correct answer
                    if (data.correct_answer) {
                        const correctOption = questionContainer.querySelector(`[data-answer-id="${data.correct_answer.id}"]`);
                        if (correctOption) {
                            correctOption.classList.add('correct');
                        }
                    }
                }
                
                // Show feedback
                const feedbackDiv = document.getElementById(`feedback-${questionId}`);
                if (feedbackDiv) {
                    feedbackDiv.classList.add('show');
                    feedbackDiv.classList.add(data.is_correct ? 'correct' : 'incorrect');
                    
                    const feedbackContent = feedbackDiv.querySelector('.feedback-content');
                    if (feedbackContent) {
                        if (data.is_correct) {
                            feedbackContent.innerHTML = '<i class="fas fa-check-circle"></i> <strong>Correct!</strong> Well done.';
                        } else {
                            feedbackContent.innerHTML = '<i class="fas fa-times-circle"></i> <strong>Incorrect.</strong> ' + 
                                (data.correct_answer ? 'The correct answer is: <strong>' + data.correct_answer.text + '</strong>' : '');
                        }
                    }
                }
                
                // Track answered questions (ensure it's a string for Set)
                answeredQuestions.add(questionId.toString());
                updateProgress();
                
                // Enable next button or submit button
                const nextBtn = questionContainer.querySelector('.btn-next');
                const submitBtn = questionContainer.querySelector('.btn-complete');
                
                if (nextBtn) {
                    nextBtn.disabled = false;
                    nextBtn.removeAttribute('disabled');
                    nextBtn.style.opacity = '1';
                    nextBtn.style.cursor = 'pointer';
                }
                if (submitBtn) {
                    // Check if all questions are answered
                    if (answeredQuestions.size === totalQuestions) {
                        submitBtn.disabled = false;
                        submitBtn.removeAttribute('disabled');
                        submitBtn.style.opacity = '1';
                        submitBtn.style.cursor = 'pointer';
                    }
                }
            })
            .catch(error => {
                console.error('Error:', error);
                // Re-enable options on error
                questionContainer.querySelectorAll('.answer-option').forEach(opt => {
                    opt.classList.remove('disabled');
                    opt.style.pointerEvents = 'auto';
                });
                this.classList.remove('selected');
                if (radio) radio.checked = false;
                alert('An error occurred: ' + (error.message || 'Please try again.'));
            });
        });
    });
    
    // Handle form submission
    document.getElementById('quiz-form').addEventListener('submit', function(e) {
        const answered = answeredQuestions.size;
        if (answered < totalQuestions) {
            e.preventDefault();
            if (confirm(`You have answered ${answered} out of ${totalQuestions} questions. Are you sure you want to submit?`)) {
                // Allow submission
                e.target.submit();
            }
        } else {
            // All questions answered, allow submission
            console.log('Submitting quiz with', answered, 'answered questions');
        }
    });
    
    // Confetti animation function - constrained to quiz container
    function triggerConfetti() {
        // Check if confetti library is loaded
        if (typeof confetti === 'undefined') {
            console.warn('Confetti library not loaded');
            return;
        }
        
        const quizContainer = document.getElementById('quiz-container');
        if (!quizContainer) {
            console.warn('Quiz container not found');
            return;
        }
        
        try {
            // Get container position and dimensions
            const rect = quizContainer.getBoundingClientRect();
            const containerWidth = rect.width;
            const containerHeight = rect.height;
            const containerLeft = rect.left;
            const containerTop = rect.top;
            
            // Calculate relative positions within viewport (0-1 range)
            const leftX = containerLeft / window.innerWidth;
            const rightX = (containerLeft + containerWidth) / window.innerWidth;
            const centerX = (containerLeft + containerWidth / 2) / window.innerWidth;
            const centerY = (containerTop + containerHeight / 2) / window.innerHeight;
            const topY = containerTop / window.innerHeight;
            
            // Create bursts of confetti from multiple points
            // Confetti from left
            confetti({
                particleCount: 50,
                angle: 60,
                spread: 55,
                origin: { x: leftX, y: centerY },
                colors: ['#4a9eff', '#6bff6b', '#ffa500', '#ff6b6b', '#9b59b6']
            });
            
            // Confetti from right
            confetti({
                particleCount: 50,
                angle: 120,
                spread: 55,
                origin: { x: rightX, y: centerY },
                colors: ['#4a9eff', '#6bff6b', '#ffa500', '#ff6b6b', '#9b59b6']
            });
            
            // Confetti from center
            confetti({
                particleCount: 100,
                angle: 90,
                spread: 60,
                origin: { x: centerX, y: centerY },
                colors: ['#4a9eff', '#6bff6b', '#ffa500', '#ff6b6b', '#9b59b6']
            });
            
            // Additional burst from top after delay
            setTimeout(() => {
                confetti({
                    particleCount: 100,
                    spread: 70,
                    origin: { x: centerX, y: topY },
                    colors: ['#4a9eff', '#6bff6b', '#ffa500', '#ff6b6b', '#9b59b6']
                });
            }, 250);
        } catch (error) {
            console.error('Confetti error:', error);
            // Fallback to simple confetti
            try {
                confetti({
                    particleCount: 100,
                    spread: 70,
                    origin: { y: 0.6 },
                    colors: ['#4a9eff', '#6bff6b', '#ffa500', '#ff6b6b', '#9b59b6']
                });
            } catch (e) {
                console.error('Fallback confetti also failed:', e);
            }
        }
    }
    
    // Timer functionality
    <?php if($quiz->time_limit_minutes): ?>
    let timeLimitMinutes = <?php echo e($quiz->time_limit_minutes); ?>;
    let timeRemainingSeconds = timeLimitMinutes * 60;
    let timerInterval = null;
    
    function startTimer() {
        timerInterval = setInterval(() => {
            timeRemainingSeconds--;
            
            if (timeRemainingSeconds <= 0) {
                clearInterval(timerInterval);
                // Auto-submit quiz
                alert('Time is up! Your quiz will be submitted automatically.');
                document.getElementById('quiz-form').submit();
                return;
            }
            
            updateTimerDisplay();
        }, 1000);
    }
    
    function updateTimerDisplay() {
        const minutes = Math.floor(timeRemainingSeconds / 60);
        const seconds = timeRemainingSeconds % 60;
        const formattedTime = `${minutes}:${seconds.toString().padStart(2, '0')}`;
        
        document.getElementById('timer-text').textContent = formattedTime;
        
        // Update progress bar
        const percentage = (timeRemainingSeconds / (timeLimitMinutes * 60)) * 100;
        document.getElementById('timer-fill').style.width = percentage + '%';
        
        // Change color when time is running low
        if (timeRemainingSeconds <= 60) {
            document.getElementById('timer-text').style.color = '#ff6b6b';
            document.getElementById('timer-fill').style.background = 'linear-gradient(90deg, #ff6b6b, #ffa500)';
        } else if (timeRemainingSeconds <= 300) {
            document.getElementById('timer-text').style.color = '#ffa500';
            document.getElementById('timer-fill').style.background = 'linear-gradient(90deg, #ffa500, #4a9eff)';
        }
    }
    
    // Start timer when quiz begins
    <?php if(!$hasExistingAttempt || request()->has('start_over')): ?>
    startTimer();
    <?php endif; ?>
    <?php endif; ?>
    
    // Initialize progress
    updateProgress();
    
    // If continuing from existing attempt, restore progress on page load
    <?php if($hasExistingAttempt && !request()->has('start_over')): ?>
    // Progress will be restored when user clicks "Continue" in modal
    <?php else: ?>
    // New attempt - start from first question
    showQuestion(0);
    <?php endif; ?>
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.student', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/student/quizzes/show.blade.php ENDPATH**/ ?>