<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Your Password</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background: linear-gradient(135deg, #4a9eff 0%, #6bff6b 100%);
            color: white;
            padding: 30px;
            text-align: center;
            border-radius: 10px 10px 0 0;
        }
        .content {
            background: #f9f9f9;
            padding: 30px;
            border: 1px solid #ddd;
            border-top: none;
        }
        .button {
            display: inline-block;
            padding: 12px 30px;
            background: #4a9eff;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin: 20px 0;
        }
        .button:hover {
            background: #3a8eef;
        }
        .footer {
            background: #2d2d2d;
            color: #888;
            padding: 20px;
            text-align: center;
            font-size: 12px;
            border-radius: 0 0 10px 10px;
        }
        .security-notice {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            margin: 20px 0;
            border-radius: 5px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1><?php echo e(\App\Models\Setting::get('system_name', 'Afrilen Technologies')); ?></h1>
        <p>Password Reset Request</p>
    </div>
    
    <div class="content">
        <h2>Hello <?php echo e($user->name); ?>,</h2>
        
        <p>We received a request to reset your password for your <?php echo e(ucfirst($role)); ?> account.</p>
        
        <p>Click the button below to reset your password:</p>
        
        <div style="text-align: center;">
            <a href="<?php echo e($resetUrl); ?>" class="button">Reset Password</a>
        </div>
        
        <p>Or copy and paste this link into your browser:</p>
        <p style="word-break: break-all; color: #4a9eff;"><?php echo e($resetUrl); ?></p>
        
        <div class="security-notice">
            <strong>⚠️ Security Notice:</strong>
            <ul style="margin: 10px 0 0 20px; padding: 0;">
                <li>This link will expire in 60 minutes</li>
                <li>If you didn't request a password reset, please ignore this email</li>
                <li>Your password will remain unchanged if you don't click the link</li>
            </ul>
        </div>
        
        <p style="margin-top: 30px;">If you have any questions, please contact support.</p>
        
        <p>Best regards,<br><?php echo e(\App\Models\Setting::get('system_name', 'Afrilen Technologies')); ?> Team</p>
    </div>
    
    <div class="footer">
        <p>This is an automated message from <?php echo e(\App\Models\Setting::get('system_name', 'Afrilen Technologies')); ?></p>
        <p>Please do not reply to this email.</p>
    </div>
</body>
</html>

<?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/emails/password-reset.blade.php ENDPATH**/ ?>