<div style="position: relative;">
    <button id="notificationBell" onclick="toggleNotificationDropdown()" style="background: transparent; border: none; color: #e0e0e0; font-size: 20px; cursor: pointer; padding: 8px; position: relative; transition: all 0.3s;" onmouseover="this.style.color='#4a9eff';" onmouseout="this.style.color='#e0e0e0';">
        <i class="fas fa-bell"></i>
        <span id="notificationBadge" style="display: none; position: absolute; top: 4px; right: 4px; background: #ff6b6b; color: white; border-radius: 50%; width: 18px; height: 18px; font-size: 11px; font-weight: bold; align-items: center; justify-content: center;">0</span>
    </button>
    
    <div id="notificationDropdown" style="display: none; position: absolute; top: 45px; right: 0; background: #2d2d2d; border: 1px solid #404040; border-radius: 8px; min-width: 350px; max-width: 400px; max-height: 500px; overflow-y: auto; box-shadow: 0 10px 30px rgba(0,0,0,0.5); z-index: 1000;">
        <div style="padding: 15px 20px; border-bottom: 1px solid #404040; display: flex; justify-content: space-between; align-items: center;">
            <h4 style="color: #e0e0e0; margin: 0; font-size: 16px;">Notifications</h4>
            <a href="<?php echo e(route('notifications.index')); ?>" style="color: #4a9eff; font-size: 12px; text-decoration: none;">View All</a>
        </div>
        <div id="notificationList" style="max-height: 400px; overflow-y: auto;">
            <div style="padding: 40px 20px; text-align: center; color: #888;">
                <i class="fas fa-spinner fa-spin" style="font-size: 24px; margin-bottom: 10px;"></i>
                <p>Loading notifications...</p>
            </div>
        </div>
        <div style="padding: 10px 20px; border-top: 1px solid #404040; text-align: center;">
            <form action="<?php echo e(route('notifications.mark-all-read')); ?>" method="POST" style="margin: 0;">
                <?php echo csrf_field(); ?>
                <button type="submit" style="background: transparent; border: none; color: #4a9eff; cursor: pointer; font-size: 12px; text-decoration: underline;">Mark all as read</button>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    let notificationDropdown = null;
    
    function toggleNotificationDropdown() {
        if (!notificationDropdown) {
            notificationDropdown = document.getElementById('notificationDropdown');
        }
        
        if (notificationDropdown.style.display === 'none') {
            notificationDropdown.style.display = 'block';
            loadNotifications();
        } else {
            notificationDropdown.style.display = 'none';
        }
    }
    
    function loadNotifications() {
        fetch('<?php echo e(route("notifications.recent")); ?>')
            .then(response => response.json())
            .then(data => {
                const listDiv = document.getElementById('notificationList');
                
                if (data.notifications && data.notifications.length > 0) {
                    listDiv.innerHTML = data.notifications.map(notif => `
                        <a href="${notif.url}" style="text-decoration: none; display: block; border-bottom: 1px solid #404040;" onmouseover="this.style.background='#1a1a1a';" onmouseout="this.style.background='transparent';">
                            <div style="padding: 15px 20px;">
                                <div style="display: flex; justify-content: space-between; align-items: start; gap: 10px;">
                                    <div style="flex: 1;">
                                        <div style="display: flex; align-items: center; gap: 8px; margin-bottom: 5px;">
                                            <strong style="color: #e0e0e0; font-size: 14px;">${notif.title}</strong>
                                            ${!notif.is_read ? '<span style="width: 8px; height: 8px; background: #4a9eff; border-radius: 50%; display: inline-block;"></span>' : ''}
                                        </div>
                                        <p style="color: #888; font-size: 12px; margin: 0; line-height: 1.4;">${notif.message}</p>
                                        <span style="color: #666; font-size: 11px; margin-top: 5px; display: block;">${notif.created_at}</span>
                                    </div>
                                </div>
                            </div>
                        </a>
                    `).join('');
                } else {
                    listDiv.innerHTML = '<div style="padding: 40px 20px; text-align: center; color: #888;"><i class="fas fa-bell-slash" style="font-size: 32px; margin-bottom: 10px; opacity: 0.5;"></i><p>No notifications</p></div>';
                }
            })
            .catch(error => {
                console.error('Error loading notifications:', error);
                document.getElementById('notificationList').innerHTML = '<div style="padding: 20px; text-align: center; color: #ff6b6b;">Error loading notifications</div>';
            });
    }
    
    let lastNotificationCount = 0;
    
    function loadNotificationCount() {
        fetch('<?php echo e(route("notifications.unread-count")); ?>')
            .then(response => response.json())
            .then(data => {
                const badge = document.getElementById('notificationBadge');
                const currentCount = data.count || 0;
                
                // Show visual alert if new notification arrived
                if (currentCount > lastNotificationCount && lastNotificationCount > 0) {
                    showNotificationAlert(currentCount - lastNotificationCount);
                }
                
                lastNotificationCount = currentCount;
                
                if (currentCount > 0) {
                    badge.textContent = currentCount > 99 ? '99+' : currentCount;
                    badge.style.display = 'inline-flex';
                    // Add pulse animation for new notifications
                    if (currentCount > lastNotificationCount) {
                        badge.style.animation = 'pulse 0.5s ease-in-out';
                        setTimeout(() => {
                            badge.style.animation = '';
                        }, 500);
                    }
                } else {
                    badge.style.display = 'none';
                }
                
                // Reload dropdown if it's open
                const dropdown = document.getElementById('notificationDropdown');
                if (dropdown && dropdown.style.display !== 'none') {
                    loadNotifications();
                }
            })
            .catch(error => console.error('Error loading notification count:', error));
    }
    
    function showNotificationAlert(count) {
        // Create a temporary toast notification
        const toast = document.createElement('div');
        toast.innerHTML = `<i class="fas fa-bell"></i> You have ${count} new notification${count > 1 ? 's' : ''}`;
        toast.style.cssText = 'position: fixed; top: 20px; right: 20px; background: #4a9eff; color: white; padding: 15px 20px; border-radius: 8px; box-shadow: 0 4px 20px rgba(0,0,0,0.3); z-index: 10000; animation: slideIn 0.3s ease-out;';
        
        document.body.appendChild(toast);
        
        setTimeout(() => {
            toast.style.animation = 'slideOut 0.3s ease-out';
            setTimeout(() => {
                document.body.removeChild(toast);
            }, 300);
        }, 3000);
    }
    
    // Load count on page load
    document.addEventListener('DOMContentLoaded', function() {
        loadNotificationCount();
        // Refresh count every 10 seconds for real-time updates
        setInterval(loadNotificationCount, 10000);
    });
    
    // Add CSS animations
    const style = document.createElement('style');
    style.textContent = `
        @keyframes  pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.2); }
        }
        @keyframes  slideIn {
            from { transform: translateX(100%); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }
        @keyframes  slideOut {
            from { transform: translateX(0); opacity: 1; }
            to { transform: translateX(100%); opacity: 0; }
        }
    `;
    document.head.appendChild(style);
    
    // Close dropdown when clicking outside
    document.addEventListener('click', function(event) {
        const bell = document.getElementById('notificationBell');
        const dropdown = document.getElementById('notificationDropdown');
        
        if (dropdown && !bell.contains(event.target) && !dropdown.contains(event.target)) {
            dropdown.style.display = 'none';
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/partials/notification-bell.blade.php ENDPATH**/ ?>