

<?php $__env->startSection('title', 'My Courses'); ?>
<?php $__env->startSection('page-title', 'My Courses'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-book"></i> My Enrolled Courses</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <?php if($enrollments->count() > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Course Code</th>
                            <th>Course Name</th>
                            <th>Instructor</th>
                            <th>Enrollment Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $enrollments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enrollment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><strong><?php echo e($enrollment->course->code); ?></strong></td>
                                <td><?php echo e($enrollment->course->name); ?></td>
                                <td><?php echo e($enrollment->course->instructor->name ?? 'N/A'); ?></td>
                                <td><?php echo e($enrollment->enrollment_date ? $enrollment->enrollment_date->format('M d, Y') : 'N/A'); ?></td>
                                <td>
                                    <?php if($enrollment->status == 'active'): ?>
                                        <span style="color: #6bff6b;">Active</span>
                                    <?php else: ?>
                                        <span style="color: #888;"><?php echo e(ucfirst($enrollment->status)); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('student.courses.show', $enrollment->course_id)); ?>" class="btn btn-primary" style="padding: 6px 12px; font-size: 12px;">
                                        <i class="fas fa-eye"></i> View Course
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            <?php else: ?>
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p><i class="fas fa-book" style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;"></i></p>
                    <p>You are not enrolled in any courses yet.</p>
                    <p style="font-size: 14px; margin-top: 10px;">Please contact the administrator to get enrolled.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.student', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/student/courses/index.blade.php ENDPATH**/ ?>