

<?php $__env->startSection('title', 'Login'); ?>

<?php $__env->startSection('content'); ?>
<div class="card" style="max-width: 450px; margin: 0 auto;">
    <div class="text-center mb-4">
        <h1 style="color: #4a9eff; margin-bottom: 10px;">Afrilen Technologies</h1>
        <h2 style="color: #e0e0e0; font-size: 24px;">School Portal</h2>
        <p style="color: #888; margin-top: 10px;">
            <?php if(isset($role) && $role === 'admin'): ?>
                Admin Login
            <?php elseif(isset($role) && $role === 'instructor'): ?>
                Instructor Login
            <?php else: ?>
                Student Login
            <?php endif; ?>
        </p>
    </div>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul style="list-style: none; margin: 0; padding: 0;">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <?php if(session('status')): ?>
        <div class="alert alert-success">
            <?php echo e(session('status')); ?>

        </div>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(isset($role) && $role === 'admin' ? route('admin.login.post') : 
        (isset($role) && $role === 'instructor' ? route('instructor.login.post') : route('login.post'))); ?>">
        <?php echo csrf_field(); ?>

        <input type="hidden" name="role" value="<?php echo e($role ?? 'student'); ?>">

        <div class="form-group">
            <label for="login" id="login-label">
                <?php if(isset($role) && $role === 'student'): ?>
                    School ID
                <?php else: ?>
                    Email Address
                <?php endif; ?>
            </label>
            <input 
                type="text" 
                id="login" 
                name="login" 
                value="<?php echo e(old('login')); ?>" 
                required 
                autofocus
                placeholder="<?php echo e(isset($role) && $role === 'student' ? 'Enter your school ID' : 'Enter your email'); ?>"
            >
        </div>

        <div class="form-group">
            <label for="password">Password</label>
            <input 
                type="password" 
                id="password" 
                name="password" 
                required
                placeholder="Enter your password"
            >
        </div>

        <div class="remember-me">
            <input type="checkbox" name="remember" id="remember">
            <label for="remember">Remember me</label>
        </div>

        <button type="submit" class="btn btn-primary">
            Login
        </button>
    </form>

    <div class="text-center" style="margin-top: 20px;">
        <a href="<?php echo e(route('password.request', ['role' => $role ?? 'student'])); ?>">
            <i class="fas fa-key"></i> Forgot your password?
        </a>
    </div>

    <?php if(!isset($role) || $role === 'student'): ?>
    <div class="text-center" style="margin-top: 15px; padding-top: 15px; border-top: 1px solid #404040;">
        <p style="color: #888; font-size: 14px;">
            Are you an admin or instructor? 
            <a href="<?php echo e(route('admin.login')); ?>" style="margin-left: 5px;">Admin Login</a> | 
            <a href="<?php echo e(route('instructor.login')); ?>">Instructor Login</a>
        </p>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/auth/login.blade.php ENDPATH**/ ?>