

<?php $__env->startSection('title', $book->title); ?>

<?php $__env->startSection('content'); ?>
<div class="content-area">
    <div class="card">
        <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 30px; flex-wrap: wrap; gap: 20px;">
            <div style="flex: 1;">
                <h2 style="color: #4a9eff; margin-bottom: 10px; font-size: 24px;"><?php echo e($book->title); ?></h2>
                <?php if($book->author): ?>
                    <p style="color: #888; margin-bottom: 5px;"><i class="fas fa-user"></i> <?php echo e($book->author); ?></p>
                <?php endif; ?>
                <?php if($book->description): ?>
                    <p style="color: #aaa; line-height: 1.6; margin-top: 15px;"><?php echo e($book->description); ?></p>
                <?php endif; ?>
            </div>
            <?php if($book->cover_image): ?>
                <img src="<?php echo e(asset($book->cover_image)); ?>" alt="<?php echo e($book->title); ?>" style="width: 150px; height: 200px; object-fit: cover; border-radius: 8px; border: 1px solid #404040;">
            <?php endif; ?>
        </div>

        <!-- Progress Bar -->
        <div style="background: #1a1a1a; padding: 15px; border-radius: 8px; margin-bottom: 30px; border: 1px solid #404040;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">
                <span style="color: #4a9eff; font-weight: 600;"><i class="fas fa-chart-line"></i> Reading Progress</span>
                <span style="color: #888; font-size: 14px;"><?php echo e(number_format($overallProgress, 1)); ?>%</span>
            </div>
            <div style="background: #2d2d2d; height: 8px; border-radius: 4px; overflow: hidden;">
                <div style="background: linear-gradient(90deg, #4a9eff 0%, #3a8eef 100%); height: 100%; width: <?php echo e($overallProgress); ?>%; transition: width 0.3s;"></div>
            </div>
        </div>

        <!-- Chapters List -->
        <div class="card-header">
            <h3><i class="fas fa-list"></i> Table of Contents (<?php echo e($book->chapters->count()); ?> Chapters)</h3>
        </div>

        <div style="margin-top: 20px;">
            <?php $__currentLoopData = $book->chapters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chapter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $chapterProgress = $progress->get($chapter->id);
                    $isCompleted = $chapterProgress && $chapterProgress->is_completed;
                ?>
                <div class="chapter-item" style="background: #1a1a1a; border: 1px solid #404040; border-radius: 8px; padding: 20px; margin-bottom: 15px; transition: all 0.3s; position: relative;">
                    <div style="display: flex; align-items: center; justify-content: space-between; flex-wrap: wrap; gap: 15px;">
                        <div style="flex: 1;">
                            <div style="display: flex; align-items: center; gap: 15px; margin-bottom: 10px;">
                                <span style="background: #4a9eff; color: white; width: 35px; height: 35px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: 600; font-size: 14px;">
                                    <?php echo e($chapter->chapter_number); ?>

                                </span>
                                <h4 style="color: #e0e0e0; font-size: 16px; margin: 0; font-weight: 500;"><?php echo e($chapter->title); ?></h4>
                                <?php if($isCompleted): ?>
                                    <span style="background: #28a745; color: white; padding: 4px 10px; border-radius: 5px; font-size: 12px; font-weight: 500;">
                                        <i class="fas fa-check"></i> Completed
                                    </span>
                                <?php endif; ?>
                            </div>
                            <?php if($chapter->description): ?>
                                <p style="color: #888; font-size: 14px; margin-left: 50px; margin-bottom: 0;"><?php echo e($chapter->description); ?></p>
                            <?php endif; ?>
                        </div>
                        <a href="<?php echo e(route('student.books.chapters.read', ['book' => $book->id, 'chapter' => $chapter->id])); ?>" 
                           class="btn btn-primary" 
                           style="text-decoration: none; display: inline-flex; align-items: center; gap: 8px;">
                            <i class="fas fa-book-reader"></i> <?php echo e($isCompleted ? 'Review' : 'Read'); ?>

                        </a>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Bookmarks Section -->
        <?php if($bookmarks->count() > 0): ?>
            <div class="card-header" style="margin-top: 40px;">
                <h3><i class="fas fa-bookmark"></i> Your Bookmarks</h3>
            </div>
            <div style="margin-top: 20px;">
                <?php $__currentLoopData = $bookmarks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bookmark): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div style="background: #1a1a1a; border: 1px solid #404040; border-radius: 8px; padding: 15px; margin-bottom: 10px;">
                        <div style="display: flex; justify-content: space-between; align-items: start;">
                            <div style="flex: 1;">
                                <h5 style="color: #4a9eff; margin-bottom: 5px; font-size: 14px;">
                                    <i class="fas fa-bookmark" style="color: #ffc107;"></i> <?php echo e($bookmark->title ?? 'Bookmark'); ?>

                                </h5>
                                <p style="color: #888; font-size: 12px; margin-bottom: 5px;">
                                    Chapter <?php echo e($bookmark->chapter->chapter_number); ?>: <?php echo e($bookmark->chapter->title); ?>

                                </p>
                                <?php if($bookmark->note): ?>
                                    <p style="color: #aaa; font-size: 13px; margin: 0;"><?php echo e($bookmark->note); ?></p>
                                <?php endif; ?>
                            </div>
                            <a href="<?php echo e(route('student.books.chapters.read', ['book' => $book->id, 'chapter' => $bookmark->chapter->id])); ?>?position=<?php echo e($bookmark->position); ?>" 
                               class="btn btn-secondary" 
                               style="text-decoration: none; padding: 6px 12px; font-size: 12px;">
                                Go to
                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
    .chapter-item:hover {
        border-color: #4a9eff;
        transform: translateX(5px);
    }
</style>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.student', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/student/books/show.blade.php ENDPATH**/ ?>