

<?php $__env->startSection('title', 'Bookmarked Questions'); ?>
<?php $__env->startSection('page-title', 'Bookmarked Questions'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .bookmarks-container {
        max-width: 1200px;
        margin: 0 auto;
    }
    
    .bookmarks-header {
        background: #2d2d2d;
        padding: 30px;
        border-radius: 8px;
        margin-bottom: 30px;
        border: 1px solid #404040;
    }
    
    .filters-section {
        background: #2d2d2d;
        padding: 20px;
        border-radius: 8px;
        margin-bottom: 30px;
        border: 1px solid #404040;
    }
    
    .bookmark-item {
        background: #2d2d2d;
        padding: 25px;
        border-radius: 8px;
        margin-bottom: 20px;
        border: 1px solid #404040;
        border-left: 4px solid #4a9eff;
    }
    
    .bookmark-header {
        display: flex;
        justify-content: space-between;
        align-items: start;
        margin-bottom: 15px;
        flex-wrap: wrap;
        gap: 15px;
    }
    
    .quiz-info {
        display: flex;
        align-items: center;
        gap: 10px;
        color: #4a9eff;
    }
    
    .bookmark-actions {
        display: flex;
        gap: 10px;
    }
    
    .question-text {
        font-size: 18px;
        font-weight: 500;
        margin-bottom: 20px;
        color: #e0e0e0;
        line-height: 1.6;
    }
    
    .notes-section {
        margin-top: 15px;
        padding: 15px;
        background: #1a1a1a;
        border-radius: 6px;
        border-left: 3px solid #4a9eff;
    }
    
    .notes-section textarea {
        width: 100%;
        min-height: 80px;
        padding: 10px;
        background: #2d2d2d;
        border: 1px solid #404040;
        border-radius: 5px;
        color: #e0e0e0;
        font-family: inherit;
        resize: vertical;
    }
    
    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: #888;
    }
    
    .empty-state i {
        font-size: 64px;
        margin-bottom: 20px;
        opacity: 0.5;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="bookmarks-container">
        <div class="bookmarks-header">
            <h2 style="color: #4a9eff; margin-bottom: 10px;">
                <i class="fas fa-bookmark"></i> Bookmarked Questions
            </h2>
            <p style="color: #888; margin: 0;">
                Review and study questions you've bookmarked for later.
            </p>
        </div>
        
        <!-- Filters -->
        <div class="filters-section">
            <form method="GET" action="<?php echo e(route('student.quizzes.bookmarks')); ?>" style="display: flex; gap: 15px; align-items: end; flex-wrap: wrap;">
                <div style="flex: 1; min-width: 200px;">
                    <label style="display: block; color: #888; font-size: 13px; margin-bottom: 8px;">Filter by Quiz</label>
                    <select name="quiz_id" style="width: 100%; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                        <option value="">All Quizzes</option>
                        <?php $__currentLoopData = $quizzes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quiz): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($quiz->id); ?>" <?php echo e(request('quiz_id') == $quiz->id ? 'selected' : ''); ?>>
                                <?php echo e($quiz->title); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                
                <div style="flex: 0 0 auto;">
                    <label style="display: block; color: #888; font-size: 13px; margin-bottom: 8px;">&nbsp;</label>
                    <button type="submit" class="btn btn-primary" style="width: auto; padding: 10px 20px;">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                </div>
                
                <?php if(request()->has('quiz_id')): ?>
                <div style="flex: 0 0 auto;">
                    <label style="display: block; color: #888; font-size: 13px; margin-bottom: 8px;">&nbsp;</label>
                    <a href="<?php echo e(route('student.quizzes.bookmarks')); ?>" class="btn btn-secondary" style="width: auto; padding: 10px 20px;">
                        <i class="fas fa-times"></i> Clear
                    </a>
                </div>
                <?php endif; ?>
            </form>
        </div>
        
        <?php if($bookmarks->count() > 0): ?>
            <div style="margin-bottom: 20px; color: #888; font-size: 14px;">
                Found <strong style="color: #4a9eff;"><?php echo e($bookmarks->total()); ?></strong> bookmarked question(s)
            </div>
            
            <?php $__currentLoopData = $bookmarks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bookmark): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $question = $bookmark->question;
                    $quiz = $question->quiz;
                ?>
                
                <div class="bookmark-item" id="bookmark-<?php echo e($bookmark->id); ?>">
                    <div class="bookmark-header">
                        <div>
                            <div class="quiz-info">
                                <i class="fas fa-question-circle"></i>
                                <strong><?php echo e($quiz->title); ?></strong>
                            </div>
                            <div style="color: #888; font-size: 13px; margin-top: 5px;">
                                <i class="fas fa-calendar"></i> Bookmarked <?php echo e($bookmark->created_at->diffForHumans()); ?>

                            </div>
                        </div>
                        <div class="bookmark-actions">
                            <button type="button" 
                                    class="btn btn-secondary" 
                                    onclick="toggleBookmark(<?php echo e($question->id); ?>, <?php echo e($bookmark->id); ?>)"
                                    style="padding: 8px 16px; font-size: 13px;">
                                <i class="fas fa-bookmark"></i> Remove Bookmark
                            </button>
                            <a href="<?php echo e(route('student.quizzes.show', $quiz->id)); ?>" class="btn btn-primary" style="padding: 8px 16px; font-size: 13px;">
                                <i class="fas fa-redo"></i> Take Quiz
                            </a>
                        </div>
                    </div>
                    
                    <div class="question-text">
                        <?php echo e($question->question); ?>

                    </div>
                    
                    <?php if($question->explanation): ?>
                    <div style="margin-top: 15px; padding: 15px; background: #1a1a1a; border-radius: 6px; border-left: 3px solid #6bff6b;">
                        <strong style="color: #6bff6b; display: block; margin-bottom: 8px;">Explanation:</strong>
                        <p style="color: #888; font-style: italic; margin: 0;"><?php echo e($question->explanation); ?></p>
                    </div>
                    <?php endif; ?>
                    
                    <div class="notes-section">
                        <strong style="color: #4a9eff; display: block; margin-bottom: 8px;">
                            <i class="fas fa-sticky-note"></i> My Notes:
                        </strong>
                        <textarea 
                            id="notes-<?php echo e($bookmark->id); ?>" 
                            placeholder="Add your personal notes about this question..."
                            onblur="saveNotes(<?php echo e($bookmark->id); ?>)"
                        ><?php echo e($bookmark->notes); ?></textarea>
                        <button type="button" onclick="saveNotes(<?php echo e($bookmark->id); ?>)" class="btn btn-primary" style="margin-top: 10px; padding: 6px 12px; font-size: 12px;">
                            <i class="fas fa-save"></i> Save Notes
                        </button>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
            <div style="margin-top: 30px;">
                <?php echo e($bookmarks->links()); ?>

            </div>
        <?php else: ?>
            <div class="empty-state">
                <i class="fas fa-bookmark"></i>
                <h3 style="color: #4a9eff; margin-bottom: 10px;">No Bookmarked Questions</h3>
                <p style="margin-bottom: 20px;">Start bookmarking questions while taking quizzes to review them later!</p>
                <a href="<?php echo e(route('student.quizzes.index')); ?>" class="btn btn-primary">
                    <i class="fas fa-arrow-left"></i> Browse Quizzes
                </a>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    function toggleBookmark(questionId, bookmarkId) {
        fetch(`/student/quizzes/questions/${questionId}/bookmark`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success && !data.is_bookmarked) {
                document.getElementById(`bookmark-${bookmarkId}`).remove();
                if (document.querySelectorAll('.bookmark-item').length === 0) {
                    location.reload();
                }
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred. Please try again.');
        });
    }
    
    function saveNotes(bookmarkId) {
        const notes = document.getElementById(`notes-${bookmarkId}`).value;
        
        fetch(`/student/quizzes/bookmarks/${bookmarkId}/notes`, {
            method: 'PUT',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            },
            body: JSON.stringify({ notes: notes })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Show a brief success indicator
                const button = event.target;
                const originalText = button.innerHTML;
                button.innerHTML = '<i class="fas fa-check"></i> Saved!';
                button.style.background = '#6bff6b';
                button.style.color = '#1a1a1a';
                
                setTimeout(() => {
                    button.innerHTML = originalText;
                    button.style.background = '';
                    button.style.color = '';
                }, 2000);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while saving notes.');
        });
    }
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.student', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/student/quizzes/bookmarks.blade.php ENDPATH**/ ?>