

<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('page-title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Statistics Cards -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon"><i class="fas fa-book"></i></div>
            <div class="stat-value"><?php echo e($stats['total_courses'] ?? 0); ?></div>
            <div class="stat-label">My Courses</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon"><i class="fas fa-users"></i></div>
            <div class="stat-value"><?php echo e($stats['total_students'] ?? 0); ?></div>
            <div class="stat-label">Total Students</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon"><i class="fas fa-graduation-cap"></i></div>
            <div class="stat-value"><?php echo e($stats['total_enrollments'] ?? 0); ?></div>
            <div class="stat-label">Total Enrollments</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon"><i class="fas fa-video"></i></div>
            <div class="stat-value"><?php echo e($stats['total_videos'] ?? 0); ?></div>
            <div class="stat-label">Class Videos</div>
        </div>
    </div>
    
    <!-- Welcome Section -->
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-tachometer-alt"></i> Welcome to Instructor Dashboard</h3>
        </div>
        <div>
            <p style="color: #e0e0e0; margin-bottom: 20px;">
                Welcome back, <strong><?php echo e(auth()->user()->name); ?></strong>! This is your instructor dashboard where you can manage your courses, students, and class materials.
            </p>
            
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                <div style="padding: 20px; background: #1a1a1a; border-radius: 5px; border: 1px solid #404040;">
                    <h4 style="color: #4a9eff; margin-bottom: 15px;"><i class="fas fa-bolt"></i> Quick Actions</h4>
                    <ul style="list-style: none; padding: 0;">
                        <li style="margin-bottom: 10px;">
                            <a href="<?php echo e(route('instructor.courses.index')); ?>" style="color: #4a9eff; text-decoration: none; display: flex; align-items: center; gap: 8px;"><i class="fas fa-book"></i> View My Courses</a>
                        </li>
                        <li style="margin-bottom: 10px;">
                            <a href="<?php echo e(route('instructor.students.index')); ?>" style="color: #4a9eff; text-decoration: none; display: flex; align-items: center; gap: 8px;"><i class="fas fa-users"></i> View My Students</a>
                        </li>
                        <li style="margin-bottom: 10px;">
                            <a href="<?php echo e(route('instructor.assignments.index')); ?>" style="color: #4a9eff; text-decoration: none; display: flex; align-items: center; gap: 8px;"><i class="fas fa-tasks"></i> Manage Assignments</a>
                        </li>
                        <li style="margin-bottom: 10px;">
                            <a href="<?php echo e(route('instructor.videos.index')); ?>" style="color: #4a9eff; text-decoration: none; display: flex; align-items: center; gap: 8px;"><i class="fas fa-video"></i> Manage Videos</a>
                        </li>
                    </ul>
                </div>
                
                <div style="padding: 20px; background: #1a1a1a; border-radius: 5px; border: 1px solid #404040;">
                    <h4 style="color: #4a9eff; margin-bottom: 15px;"><i class="fas fa-info-circle"></i> Account Information</h4>
                    <ul style="list-style: none; padding: 0; color: #888;">
                        <li style="margin-bottom: 8px; display: flex; align-items: center; gap: 8px;"><i class="fas fa-envelope"></i> <?php echo e(auth()->user()->email); ?></li>
                        <?php if(auth()->user()->phone): ?>
                            <li style="margin-bottom: 8px; display: flex; align-items: center; gap: 8px;"><i class="fas fa-phone"></i> <?php echo e(auth()->user()->phone); ?></li>
                        <?php endif; ?>
                        <li style="margin-bottom: 8px; display: flex; align-items: center; gap: 8px;"><i class="fas fa-calendar"></i> Today: <?php echo e(now()->format('M d, Y')); ?></li>
                        <li style="margin-bottom: 8px; display: flex; align-items: center; gap: 8px;"><i class="fas fa-clock"></i> Server Time: <?php echo e(now()->format('h:i A')); ?></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Recent Activities Section -->
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(350px, 1fr)); gap: 20px;">
        <!-- My Courses -->
        <div class="card">
            <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
                <h3><i class="fas fa-book"></i> My Courses</h3>
                <a href="<?php echo e(route('instructor.courses.index')); ?>" style="color: #4a9eff; font-size: 12px; text-decoration: none;">View All</a>
            </div>
            <div>
                <?php if(isset($recentCourses) && $recentCourses->count() > 0): ?>
                    <div style="display: flex; flex-direction: column; gap: 12px;">
                        <?php $__currentLoopData = $recentCourses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('instructor.courses.show', $course->id)); ?>" style="text-decoration: none; display: block;">
                                <div style="padding: 12px; background: #1a1a1a; border-radius: 5px; border-left: 3px solid #4a9eff; transition: all 0.3s; cursor: pointer;" onmouseover="this.style.background='#222222'; this.style.borderLeftColor='#6bff6b';" onmouseout="this.style.background='#1a1a1a'; this.style.borderLeftColor='#4a9eff';">
                                    <div>
                                        <strong style="color: #e0e0e0; display: block;"><?php echo e($course->name); ?></strong>
                                        <span style="color: #888; font-size: 13px;"><?php echo e($course->code); ?></span>
                                        <div style="margin-top: 5px;">
                                            <span style="color: #888; font-size: 12px;">
                                                <?php echo e($course->enrollments->count()); ?> enrolled students
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <p style="color: #888; text-align: center; padding: 20px;">No courses assigned yet</p>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Recent Enrollments -->
        <div class="card">
            <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
                <h3><i class="fas fa-graduation-cap"></i> Recent Enrollments</h3>
                <a href="<?php echo e(route('instructor.students.index')); ?>" style="color: #4a9eff; font-size: 12px; text-decoration: none;">View All</a>
            </div>
            <div>
                <?php if(isset($recentEnrollments) && $recentEnrollments->count() > 0): ?>
                    <div style="display: flex; flex-direction: column; gap: 12px;">
                        <?php $__currentLoopData = $recentEnrollments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enrollment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($enrollment->student && $enrollment->course): ?>
                                <div style="padding: 12px; background: #1a1a1a; border-radius: 5px; border-left: 3px solid #4a9eff;">
                                    <div style="display: flex; justify-content: space-between; align-items: start;">
                                        <div style="flex: 1;">
                                            <strong style="color: #e0e0e0; display: block;"><?php echo e($enrollment->student->name); ?></strong>
                                            <span style="color: #888; font-size: 13px;"><?php echo e($enrollment->course->name); ?></span>
                                        </div>
                                        <span style="color: #888; font-size: 12px; white-space: nowrap; margin-left: 10px;">
                                            <?php echo e($enrollment->created_at ? $enrollment->created_at->format('M d, Y') : 'N/A'); ?>

                                        </span>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <p style="color: #888; text-align: center; padding: 20px;">No recent enrollments</p>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Recent Videos -->
        <div class="card">
            <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
                <h3><i class="fas fa-video"></i> Recent Videos</h3>
                <a href="<?php echo e(route('instructor.videos.index')); ?>" style="color: #4a9eff; font-size: 12px; text-decoration: none;">View All</a>
            </div>
            <div>
                <?php if(isset($recentVideos) && $recentVideos->count() > 0): ?>
                    <div style="display: flex; flex-direction: column; gap: 12px;">
                        <?php $__currentLoopData = $recentVideos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($video->course): ?>
                                <div style="padding: 12px; background: #1a1a1a; border-radius: 5px; border-left: 3px solid #6bff6b;">
                                    <div>
                                        <strong style="color: #e0e0e0; display: block;"><?php echo e($video->title); ?></strong>
                                        <span style="color: #888; font-size: 13px;"><?php echo e($video->course->name); ?></span>
                                        <div style="margin-top: 5px;">
                                            <span style="color: #888; font-size: 12px;">
                                                <?php echo e($video->session_date ? \Carbon\Carbon::parse($video->session_date)->format('M d, Y') : 'N/A'); ?>

                                            </span>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <p style="color: #888; text-align: center; padding: 20px;">No videos uploaded yet</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.instructor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/instructor/dashboard.blade.php ENDPATH**/ ?>