

<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('page-title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Statistics Cards -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon"><i class="fas fa-users"></i></div>
            <div class="stat-value"><?php echo e($stats['total_students'] ?? 0); ?></div>
            <div class="stat-label">Total Students</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon"><i class="fas fa-chalkboard-teacher"></i></div>
            <div class="stat-value"><?php echo e($stats['total_instructors'] ?? 0); ?></div>
            <div class="stat-label">Total Instructors</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon"><i class="fas fa-book"></i></div>
            <div class="stat-value"><?php echo e($stats['total_courses'] ?? 0); ?></div>
            <div class="stat-label">Total Courses</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon"><i class="fas fa-graduation-cap"></i></div>
            <div class="stat-value"><?php echo e($stats['total_enrollments'] ?? 0); ?></div>
            <div class="stat-label">Total Enrollments</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon"><i class="fas fa-money-bill-wave"></i></div>
            <div class="stat-value">₵<?php echo e(number_format($stats['total_revenue'] ?? 0, 2)); ?></div>
            <div class="stat-label">Total Revenue</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon"><i class="fas fa-clipboard-list"></i></div>
            <div class="stat-value"><?php echo e($stats['pending_payments'] ?? 0); ?></div>
            <div class="stat-label">Pending Payments</div>
        </div>
    </div>
    
    <!-- Recent Activity Section -->
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-tachometer-alt"></i> Welcome to Admin Dashboard</h3>
        </div>
        <div>
            <p style="color: #e0e0e0; margin-bottom: 20px;">
                Welcome back, <strong><?php echo e(auth()->user()->name); ?></strong>! This is your admin dashboard where you can manage all aspects of the school portal.
            </p>
            
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                <div style="padding: 20px; background: #1a1a1a; border-radius: 5px; border: 1px solid #404040;">
                    <h4 style="color: #4a9eff; margin-bottom: 15px;"><i class="fas fa-bolt"></i> Quick Actions</h4>
                    <ul style="list-style: none; padding: 0;">
                        <li style="margin-bottom: 10px;">
                            <a href="<?php echo e(route('admin.students.create')); ?>" style="color: #4a9eff; text-decoration: none; display: flex; align-items: center; gap: 8px;"><i class="fas fa-plus"></i> Add New Student</a>
                        </li>
                        <li style="margin-bottom: 10px;">
                            <a href="<?php echo e(route('admin.instructors.create')); ?>" style="color: #4a9eff; text-decoration: none; display: flex; align-items: center; gap: 8px;"><i class="fas fa-plus"></i> Add New Instructor</a>
                        </li>
                        <li style="margin-bottom: 10px;">
                            <a href="<?php echo e(route('admin.courses.create')); ?>" style="color: #4a9eff; text-decoration: none; display: flex; align-items: center; gap: 8px;"><i class="fas fa-book"></i> Create New Course</a>
                        </li>
                        <li style="margin-bottom: 10px;">
                            <a href="<?php echo e(route('admin.course-offerings.create')); ?>" style="color: #4a9eff; text-decoration: none; display: flex; align-items: center; gap: 8px;"><i class="fas fa-calendar-alt"></i> Create Course Offering</a>
                        </li>
                        <li style="margin-bottom: 10px;">
                            <a href="<?php echo e(route('admin.enrollments.create')); ?>" style="color: #4a9eff; text-decoration: none; display: flex; align-items: center; gap: 8px;"><i class="fas fa-user-plus"></i> Enroll Student</a>
                        </li>
                        <li style="margin-bottom: 10px;">
                            <a href="<?php echo e(route('admin.student-finances.index')); ?>" style="color: #4a9eff; text-decoration: none; display: flex; align-items: center; gap: 8px;"><i class="fas fa-money-bill-wave"></i> Manage Finances</a>
                        </li>
                    </ul>
                </div>
                
                <div style="padding: 20px; background: #1a1a1a; border-radius: 5px; border: 1px solid #404040;">
                    <h4 style="color: #4a9eff; margin-bottom: 15px;"><i class="fas fa-info-circle"></i> System Information</h4>
                    <ul style="list-style: none; padding: 0; color: #888;">
                        <li style="margin-bottom: 8px; display: flex; align-items: center; gap: 8px;"><i class="fas fa-tag"></i> Portal Version: 1.0.0</li>
                        <li style="margin-bottom: 8px; display: flex; align-items: center; gap: 8px;"><i class="fas fa-calendar"></i> Today: <?php echo e(now()->format('M d, Y')); ?></li>
                        <li style="margin-bottom: 8px; display: flex; align-items: center; gap: 8px;"><i class="fas fa-clock"></i> Server Time: <?php echo e(now()->format('h:i A')); ?></li>
                        <li style="margin-bottom: 8px; display: flex; align-items: center; gap: 8px;"><i class="fas fa-briefcase"></i> Active Courses: <?php echo e($stats['active_courses'] ?? 0); ?></li>
                        <li style="margin-bottom: 8px; display: flex; align-items: center; gap: 8px;"><i class="fas fa-play-circle"></i> Active Offerings: <?php echo e($stats['active_offerings'] ?? 0); ?></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Recent Activities Section -->
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(350px, 1fr)); gap: 20px;">
        <!-- Recent Enrollments -->
        <div class="card">
            <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
                <h3><i class="fas fa-graduation-cap"></i> Recent Enrollments</h3>
                <a href="<?php echo e(route('admin.enrollments.index')); ?>" style="color: #4a9eff; font-size: 12px; text-decoration: none;">View All</a>
            </div>
            <div>
                <?php if(isset($recentEnrollments) && $recentEnrollments->count() > 0): ?>
                    <div style="display: flex; flex-direction: column; gap: 12px;">
                        <?php $__currentLoopData = $recentEnrollments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enrollment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($enrollment->student && $enrollment->course): ?>
                                <a href="<?php echo e(route('admin.enrollments.show', $enrollment->id)); ?>" style="text-decoration: none; display: block;">
                                    <div style="padding: 12px; background: #1a1a1a; border-radius: 5px; border-left: 3px solid #4a9eff; transition: all 0.3s; cursor: pointer;" onmouseover="this.style.background='#222222'; this.style.borderLeftColor='#6bff6b';" onmouseout="this.style.background='#1a1a1a'; this.style.borderLeftColor='#4a9eff';">
                                        <div style="display: flex; justify-content: space-between; align-items: start;">
                                            <div style="flex: 1;">
                                                <strong style="color: #e0e0e0; display: block;"><?php echo e($enrollment->student->name); ?></strong>
                                                <span style="color: #888; font-size: 13px;"><?php echo e($enrollment->course->name); ?></span>
                                            </div>
                                            <span style="color: #888; font-size: 12px; white-space: nowrap; margin-left: 10px;">
                                                <?php echo e($enrollment->created_at ? $enrollment->created_at->format('M d, Y') : 'N/A'); ?>

                                            </span>
                                        </div>
                                    </div>
                                </a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <p style="color: #888; text-align: center; padding: 20px;">No recent enrollments</p>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Recent Payments -->
        <div class="card">
            <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
                <h3><i class="fas fa-money-bill-wave"></i> Recent Payments</h3>
                <a href="<?php echo e(route('admin.fee-payments.index')); ?>" style="color: #4a9eff; font-size: 12px; text-decoration: none;">View All</a>
            </div>
            <div>
                <?php if(isset($recentPayments) && $recentPayments->count() > 0): ?>
                    <div style="display: flex; flex-direction: column; gap: 12px;">
                        <?php $__currentLoopData = $recentPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($payment->student): ?>
                                <div style="padding: 12px; background: #1a1a1a; border-radius: 5px; border-left: 3px solid #6bff6b;">
                                    <div style="display: flex; justify-content: space-between; align-items: start;">
                                        <div style="flex: 1;">
                                            <strong style="color: #e0e0e0; display: block;"><?php echo e($payment->student->name); ?></strong>
                                            <span style="color: #6bff6b; font-size: 13px; font-weight: bold;">₵<?php echo e(number_format($payment->amount, 2)); ?></span>
                                            <?php if($payment->recordedBy): ?>
                                                <small style="color: #666; font-size: 11px; display: block; margin-top: 3px;">Recorded by: <?php echo e($payment->recordedBy->name); ?></small>
                                            <?php endif; ?>
                                        </div>
                                        <span style="color: #888; font-size: 12px; white-space: nowrap; margin-left: 10px;">
                                            <?php echo e($payment->created_at ? $payment->created_at->format('M d, Y') : 'N/A'); ?>

                                        </span>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <p style="color: #888; text-align: center; padding: 20px;">No recent payments</p>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Active Course Offerings -->
        <div class="card">
            <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
                <h3><i class="fas fa-calendar-alt"></i> Active Offerings</h3>
                <a href="<?php echo e(route('admin.course-offerings.index')); ?>" style="color: #4a9eff; font-size: 12px; text-decoration: none;">View All</a>
            </div>
            <div>
                <?php if(isset($activeOfferings) && $activeOfferings->count() > 0): ?>
                    <div style="display: flex; flex-direction: column; gap: 12px;">
                        <?php $__currentLoopData = $activeOfferings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offering): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($offering->course): ?>
                                <a href="<?php echo e(route('admin.course-offerings.show', $offering->id)); ?>" style="text-decoration: none; display: block;">
                                    <div style="padding: 12px; background: #1a1a1a; border-radius: 5px; border-left: 3px solid #6bff6b; transition: all 0.3s; cursor: pointer;" onmouseover="this.style.background='#222222'; this.style.borderLeftColor='#4a9eff';" onmouseout="this.style.background='#1a1a1a'; this.style.borderLeftColor='#6bff6b';">
                                        <div>
                                            <strong style="color: #e0e0e0; display: block;"><?php echo e($offering->name); ?></strong>
                                            <span style="color: #888; font-size: 13px;"><?php echo e($offering->course->name); ?></span>
                                            <div style="margin-top: 5px;">
                                                <span style="color: #888; font-size: 12px;">
                                                    <?php echo e($offering->current_students); ?> / <?php echo e($offering->max_students > 0 ? $offering->max_students : '∞'); ?> students
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <p style="color: #888; text-align: center; padding: 20px;">No active offerings</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>