<?php
    $layout = 'layouts.' . auth()->user()->role;
?>



<?php $__env->startSection('title', 'Notification Details'); ?>
<?php $__env->startSection('page-title', 'Notification Details'); ?>

<?php $__env->startSection('content'); ?>
    <div style="margin-bottom: 20px;">
        <a href="<?php echo e(route('notifications.index')); ?>" class="btn btn-secondary">← Back to Notifications</a>
    </div>
    
    <div class="card">
        <div style="padding: 30px;">
            <div style="margin-bottom: 20px;">
                <div style="display: flex; align-items: center; gap: 10px; margin-bottom: 15px;">
                    <?php if(!$notification->is_read): ?>
                        <span style="width: 12px; height: 12px; background: #4a9eff; border-radius: 50%; display: inline-block;"></span>
                    <?php endif; ?>
                    <h2 style="color: #e0e0e0; margin: 0; font-size: 24px;"><?php echo e($notification->title); ?></h2>
                    <span style="padding: 6px 12px; border-radius: 4px; font-size: 12px; background: <?php echo e($notification->priority == 'urgent' ? '#dc3545' : ($notification->priority == 'high' ? '#ff6b6b' : ($notification->priority == 'normal' ? '#4a9eff' : '#888'))); ?>; color: white; text-transform: uppercase;">
                        <?php echo e($notification->priority); ?>

                    </span>
                </div>
                
                <div style="display: flex; align-items: center; gap: 20px; color: #888; font-size: 14px; margin-bottom: 30px;">
                    <?php if($notification->sender): ?>
                        <span><i class="fas fa-user"></i> From: <strong style="color: #e0e0e0;"><?php echo e($notification->sender->name); ?></strong></span>
                    <?php endif; ?>
                    <span><i class="fas fa-clock"></i> <?php echo e($notification->created_at->format('M d, Y h:i A')); ?></span>
                    <?php if($notification->email_sent): ?>
                        <span style="color: #6bff6b;"><i class="fas fa-envelope"></i> Email sent</span>
                    <?php endif; ?>
                </div>
            </div>
            
            <div style="background: #1a1a1a; padding: 25px; border-radius: 8px; border-left: 4px solid #4a9eff;">
                <div style="color: #e0e0e0; font-size: 16px; line-height: 1.8; white-space: pre-wrap;">
                    <?php echo nl2br(e($notification->message)); ?>

                </div>
            </div>
            
            <div style="margin-top: 30px; display: flex; gap: 10px;">
                <?php if(!$notification->is_read): ?>
                    <form action="<?php echo e(route('notifications.mark-read', $notification->id)); ?>" method="POST" style="margin: 0;">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-check"></i> Mark as Read
                        </button>
                    </form>
                <?php endif; ?>
                
                <form action="<?php echo e(route('notifications.destroy', $notification->id)); ?>" method="POST" style="margin: 0;">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" onclick="return confirm('Are you sure you want to delete this notification?')" class="btn btn-secondary">
                        <i class="fas fa-trash"></i> Delete
                    </button>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make($layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/notifications/show.blade.php ENDPATH**/ ?>