

<?php $__env->startSection('title', 'Assignment Details'); ?>
<?php $__env->startSection('page-title', 'Assignment Details'); ?>

<?php $__env->startSection('content'); ?>
    <div style="margin-bottom: 20px;">
        <a href="<?php echo e(route('student.assignments.index')); ?>" class="btn btn-secondary">← Back to Assignments</a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3><?php echo e($assignment->title); ?></h3>
        </div>
        
        <div style="padding: 30px;">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px; margin-bottom: 30px;">
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Assignment Information</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Course</strong>
                        <span style="color: #e0e0e0; font-size: 16px;"><?php echo e($assignment->course->name); ?></span>
                    </div>
                    <?php if($assignment->chapter): ?>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Chapter</strong>
                        <span style="color: #e0e0e0; font-size: 16px;"><?php echo e($assignment->chapter->title); ?></span>
                    </div>
                    <?php endif; ?>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Total Points</strong>
                        <span style="color: #e0e0e0; font-size: 16px;"><?php echo e(number_format($assignment->total_points, 0)); ?> points</span>
                    </div>
                </div>
                
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Due Date & Status</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Due Date</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">
                            <?php echo e($assignment->due_date->format('M d, Y')); ?>

                            <?php if($assignment->due_time): ?>
                                at <?php echo e(date('h:i A', strtotime($assignment->due_time))); ?>

                            <?php endif; ?>
                        </span>
                        <?php
                            $dueDateTime = $assignment->due_date;
                            if ($assignment->due_time) {
                                $dueTimeStr = is_string($assignment->due_time) ? $assignment->due_time : (is_object($assignment->due_time) ? $assignment->due_time->format('H:i') : $assignment->due_time);
                                $dueDateTime = \Carbon\Carbon::parse($assignment->due_date->format('Y-m-d') . ' ' . $dueTimeStr);
                            } else {
                                $dueDateTime = $assignment->due_date->endOfDay();
                            }
                            $isPastDue = \Carbon\Carbon::now()->greaterThan($dueDateTime);
                        ?>
                        <?php if($isPastDue && (!$submission || $submission->status != 'submitted')): ?>
                            <span style="color: #ff6b6b; font-size: 14px; display: block; margin-top: 5px;">⚠ Past Due</span>
                        <?php endif; ?>
                    </div>
                    <?php if($submission): ?>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Submission Status</strong>
                        <?php if($submission->status == 'graded'): ?>
                            <span style="color: #6bff6b; font-size: 16px;">Graded</span>
                            <div style="margin-top: 5px;">
                                <span style="color: #e0e0e0; font-size: 18px; font-weight: 600;">
                                    Score: <?php echo e(number_format($submission->score, 1)); ?> / <?php echo e(number_format($assignment->total_points, 1)); ?>

                                </span>
                                <span style="color: #888; font-size: 14px;">
                                    (<?php echo e(number_format($submission->grade_percentage, 1)); ?>%)
                                </span>
                            </div>
                        <?php else: ?>
                            <span style="color: #ffc107; font-size: 16px;">Submitted</span>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <?php if($assignment->description): ?>
            <div style="margin-top: 30px;">
                <h4 style="color: #4a9eff; margin-bottom: 15px;">Description</h4>
                <p style="color: #e0e0e0; line-height: 1.6;"><?php echo e($assignment->description); ?></p>
            </div>
            <?php endif; ?>
            
            <?php if($assignment->instructions): ?>
            <div style="margin-top: 30px;">
                <h4 style="color: #4a9eff; margin-bottom: 15px;">Instructions</h4>
                <div style="color: #e0e0e0; line-height: 1.6; white-space: pre-wrap;"><?php echo e($assignment->instructions); ?></div>
            </div>
            <?php endif; ?>
            
            <!-- Success/Error Messages -->
            <?php if(session('success')): ?>
                <div style="margin-top: 20px; padding: 15px; background: #1a4d1a; border: 1px solid #6bff6b; border-radius: 5px; color: #6bff6b;">
                    <i class="fas fa-check-circle"></i> <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>
            
            <?php if($errors->any()): ?>
                <div style="margin-top: 20px; padding: 15px; background: #4d1a1a; border: 1px solid #ff6b6b; border-radius: 5px; color: #ff6b6b;">
                    <strong>Error:</strong>
                    <ul style="margin: 10px 0 0 0; padding-left: 20px;">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
            
            <!-- Submission Section -->
            <?php if(!$submission || ($submission->status == 'draft' || $submission->status == 'submitted')): ?>
            <div style="margin-top: 30px; padding-top: 30px; border-top: 2px solid #404040;">
                <h4 style="color: #4a9eff; margin-bottom: 20px;">
                    <?php if($submission && $submission->status == 'submitted'): ?>
                        Update Submission
                    <?php else: ?>
                        Submit Assignment
                    <?php endif; ?>
                </h4>
                <form method="POST" action="<?php echo e(route('student.assignments.submit', $assignment->id)); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    
                    <div class="form-group">
                        <label for="submission_text">Your Submission</label>
                        <textarea 
                            id="submission_text" 
                            name="submission_text" 
                            rows="8"
                            placeholder="Write your submission here or paste your code/response..."
                        ><?php echo e(old('submission_text', $submission->submission_text ?? '')); ?></textarea>
                        <?php $__errorArgs = ['submission_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="submission_file">Upload File (Optional)</label>
                        <input 
                            type="file" 
                            id="submission_file" 
                            name="submission_file"
                            accept=".pdf,.doc,.docx,.zip,.rar"
                        >
                        <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Maximum file size: 10MB. Supported formats: PDF, DOC, DOCX, ZIP, RAR</small>
                        <?php $__errorArgs = ['submission_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div style="margin-top: 20px;">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-paper-plane"></i> Submit Assignment
                        </button>
                    </div>
                </form>
            </div>
            <?php else: ?>
            <!-- View Submission -->
            <div style="margin-top: 30px; padding-top: 30px; border-top: 2px solid #404040;">
                <h4 style="color: #4a9eff; margin-bottom: 20px;">Your Submission</h4>
                <div style="margin-bottom: 20px;">
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Submitted On</strong>
                    <span style="color: #e0e0e0;">
                        <?php echo e($submission->submitted_at ? $submission->submitted_at->format('M d, Y h:i A') : 'N/A'); ?>

                        <?php if($submission->is_late): ?>
                            <span style="color: #ff6b6b;">(Late)</span>
                        <?php endif; ?>
                    </span>
                </div>
                
                <?php if($submission->submission_text): ?>
                <div style="margin-bottom: 20px;">
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Your Answer</strong>
                    <div style="color: #e0e0e0; padding: 15px; background: #1a1a1a; border-radius: 5px; white-space: pre-wrap;"><?php echo e($submission->submission_text); ?></div>
                </div>
                <?php endif; ?>
                
                <?php if($submission->submission_file): ?>
                <div style="margin-bottom: 20px;">
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Attached File</strong>
                    <a href="<?php echo e(asset('storage/' . $submission->submission_file)); ?>" target="_blank" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">
                        <i class="fas fa-download"></i> Download File
                    </a>
                </div>
                <?php endif; ?>
                
                <?php if($submission->status == 'graded'): ?>
                <div style="margin-top: 30px; padding: 20px; background: #1a1a1a; border-radius: 5px; border-left: 3px solid #6bff6b;">
                    <h5 style="color: #4a9eff; margin-bottom: 15px;">Grade & Feedback</h5>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Score</strong>
                        <span style="color: #e0e0e0; font-size: 24px; font-weight: 600;">
                            <?php echo e(number_format($submission->score, 1)); ?> / <?php echo e(number_format($assignment->total_points, 1)); ?>

                        </span>
                        <span style="color: #888; font-size: 14px;">
                            (<?php echo e(number_format($submission->grade_percentage, 1)); ?>%)
                        </span>
                    </div>
                    <?php if($submission->instructor_feedback): ?>
                    <div>
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Instructor Feedback</strong>
                        <div style="color: #e0e0e0; padding: 15px; background: #2d2d2d; border-radius: 5px; white-space: pre-wrap;"><?php echo e($submission->instructor_feedback); ?></div>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.student', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/student/assignments/show.blade.php ENDPATH**/ ?>