

<?php $__env->startSection('title', 'Announcements'); ?>
<?php $__env->startSection('page-title', 'Send Announcements'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-bullhorn"></i> Send Announcement</h3>
        </div>
        
        <div style="padding: 30px;">
            <form method="POST" action="<?php echo e(route('admin.announcements.store')); ?>">
                <?php echo csrf_field(); ?>
                
                <div class="form-group">
                    <label for="title">Announcement Title *</label>
                    <input 
                        type="text" 
                        id="title" 
                        name="title" 
                        value="<?php echo e(old('title')); ?>" 
                        required
                        placeholder="Enter announcement title"
                    >
                    <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div class="form-group">
                    <label for="message">Message *</label>
                    <textarea 
                        id="message" 
                        name="message" 
                        rows="8"
                        required
                        placeholder="Enter your announcement message"
                    ><?php echo e(old('message')); ?></textarea>
                    <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label>Recipients *</label>
                        <div style="display: flex; flex-direction: column; gap: 10px; margin-top: 10px;">
                            <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                                <input 
                                    type="checkbox" 
                                    name="recipients[]" 
                                    value="all_students"
                                    <?php echo e(in_array('all_students', old('recipients', [])) ? 'checked' : ''); ?>

                                    onchange="toggleRecipientOptions(this.checked, 'students')"
                                >
                                <span>All Students</span>
                            </label>
                            <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                                <input 
                                    type="checkbox" 
                                    name="recipients[]" 
                                    value="all_instructors"
                                    <?php echo e(in_array('all_instructors', old('recipients', [])) ? 'checked' : ''); ?>

                                    onchange="toggleRecipientOptions(this.checked, 'instructors')"
                                >
                                <span>All Instructors</span>
                            </label>
                            <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                                <input 
                                    type="checkbox" 
                                    name="recipients[]" 
                                    value="students"
                                    <?php echo e(in_array('students', old('recipients', [])) ? 'checked' : ''); ?>

                                    onchange="toggleRecipientOptions(this.checked, 'students')"
                                >
                                <span>Selected Students</span>
                            </label>
                            <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                                <input 
                                    type="checkbox" 
                                    name="recipients[]" 
                                    value="instructors"
                                    <?php echo e(in_array('instructors', old('recipients', [])) ? 'checked' : ''); ?>

                                    onchange="toggleRecipientOptions(this.checked, 'instructors')"
                                >
                                <span>Selected Instructors</span>
                            </label>
                        </div>
                        <?php $__errorArgs = ['recipients'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="priority">Priority *</label>
                        <select id="priority" name="priority" required>
                            <option value="low" <?php echo e(old('priority') == 'low' ? 'selected' : ''); ?>>Low</option>
                            <option value="normal" <?php echo e(old('priority', 'normal') == 'normal' ? 'selected' : ''); ?>>Normal</option>
                            <option value="high" <?php echo e(old('priority') == 'high' ? 'selected' : ''); ?>>High</option>
                            <option value="urgent" <?php echo e(old('priority') == 'urgent' ? 'selected' : ''); ?>>Urgent</option>
                        </select>
                        <?php $__errorArgs = ['priority'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                
                <!-- Selected Students (hidden by default) -->
                <div id="students-select" class="form-group" style="display: none;">
                    <label for="student_ids">Select Students</label>
                    <select id="student_ids" name="student_ids[]" multiple style="height: 150px;">
                        <?php $__currentLoopData = \App\Models\User::where('role', 'student')->orderBy('name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($student->id); ?>"><?php echo e($student->name); ?> (<?php echo e($student->email); ?>)</option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Hold Ctrl/Cmd to select multiple students</small>
                </div>
                
                <!-- Selected Instructors (hidden by default) -->
                <div id="instructors-select" class="form-group" style="display: none;">
                    <label for="instructor_ids">Select Instructors</label>
                    <select id="instructor_ids" name="instructor_ids[]" multiple style="height: 150px;">
                        <?php $__currentLoopData = \App\Models\User::where('role', 'instructor')->orderBy('name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($instructor->id); ?>"><?php echo e($instructor->name); ?> (<?php echo e($instructor->email); ?>)</option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Hold Ctrl/Cmd to select multiple instructors</small>
                </div>
                
                <div class="form-group">
                    <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                        <input 
                            type="checkbox" 
                            name="send_email" 
                            value="1"
                            <?php echo e(old('send_email') ? 'checked' : ''); ?>

                        >
                        <span>Also send via email</span>
                    </label>
                    <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">Recipients will receive both website notification and email</small>
                </div>
                
                <div style="margin-top: 30px;">
                    <button type="submit" class="btn btn-primary" onclick="return confirm('Are you sure you want to send this announcement?')">
                        <i class="fas fa-paper-plane"></i> Send Announcement
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Recent Announcements -->
    <?php if(isset($recentAnnouncements) && $recentAnnouncements->count() > 0): ?>
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-history"></i> Recent Announcements</h3>
        </div>
        <div style="padding: 30px;">
            <table class="table">
                <thead>
                    <tr>
                        <th>Title</th>
                        <th>Sent To</th>
                        <th>Priority</th>
                        <th>Email Sent</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $recentAnnouncements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><strong><?php echo e($notification->title); ?></strong></td>
                            <td><?php echo e($notification->user->name ?? 'N/A'); ?></td>
                            <td>
                                <span style="padding: 4px 10px; border-radius: 4px; font-size: 12px; background: <?php echo e($notification->priority == 'urgent' ? '#dc3545' : ($notification->priority == 'high' ? '#ff6b6b' : ($notification->priority == 'normal' ? '#4a9eff' : '#888'))); ?>; color: white;">
                                    <?php echo e(ucfirst($notification->priority)); ?>

                                </span>
                            </td>
                            <td>
                                <?php if($notification->email_sent): ?>
                                    <span style="color: #6bff6b;"><i class="fas fa-check"></i> Yes</span>
                                <?php else: ?>
                                    <span style="color: #888;"><i class="fas fa-times"></i> No</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($notification->created_at->format('M d, Y h:i A')); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php endif; ?>

    <?php $__env->startPush('scripts'); ?>
    <script>
        function toggleRecipientOptions(isChecked, type) {
            const selectDiv = document.getElementById(type + '-select');
            if (selectDiv) {
                selectDiv.style.display = isChecked ? 'block' : 'none';
            }
        }
        
        // Check on page load if any specific recipient checkboxes are checked
        document.addEventListener('DOMContentLoaded', function() {
            const studentsCheckbox = document.querySelector('input[name="recipients[]"][value="students"]');
            const instructorsCheckbox = document.querySelector('input[name="recipients[]"][value="instructors"]');
            
            if (studentsCheckbox && studentsCheckbox.checked) {
                toggleRecipientOptions(true, 'students');
            }
            if (instructorsCheckbox && instructorsCheckbox.checked) {
                toggleRecipientOptions(true, 'instructors');
            }
        });
    </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/admin/announcements/index.blade.php ENDPATH**/ ?>