<?php $__env->startSection('title', 'Video Details'); ?>
<?php $__env->startSection('page-title', 'Video Details'); ?>

<?php $__env->startSection('content'); ?>
    <div style="margin-bottom: 20px;">
        <a href="<?php echo e(route('instructor.videos.index')); ?>" class="btn btn-secondary">← Back to Videos</a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-video"></i> <?php echo e($video->title); ?></h3>
        </div>
        
        <div style="padding: 30px;">
            <!-- Success/Error Messages -->
            <?php if(session('success')): ?>
                <div style="margin-bottom: 20px; padding: 15px; background: #1a4d1a; border: 1px solid #6bff6b; border-radius: 5px; color: #6bff6b;">
                    <i class="fas fa-check-circle"></i> <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>
            
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px; margin-bottom: 30px;">
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Video Information</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Title</strong>
                        <span style="color: #e0e0e0; font-size: 16px; font-weight: 600;"><?php echo e($video->title); ?></span>
                    </div>
                    <?php if($video->description): ?>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Description</strong>
                        <span style="color: #e0e0e0; font-size: 16px;"><?php echo e($video->description); ?></span>
                    </div>
                    <?php endif; ?>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Course</strong>
                        <span style="color: #e0e0e0; font-size: 16px;"><?php echo e($video->course->name ?? 'N/A'); ?></span>
                    </div>
                    <?php if($video->courseOffering): ?>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Course Offering</strong>
                        <span style="color: #e0e0e0; font-size: 16px;"><?php echo e($video->courseOffering->name ?? 'N/A'); ?></span>
                    </div>
                    <?php endif; ?>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Session Date</strong>
                        <span style="color: #e0e0e0; font-size: 16px;"><?php echo e($video->session_date ? \Carbon\Carbon::parse($video->session_date)->format('M d, Y') : 'N/A'); ?></span>
                    </div>
                    <?php if($video->video_duration): ?>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Duration</strong>
                        <span style="color: #e0e0e0; font-size: 16px;"><?php echo e($video->video_duration); ?></span>
                    </div>
                    <?php endif; ?>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Status</strong>
                        <?php if($video->is_published): ?>
                            <span style="color: #6bff6b; font-size: 16px;">Published</span>
                        <?php else: ?>
                            <span style="color: #888; font-size: 16px;">Draft</span>
                        <?php endif; ?>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Views</strong>
                        <span style="color: #e0e0e0; font-size: 16px;"><?php echo e($video->views_count ?? 0); ?></span>
                    </div>
                </div>
                
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Video Links</h4>
                    <?php if($video->mega_storage_link): ?>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Mega Storage Link</strong>
                        <a href="<?php echo e($video->mega_storage_link); ?>" target="_blank" style="color: #4a9eff; text-decoration: none; word-break: break-all; display: block;">
                            <?php echo e($video->mega_storage_link); ?>

                            <i class="fas fa-external-link-alt" style="margin-left: 5px;"></i>
                        </a>
                    </div>
                    <?php else: ?>
                    <div style="margin-bottom: 15px;">
                        <span style="color: #888;">No video link provided</span>
                    </div>
                    <?php endif; ?>
                    
                    <?php if($video->download_key): ?>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Download Key</strong>
                        <span style="color: #e0e0e0; font-size: 16px; font-family: monospace;"><?php echo e($video->download_key); ?></span>
                    </div>
                    <?php endif; ?>
                    
                    <?php if($video->thumbnail_url): ?>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Thumbnail</strong>
                        <img src="<?php echo e($video->thumbnail_url); ?>" alt="Video thumbnail" style="max-width: 100%; border-radius: 5px; margin-top: 5px;">
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <?php if($video->mega_storage_link): ?>
            <div style="margin-top: 30px; padding: 20px; background: #1a1a1a; border-radius: 5px; border: 1px solid #404040;">
                <h4 style="color: #4a9eff; margin-bottom: 15px;">Video Preview</h4>
                <div style="position: relative; padding-bottom: 56.25%; height: 0; overflow: hidden; border-radius: 5px;">
                    <iframe 
                        src="<?php echo e($video->mega_storage_link); ?>" 
                        style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; border: none;"
                        allowfullscreen
                        allow="autoplay; encrypted-media">
                    </iframe>
                </div>
                <p style="color: #888; margin-top: 15px; font-size: 12px;">
                    <i class="fas fa-info-circle"></i> If the video doesn't load, click the link above to open it in a new tab.
                </p>
            </div>
            <?php endif; ?>
            
            <div style="margin-top: 30px; display: flex; gap: 10px;">
                <a href="<?php echo e(route('instructor.videos.edit', $video->id)); ?>" class="btn btn-primary">
                    <i class="fas fa-edit"></i> Edit Video
                </a>
                <button type="button" onclick="openConfirmationModal('Delete Video', 'Are you sure you want to delete <?php echo e(addslashes($video->title)); ?>? This action cannot be undone.', '<?php echo e(route('instructor.videos.destroy', $video->id)); ?>', 'DELETE')" class="btn btn-secondary" style="background: #dc3545; border: none;">
                    <i class="fas fa-trash"></i> Delete Video
                </button>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.instructor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/instructor/videos/show.blade.php ENDPATH**/ ?>