

<?php $__env->startSection('title', 'Certificates'); ?>
<?php $__env->startSection('page-title', 'Certificates Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>All Certificates</h3>
            <a href="<?php echo e(route('admin.certificates.create')); ?>" class="btn btn-primary">Issue New Certificate</a>
        </div>
        
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="<?php echo e(route('admin.certificates.index')); ?>" style="display: flex; gap: 10px;">
                <input type="text" name="search" placeholder="Search certificates..." value="<?php echo e(request('search')); ?>" style="flex: 1; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                <button type="submit" class="btn btn-primary">Search</button>
            </form>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <?php if($certificates->count() > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Student</th>
                            <th>Course</th>
                            <th>Type</th>
                            <th>Issued Date</th>
                            <th>Issued By</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $certificates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $certificate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><strong><?php echo e($certificate->title); ?></strong></td>
                                <td><?php echo e($certificate->student->name); ?></td>
                                <td><?php echo e($certificate->course->name ?? 'N/A'); ?></td>
                                <td><?php echo e(ucfirst($certificate->certificate_type)); ?></td>
                                <td><?php echo e($certificate->issued_date->format('M d, Y')); ?></td>
                                <td><?php echo e($certificate->issuedBy->name); ?></td>
                                <td>
                                    <?php if($certificate->is_active): ?>
                                        <span style="color: #6bff6b;">Active</span>
                                    <?php else: ?>
                                        <span style="color: #888;">Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div style="display: flex; gap: 8px;">
                                        <a href="<?php echo e(route('admin.certificates.show', $certificate->id)); ?>" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">View</a>
                                        <a href="<?php echo e(route('admin.certificates.edit', $certificate->id)); ?>" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">Edit</a>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div style="margin-top: 20px;"><?php echo e($certificates->links()); ?></div>
            <?php else: ?>
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p>No certificates found.</p>
                    <a href="<?php echo e(route('admin.certificates.create')); ?>" class="btn btn-primary" style="margin-top: 15px;">Issue First Certificate</a>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/admin/certificates/index.blade.php ENDPATH**/ ?>