

<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('page-title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Fee Payment Alert at Top -->
    <?php if(isset($feeAlerts) && count($feeAlerts) > 0): ?>
        <?php
            $totalOutstanding = 0;
            foreach ($feeAlerts as $alert) {
                $totalOutstanding += $alert['balance'];
            }
        ?>
        <div style="background: linear-gradient(135deg, #ff6b6b 0%, #ee5a6f 100%); border-radius: 8px; padding: 12px 20px; margin-bottom: 20px; border-left: 4px solid #fff; box-shadow: 0 4px 15px rgba(255, 107, 107, 0.3);">
            <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 10px;">
                <div style="display: flex; align-items: center; gap: 10px;">
                    <i class="fas fa-exclamation-triangle" style="font-size: 18px; color: white;"></i>
                    <span style="color: white; font-weight: 600; font-size: 14px;">
                        Outstanding Balance: ₵<?php echo e(number_format($totalOutstanding, 2)); ?>

                    </span>
                    <span style="color: rgba(255,255,255,0.9); font-size: 12px;">
                        (<?php echo e(count($feeAlerts)); ?> <?php echo e(count($feeAlerts) == 1 ? 'course' : 'courses'); ?>)
                    </span>
                </div>
                <a href="<?php echo e(route('student.profile.index')); ?>" style="color: white; text-decoration: underline; font-size: 12px; font-weight: 500; white-space: nowrap;">
                    View Details <i class="fas fa-arrow-right" style="margin-left: 5px;"></i>
                </a>
            </div>
        </div>
    <?php endif; ?>
    
    <!-- Statistics Cards -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon"><i class="fas fa-book"></i></div>
            <div class="stat-value"><?php echo e($stats['total_courses'] ?? 0); ?></div>
            <div class="stat-label">Enrolled Courses</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon"><i class="fas fa-tasks"></i></div>
            <div class="stat-value"><?php echo e($stats['total_assignments'] ?? 0); ?></div>
            <div class="stat-label">Total Assignments</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon"><i class="fas fa-clock"></i></div>
            <div class="stat-value"><?php echo e($stats['pending_assignments'] ?? 0); ?></div>
            <div class="stat-label">Pending Assignments</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon"><i class="fas fa-check-circle"></i></div>
            <div class="stat-value"><?php echo e($stats['graded_assignments'] ?? 0); ?></div>
            <div class="stat-label">Graded Assignments</div>
        </div>
    </div>
    
    <!-- Welcome Section -->
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-tachometer-alt"></i> Welcome to Student Portal</h3>
        </div>
        <div>
            <p style="color: #e0e0e0; margin-bottom: 20px;">
                Welcome back, <strong><?php echo e(auth()->user()->name); ?></strong>! This is your student dashboard where you can access your courses, assignments, and learning materials.
            </p>
            
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                <div style="padding: 20px; background: #1a1a1a; border-radius: 5px; border: 1px solid #404040;">
                    <h4 style="color: #4a9eff; margin-bottom: 15px;"><i class="fas fa-bolt"></i> Quick Actions</h4>
                    <ul style="list-style: none; padding: 0;">
                        <li style="margin-bottom: 10px;">
                            <a href="<?php echo e(route('student.courses.index')); ?>" style="color: #4a9eff; text-decoration: none; display: flex; align-items: center; gap: 8px;"><i class="fas fa-book"></i> View My Courses</a>
                        </li>
                        <li style="margin-bottom: 10px;">
                            <a href="<?php echo e(route('student.assignments.index')); ?>" style="color: #4a9eff; text-decoration: none; display: flex; align-items: center; gap: 8px;"><i class="fas fa-tasks"></i> View Assignments</a>
                        </li>
                        <li style="margin-bottom: 10px;">
                            <a href="<?php echo e(route('student.videos.index')); ?>" style="color: #4a9eff; text-decoration: none; display: flex; align-items: center; gap: 8px;"><i class="fas fa-video"></i> Watch Videos</a>
                        </li>
                        <li style="margin-bottom: 10px;">
                            <a href="<?php echo e(route('student.certificates.index')); ?>" style="color: #4a9eff; text-decoration: none; display: flex; align-items: center; gap: 8px;"><i class="fas fa-certificate"></i> View Certificates</a>
                        </li>
                    </ul>
                </div>
                
                <div style="padding: 20px; background: #1a1a1a; border-radius: 5px; border: 1px solid #404040;">
                    <h4 style="color: #4a9eff; margin-bottom: 15px;"><i class="fas fa-info-circle"></i> Account Information</h4>
                    <ul style="list-style: none; padding: 0; color: #888;">
                        <li style="margin-bottom: 8px; display: flex; align-items: center; gap: 8px;"><i class="fas fa-id-card"></i> School ID: <?php echo e(auth()->user()->school_id ?? 'N/A'); ?></li>
                        <li style="margin-bottom: 8px; display: flex; align-items: center; gap: 8px;"><i class="fas fa-envelope"></i> <?php echo e(auth()->user()->email); ?></li>
                        <?php if(auth()->user()->phone): ?>
                            <li style="margin-bottom: 8px; display: flex; align-items: center; gap: 8px;"><i class="fas fa-phone"></i> <?php echo e(auth()->user()->phone); ?></li>
                        <?php endif; ?>
                        <li style="margin-bottom: 8px; display: flex; align-items: center; gap: 8px;"><i class="fas fa-calendar"></i> Today: <?php echo e(now()->format('M d, Y')); ?></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Recent Activities Section -->
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(350px, 1fr)); gap: 20px;">
        <!-- My Courses -->
        <div class="card">
            <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
                <h3><i class="fas fa-book"></i> My Courses</h3>
                <a href="<?php echo e(route('student.courses.index')); ?>" style="color: #4a9eff; font-size: 12px; text-decoration: none;">View All</a>
            </div>
            <div>
                <?php if(isset($recentCourses) && $recentCourses->count() > 0): ?>
                    <div style="display: flex; flex-direction: column; gap: 12px;">
                        <?php $__currentLoopData = $recentCourses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enrollment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($enrollment->course): ?>
                                <a href="<?php echo e(route('student.courses.show', $enrollment->course_id)); ?>" style="text-decoration: none; display: block;">
                                    <div style="padding: 12px; background: #1a1a1a; border-radius: 5px; border-left: 3px solid #4a9eff; transition: all 0.3s; cursor: pointer;" onmouseover="this.style.background='#222222'; this.style.borderLeftColor='#6bff6b';" onmouseout="this.style.background='#1a1a1a'; this.style.borderLeftColor='#4a9eff';">
                                        <div>
                                            <strong style="color: #e0e0e0; display: block;"><?php echo e($enrollment->course->name); ?></strong>
                                            <span style="color: #888; font-size: 13px;"><?php echo e($enrollment->course->code); ?></span>
                                        </div>
                                    </div>
                                </a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <p style="color: #888; text-align: center; padding: 20px;">No enrolled courses</p>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Upcoming Assignments -->
        <div class="card">
            <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
                <h3><i class="fas fa-tasks"></i> Upcoming Assignments</h3>
                <a href="<?php echo e(route('student.assignments.index')); ?>" style="color: #4a9eff; font-size: 12px; text-decoration: none;">View All</a>
            </div>
            <div>
                <?php if(isset($recentAssignments) && $recentAssignments->count() > 0): ?>
                    <div style="display: flex; flex-direction: column; gap: 12px;">
                        <?php $__currentLoopData = $recentAssignments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $submission = $assignment->submissions->first();
                                $isSubmitted = $submission && in_array($submission->status, ['submitted', 'graded']);
                                $isPastDue = $assignment->due_date < now()->toDateString();
                            ?>
                            <a href="<?php echo e(route('student.assignments.show', $assignment->id)); ?>" style="text-decoration: none; display: block;">
                                <div style="padding: 12px; background: #1a1a1a; border-radius: 5px; border-left: 3px solid <?php echo e($isSubmitted ? '#6bff6b' : ($isPastDue ? '#ff6b6b' : '#ffc107')); ?>; transition: all 0.3s; cursor: pointer;" onmouseover="this.style.background='#222222';" onmouseout="this.style.background='#1a1a1a';">
                                    <div style="display: flex; justify-content: space-between; align-items: start;">
                                        <div style="flex: 1;">
                                            <strong style="color: #e0e0e0; display: block;"><?php echo e($assignment->title); ?></strong>
                                            <span style="color: #888; font-size: 13px;"><?php echo e($assignment->course->name); ?></span>
                                        </div>
                                        <span style="color: #888; font-size: 12px; white-space: nowrap; margin-left: 10px;">
                                            Due: <?php echo e($assignment->due_date->format('M d, Y')); ?>

                                        </span>
                                    </div>
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <p style="color: #888; text-align: center; padding: 20px;">No upcoming assignments</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.student', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/student/dashboard.blade.php ENDPATH**/ ?>