<!-- Confirmation Modal -->
<div id="confirmationModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.8); z-index: 10001; align-items: center; justify-content: center;">
    <div style="background: #2d2d2d; padding: 30px; border-radius: 10px; max-width: 500px; width: 90%; box-shadow: 0 10px 40px rgba(0,0,0,0.5);">
        <div style="text-align: center; margin-bottom: 20px;">
            <div id="confirmationModalIcon" style="font-size: 48px; color: #ff6b6b; margin-bottom: 15px;">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <h3 id="confirmationModalTitle" style="color: #e0e0e0; margin-bottom: 10px;">Are you sure?</h3>
            <p id="confirmationModalMessage" style="color: #888; line-height: 1.6;">This action cannot be undone.</p>
        </div>
        
        <form id="confirmationForm" method="POST" style="margin: 0;">
            <?php echo csrf_field(); ?>
            <div id="confirmationFormMethod"></div>
            
            <div style="display: flex; gap: 10px; justify-content: flex-end; margin-top: 25px;">
                <button type="button" onclick="closeConfirmationModal()" class="btn btn-secondary" style="min-width: 100px;">
                    <i class="fas fa-times"></i> No, Cancel
                </button>
                <button type="submit" class="btn btn-primary" id="confirmationSubmitBtn" style="min-width: 100px; background: #dc3545; border: none;">
                    <i class="fas fa-check"></i> Yes, Confirm
                </button>
            </div>
        </form>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    let confirmationModal = null;
    
    function openConfirmationModal(title, message, actionUrl, method = 'POST', submitText = 'Yes, Confirm', submitColor = '#dc3545', iconClass = 'fa-exclamation-triangle', iconColor = '#ff6b6b') {
        if (!confirmationModal) {
            confirmationModal = document.getElementById('confirmationModal');
        }
        
        document.getElementById('confirmationModalTitle').textContent = title || 'Are you sure?';
        document.getElementById('confirmationModalMessage').textContent = message || 'This action cannot be undone.';
        document.getElementById('confirmationForm').action = actionUrl;
        
        // Handle HTTP method
        let methodInput = document.getElementById('confirmationFormMethod');
        methodInput.innerHTML = '';
        
        if (method && method !== 'POST') {
            let methodField = document.createElement('input');
            methodField.type = 'hidden';
            methodField.name = '_method';
            methodField.value = method;
            methodInput.appendChild(methodField);
        }
        
        // Update icon
        let iconElement = document.getElementById('confirmationModalIcon');
        if (iconElement) {
            iconElement.innerHTML = '<i class="fas ' + iconClass + '"></i>';
            iconElement.style.color = iconColor;
        }
        
        // Update submit button
        let submitBtn = document.getElementById('confirmationSubmitBtn');
        submitBtn.innerHTML = '<i class="fas fa-check"></i> ' + submitText;
        submitBtn.style.background = submitColor;
        
        confirmationModal.style.display = 'flex';
    }
    
    function closeConfirmationModal() {
        if (confirmationModal) {
            confirmationModal.style.display = 'none';
            document.getElementById('confirmationForm').reset();
        }
    }
    
    // Close modal when clicking outside
    document.addEventListener('DOMContentLoaded', function() {
        confirmationModal = document.getElementById('confirmationModal');
        if (confirmationModal) {
            confirmationModal.addEventListener('click', function(e) {
                if (e.target === confirmationModal) {
                    closeConfirmationModal();
                }
            });
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/partials/confirmation-modal.blade.php ENDPATH**/ ?>