

<?php $__env->startSection('title', 'Quiz History'); ?>
<?php $__env->startSection('page-title', 'My Quiz History'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 15px;">
            <h3>My Quiz History</h3>
            <a href="<?php echo e(route('student.quizzes.index')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Take New Quiz
            </a>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <?php if($attempts->count() > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Quiz</th>
                            <th>Level</th>
                            <th>Score</th>
                            <th>Correct</th>
                            <th>Total</th>
                            <th>Duration</th>
                            <th>Completed</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $attempts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attempt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <strong><?php echo e($attempt->quiz->title); ?></strong>
                                    <?php if($attempt->quiz->course): ?>
                                        <br><small style="color: #888;"><?php echo e($attempt->quiz->course->name); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span style="padding: 4px 8px; border-radius: 4px; font-size: 11px; font-weight: bold;
                                        <?php if($attempt->quiz->level == 1): ?>
                                            background: #1a3a1a; color: #6bff6b;
                                        <?php elseif($attempt->quiz->level == 2): ?>
                                            background: #3a3a1a; color: #ffa500;
                                        <?php else: ?>
                                            background: #3a1a1a; color: #ff6b6b;
                                        <?php endif; ?>
                                    ">
                                        <?php echo e($attempt->quiz->level_name); ?>

                                    </span>
                                </td>
                                <td>
                                    <strong style="color: <?php echo e($attempt->percentage >= 80 ? '#6bff6b' : ($attempt->percentage >= 60 ? '#ffa500' : '#ff6b6b')); ?>;">
                                        <?php echo e(number_format($attempt->percentage, 1)); ?>%
                                    </strong>
                                </td>
                                <td style="color: #6bff6b;"><?php echo e($attempt->correct_answers); ?></td>
                                <td><?php echo e($attempt->total_questions); ?></td>
                                <td><?php echo e($attempt->formatted_duration); ?></td>
                                <td><?php echo e($attempt->completed_at->format('M d, Y H:i')); ?></td>
                                <td>
                                    <a href="<?php echo e(route('student.quizzes.result', ['quiz' => $attempt->quiz->id, 'attempt' => $attempt->id])); ?>" 
                                       class="btn btn-secondary" 
                                       style="padding: 6px 12px; font-size: 12px;">
                                        <i class="fas fa-eye"></i> View
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                
                <div style="margin-top: 20px;">
                    <?php echo e($attempts->links()); ?>

                </div>
            <?php else: ?>
                <div style="text-align: center; padding: 60px 20px; color: #888;">
                    <i class="fas fa-history" style="font-size: 48px; margin-bottom: 20px; opacity: 0.5;"></i>
                    <p style="font-size: 18px; margin-bottom: 10px;">No quiz history yet</p>
                    <p style="font-size: 14px; margin-bottom: 20px;">Start taking quizzes to see your progress here!</p>
                    <a href="<?php echo e(route('student.quizzes.index')); ?>" class="btn btn-primary">
                        <i class="fas fa-play"></i> Take Your First Quiz
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.student', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/student/quizzes/history.blade.php ENDPATH**/ ?>