

<?php $__env->startSection('title', 'Create Assignment'); ?>
<?php $__env->startSection('page-title', 'Create New Assignment'); ?>

<?php $__env->startSection('content'); ?>
    <div style="margin-bottom: 20px;">
        <a href="<?php echo e(route('instructor.assignments.index')); ?>" class="btn btn-secondary">← Back to Assignments</a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-tasks"></i> Create New Assignment</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <form method="POST" action="<?php echo e(route('instructor.assignments.store')); ?>">
                <?php echo csrf_field(); ?>
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="course_id">Course *</label>
                        <select id="course_id" name="course_id" required onchange="loadChapters(this.value)">
                            <option value="">Select Course</option>
                            <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($course->id); ?>" <?php echo e(old('course_id') == $course->id ? 'selected' : ''); ?>>
                                    <?php echo e($course->name); ?> (<?php echo e($course->code); ?>)
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['course_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="chapter_id">Chapter (Optional)</label>
                        <select id="chapter_id" name="chapter_id">
                            <option value="">Select Chapter (Optional)</option>
                            <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $__currentLoopData = $course->chapters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chapter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($chapter->id); ?>" 
                                        data-course="<?php echo e($course->id); ?>"
                                        <?php echo e(old('chapter_id') == $chapter->id ? 'selected' : ''); ?>

                                        style="display: none;">
                                        <?php echo e($chapter->title); ?> (Chapter <?php echo e($chapter->chapter_number); ?>)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['chapter_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label for="title">Assignment Title *</label>
                    <input 
                        type="text" 
                        id="title" 
                        name="title" 
                        value="<?php echo e(old('title')); ?>" 
                        required
                        autofocus
                        placeholder="e.g., Flutter Widget Basics Assignment"
                    >
                    <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div class="form-group">
                    <label for="description">Description</label>
                    <textarea 
                        id="description" 
                        name="description" 
                        rows="3"
                        placeholder="Brief description of the assignment..."
                    ><?php echo e(old('description')); ?></textarea>
                    <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div class="form-group">
                    <label for="instructions">Instructions</label>
                    <textarea 
                        id="instructions" 
                        name="instructions" 
                        rows="6"
                        placeholder="Detailed instructions for students..."
                    ><?php echo e(old('instructions')); ?></textarea>
                    <?php $__errorArgs = ['instructions'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-top: 20px;">
                    <div class="form-group">
                        <label for="due_date">Due Date *</label>
                        <input 
                            type="date" 
                            id="due_date" 
                            name="due_date" 
                            value="<?php echo e(old('due_date', date('Y-m-d'))); ?>" 
                            required
                            min="<?php echo e(date('Y-m-d')); ?>"
                        >
                        <?php $__errorArgs = ['due_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="due_time">Due Time (Optional)</label>
                        <input 
                            type="time" 
                            id="due_time" 
                            name="due_time" 
                            value="<?php echo e(old('due_time')); ?>"
                        >
                        <?php $__errorArgs = ['due_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="total_points">Total Points *</label>
                        <input 
                            type="number" 
                            id="total_points" 
                            name="total_points" 
                            value="<?php echo e(old('total_points', 100)); ?>" 
                            required
                            min="1"
                            max="1000"
                            step="0.01"
                        >
                        <?php $__errorArgs = ['total_points'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                
                <div style="margin-top: 20px;">
                    <div class="form-group">
                        <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                            <input 
                                type="checkbox" 
                                name="allow_late_submission" 
                                value="1"
                                <?php echo e(old('allow_late_submission', true) ? 'checked' : ''); ?>

                                style="width: auto;"
                            >
                            <span>Allow Late Submission</span>
                        </label>
                    </div>
                    
                    <div class="form-group" id="late_penalty_group" style="display: none;">
                        <label for="late_penalty_percentage">Late Penalty (% per day)</label>
                        <input 
                            type="number" 
                            id="late_penalty_percentage" 
                            name="late_penalty_percentage" 
                            value="<?php echo e(old('late_penalty_percentage', 10)); ?>" 
                            min="0"
                            max="100"
                        >
                        <?php $__errorArgs = ['late_penalty_percentage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                            <input 
                                type="checkbox" 
                                name="is_published" 
                                value="1"
                                <?php echo e(old('is_published') ? 'checked' : ''); ?>

                                style="width: auto;"
                            >
                            <span>Publish Assignment (make visible to students)</span>
                        </label>
                    </div>
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 10px;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Create Assignment
                    </button>
                    <a href="<?php echo e(route('instructor.assignments.index')); ?>" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
    
    <?php $__env->startPush('scripts'); ?>
    <script>
        function loadChapters(courseId) {
            const chapterSelect = document.getElementById('chapter_id');
            const options = chapterSelect.querySelectorAll('option');
            
            // Reset chapter selection
            chapterSelect.value = '';
            
            options.forEach(option => {
                if (option.value === '') {
                    option.style.display = 'block';
                } else {
                    const optionCourseId = option.getAttribute('data-course');
                    if (optionCourseId == courseId) {
                        option.style.display = 'block';
                    } else {
                        option.style.display = 'none';
                    }
                }
            });
        }
        
        // Show/hide late penalty based on checkbox
        document.querySelector('input[name="allow_late_submission"]').addEventListener('change', function() {
            const penaltyGroup = document.getElementById('late_penalty_group');
            if (this.checked) {
                penaltyGroup.style.display = 'block';
            } else {
                penaltyGroup.style.display = 'none';
            }
        });
        
        // Trigger on page load if checkbox is checked
        if (document.querySelector('input[name="allow_late_submission"]').checked) {
            document.getElementById('late_penalty_group').style.display = 'block';
        }
        
        // Load chapters if course is pre-selected
        const courseSelect = document.getElementById('course_id');
        if (courseSelect.value) {
            loadChapters(courseSelect.value);
        }
    </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.instructor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/instructor/assignments/create.blade.php ENDPATH**/ ?>