

<?php $__env->startSection('title', 'My Students'); ?>
<?php $__env->startSection('page-title', 'My Students'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-users"></i> My Students</h3>
        </div>
        
        <!-- Search Form -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="<?php echo e(route('instructor.students.index')); ?>" style="display: flex; flex-wrap: wrap; gap: 10px;">
                <input 
                    type="text" 
                    name="search" 
                    placeholder="Search by name, email, or school ID..." 
                    value="<?php echo e(request('search')); ?>"
                    style="flex: 1; min-width: 200px; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;"
                >
                <button type="submit" class="btn btn-primary">Search</button>
                <?php if(request('search')): ?>
                    <a href="<?php echo e(route('instructor.students.index')); ?>" class="btn btn-secondary">Clear</a>
                <?php endif; ?>
            </form>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <?php if($students->count() > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Email</th>
                            <th>School ID</th>
                            <th>Courses Enrolled</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><strong><?php echo e($student->name); ?></strong></td>
                                <td><?php echo e($student->email); ?></td>
                                <td><?php echo e($student->school_id ?? 'N/A'); ?></td>
                                <td><?php echo e($student->enrollments_count); ?></td>
                                <td>
                                    <a href="<?php echo e(route('instructor.students.show', $student->id)); ?>" class="btn btn-primary" style="padding: 6px 12px; font-size: 12px;">
                                        <i class="fas fa-eye"></i> View Details
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                
                <!-- Pagination -->
                <div style="margin-top: 20px;">
                    <?php echo e($students->links()); ?>

                </div>
            <?php else: ?>
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p><i class="fas fa-users" style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;"></i></p>
                    <p>No students found.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.instructor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/instructor/students/index.blade.php ENDPATH**/ ?>