

<?php $__env->startSection('title', 'Class Videos'); ?>
<?php $__env->startSection('page-title', 'Class Videos'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-video"></i> Class Videos</h3>
        </div>
        
        <!-- Filters -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="<?php echo e(route('student.videos.index')); ?>" style="display: flex; gap: 10px; flex-wrap: wrap;">
                <select name="course_id" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Courses</option>
                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($course->id); ?>" <?php echo e(request('course_id') == $course->id ? 'selected' : ''); ?>><?php echo e($course->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <button type="submit" class="btn btn-primary">Filter</button>
                <?php if(request('course_id')): ?>
                    <a href="<?php echo e(route('student.videos.index')); ?>" class="btn btn-secondary">Clear</a>
                <?php endif; ?>
            </form>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <?php if($videos->count() > 0): ?>
                <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 20px;">
                    <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="card" style="padding: 0; overflow: hidden;">
                            <?php if($video->thumbnail_url): ?>
                            <div style="width: 100%; height: 180px; background: url('<?php echo e($video->thumbnail_url); ?>') center/cover; background-color: #1a1a1a;"></div>
                            <?php else: ?>
                            <div style="width: 100%; height: 180px; background: #1a1a1a; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-video" style="font-size: 48px; color: #404040;"></i>
                            </div>
                            <?php endif; ?>
                            <div style="padding: 20px;">
                                <h4 style="color: #e0e0e0; margin-bottom: 10px; font-size: 16px;"><?php echo e($video->title); ?></h4>
                                <p style="color: #888; font-size: 13px; margin-bottom: 8px;"><?php echo e($video->course->name); ?></p>
                                <?php if($video->session_date): ?>
                                <p style="color: #888; font-size: 12px; margin-bottom: 15px;">
                                    <i class="fas fa-calendar"></i> <?php echo e(\Carbon\Carbon::parse($video->session_date)->format('M d, Y')); ?>

                                </p>
                                <?php endif; ?>
                                <a href="<?php echo e(route('student.videos.show', $video->id)); ?>" class="btn btn-primary" style="width: 100%; padding: 8px; font-size: 13px;">
                                    <i class="fas fa-play"></i> Watch Video
                                </a>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div style="margin-top: 20px;"><?php echo e($videos->links()); ?></div>
            <?php else: ?>
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p><i class="fas fa-video" style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;"></i></p>
                    <p>No class videos available yet.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.student', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/student/videos/index.blade.php ENDPATH**/ ?>