

<?php $__env->startSection('title', 'Review Incorrect Answers'); ?>
<?php $__env->startSection('page-title', 'Review Incorrect Answers'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .review-container {
        max-width: 1200px;
        margin: 0 auto;
    }
    
    .review-header {
        background: #2d2d2d;
        padding: 30px;
        border-radius: 8px;
        margin-bottom: 30px;
        border: 1px solid #404040;
    }
    
    .filters-section {
        background: #2d2d2d;
        padding: 20px;
        border-radius: 8px;
        margin-bottom: 30px;
        border: 1px solid #404040;
    }
    
    .filters-form {
        display: flex;
        flex-wrap: wrap;
        gap: 15px;
        align-items: end;
    }
    
    .filter-group {
        flex: 1;
        min-width: 200px;
    }
    
    .filter-group label {
        display: block;
        color: #888;
        font-size: 13px;
        margin-bottom: 8px;
    }
    
    .filter-group select,
    .filter-group input {
        width: 100%;
        padding: 10px;
        background: #1a1a1a;
        border: 1px solid #404040;
        border-radius: 5px;
        color: #e0e0e0;
    }
    
    .incorrect-item {
        background: #2d2d2d;
        padding: 25px;
        border-radius: 8px;
        margin-bottom: 20px;
        border: 1px solid #404040;
        border-left: 4px solid #ff6b6b;
    }
    
    .incorrect-item-header {
        display: flex;
        justify-content: space-between;
        align-items: start;
        margin-bottom: 15px;
        flex-wrap: wrap;
        gap: 15px;
    }
    
    .quiz-info {
        display: flex;
        align-items: center;
        gap: 10px;
        color: #4a9eff;
    }
    
    .date-info {
        color: #888;
        font-size: 13px;
    }
    
    .question-text {
        font-size: 18px;
        font-weight: 500;
        margin-bottom: 20px;
        color: #e0e0e0;
        line-height: 1.6;
    }
    
    .answer-section {
        margin-bottom: 15px;
    }
    
    .answer-label {
        color: #888;
        font-size: 13px;
        margin-bottom: 8px;
        display: block;
    }
    
    .answer-box {
        padding: 15px;
        border-radius: 6px;
        margin-bottom: 10px;
    }
    
    .answer-box.incorrect {
        background: #3a1a1a;
        border: 1px solid #ff6b6b;
        color: #ff6b6b;
    }
    
    .answer-box.correct {
        background: #1a3a1a;
        border: 1px solid #6bff6b;
        color: #6bff6b;
    }
    
    .explanation-box {
        margin-top: 15px;
        padding: 15px;
        background: #1a1a1a;
        border-radius: 6px;
        border-left: 3px solid #4a9eff;
    }
    
    .explanation-box strong {
        color: #4a9eff;
        display: block;
        margin-bottom: 8px;
    }
    
    .explanation-box p {
        color: #888;
        font-style: italic;
        margin: 0;
    }
    
    .action-buttons {
        display: flex;
        gap: 10px;
        margin-top: 20px;
        flex-wrap: wrap;
    }
    
    .empty-state {
        text-align: center;
        padding: 80px 20px;
        background: #2d2d2d;
        border-radius: 12px;
        border: 1px solid #404040;
    }
    
    .empty-state i {
        font-size: 80px;
        margin-bottom: 25px;
        color: #4a9eff;
        opacity: 0.8;
        display: block;
    }
    
    .empty-state h3 {
        font-size: 24px;
        margin-bottom: 15px;
    }
    
    .empty-state p {
        font-size: 16px;
        line-height: 1.6;
        max-width: 500px;
        margin: 0 auto 30px;
    }
    
    .btn-back-quizzes {
        display: inline-flex;
        align-items: center;
        gap: 10px;
        padding: 14px 28px;
        background: linear-gradient(135deg, #4a9eff 0%, #3a8eef 100%);
        color: white;
        border: 2px solid #4a9eff;
        border-radius: 8px;
        font-size: 15px;
        font-weight: 500;
        text-decoration: none;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 2px 8px rgba(74, 158, 255, 0.3);
    }
    
    .btn-back-quizzes:hover {
        background: linear-gradient(135deg, #3a8eef 0%, #2a7edf 100%);
        border-color: #3a8eef;
        transform: translateY(-2px);
        box-shadow: 0 4px 16px rgba(74, 158, 255, 0.4);
    }
    
    .btn-back-quizzes i {
        font-size: 16px;
        transition: transform 0.3s ease;
    }
    
    .btn-back-quizzes:hover i {
        transform: translateX(-3px);
    }
    
    @media (max-width: 768px) {
        .filters-form {
            flex-direction: column;
        }
        
        .filter-group {
            width: 100%;
        }
        
        .incorrect-item-header {
            flex-direction: column;
        }
        
        .empty-state {
            padding: 50px 20px;
        }
        
        .empty-state i {
            font-size: 60px;
        }
        
        .empty-state h3 {
            font-size: 20px;
        }
        
        .btn-back-quizzes {
            width: 100%;
            justify-content: center;
            padding: 12px 24px;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="review-container">
        <div class="review-header">
            <h2 style="color: #4a9eff; margin-bottom: 10px;">
                <i class="fas fa-exclamation-circle"></i> Review Incorrect Answers
            </h2>
            <p style="color: #888; margin: 0;">
                Review and retake questions you got wrong to improve your understanding.
            </p>
        </div>
        
        <!-- Filters -->
        <div class="filters-section">
            <form method="GET" action="<?php echo e(route('student.quizzes.review-incorrect')); ?>" class="filters-form">
                <div class="filter-group">
                    <label>Filter by Quiz</label>
                    <select name="quiz_id">
                        <option value="">All Quizzes</option>
                        <?php $__currentLoopData = $quizzes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quiz): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($quiz->id); ?>" <?php echo e(request('quiz_id') == $quiz->id ? 'selected' : ''); ?>>
                                <?php echo e($quiz->title); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                
                <div class="filter-group">
                    <label>From Date</label>
                    <input type="date" name="date_from" value="<?php echo e(request('date_from')); ?>">
                </div>
                
                <div class="filter-group">
                    <label>To Date</label>
                    <input type="date" name="date_to" value="<?php echo e(request('date_to')); ?>">
                </div>
                
                <div class="filter-group" style="flex: 0 0 auto;">
                    <label>&nbsp;</label>
                    <button type="submit" class="btn btn-primary" style="width: auto; padding: 10px 20px;">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                </div>
                
                <?php if(request()->anyFilled(['quiz_id', 'date_from', 'date_to'])): ?>
                <div class="filter-group" style="flex: 0 0 auto;">
                    <label>&nbsp;</label>
                    <a href="<?php echo e(route('student.quizzes.review-incorrect')); ?>" class="btn btn-secondary" style="width: auto; padding: 10px 20px;">
                        <i class="fas fa-times"></i> Clear
                    </a>
                </div>
                <?php endif; ?>
            </form>
        </div>
        
        <?php if($incorrectAnswers->count() > 0): ?>
            <div style="margin-bottom: 20px; color: #888; font-size: 14px;">
                Found <strong style="color: #4a9eff;"><?php echo e($incorrectAnswers->total()); ?></strong> incorrect answer(s)
            </div>
            
            <?php $__currentLoopData = $incorrectAnswers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $incorrectAnswer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $question = $incorrectAnswer->question;
                    $userAnswer = $incorrectAnswer->answer;
                    $correctAnswer = $question->getCorrectAnswer();
                    $attempt = $incorrectAnswer->attempt;
                    $quiz = $attempt->quiz;
                ?>
                
                <div class="incorrect-item">
                    <div class="incorrect-item-header">
                        <div>
                            <div class="quiz-info">
                                <i class="fas fa-question-circle"></i>
                                <strong><?php echo e($quiz->title); ?></strong>
                            </div>
                            <div class="date-info" style="margin-top: 5px;">
                                <i class="fas fa-calendar"></i> <?php echo e($attempt->completed_at->format('M d, Y h:i A')); ?>

                            </div>
                        </div>
                    </div>
                    
                    <div class="question-text">
                        <?php echo e($question->question); ?>

                    </div>
                    
                    <div class="answer-section">
                        <span class="answer-label">Your Answer:</span>
                        <div class="answer-box incorrect">
                            <i class="fas fa-times-circle"></i> <?php echo e($userAnswer ? $userAnswer->answer_text : 'No answer provided'); ?>

                        </div>
                    </div>
                    
                    <?php if($correctAnswer): ?>
                    <div class="answer-section">
                        <span class="answer-label">Correct Answer:</span>
                        <div class="answer-box correct">
                            <i class="fas fa-check-circle"></i> <?php echo e($correctAnswer->answer_text); ?>

                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if($question->explanation): ?>
                    <div class="explanation-box">
                        <strong><i class="fas fa-lightbulb"></i> Explanation:</strong>
                        <p><?php echo e($question->explanation); ?></p>
                    </div>
                    <?php endif; ?>
                    
                    <div class="action-buttons">
                        <a href="<?php echo e(route('student.quizzes.retake-question', $question->id)); ?>" class="btn btn-primary">
                            <i class="fas fa-redo"></i> Retake This Question
                        </a>
                        <a href="<?php echo e(route('student.quizzes.show', $quiz->id)); ?>" class="btn btn-secondary">
                            <i class="fas fa-book"></i> Retake Full Quiz
                        </a>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
            <div style="margin-top: 30px;">
                <?php echo e($incorrectAnswers->links()); ?>

            </div>
        <?php else: ?>
            <div class="empty-state">
                <i class="fas fa-check-circle"></i>
                <h3 style="color: #4a9eff; margin-bottom: 10px;">No Incorrect Answers Found!</h3>
                <p style="margin-bottom: 20px; color: #888;">Great job! You haven't gotten any questions wrong yet, or your filters are too restrictive.</p>
                <a href="<?php echo e(route('student.quizzes.index')); ?>" class="btn-back-quizzes">
                    <i class="fas fa-arrow-left"></i> 
                    <span>Back to Quizzes</span>
                </a>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.student', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/student/quizzes/review-incorrect.blade.php ENDPATH**/ ?>