

<?php $__env->startSection('title', 'Assignments'); ?>
<?php $__env->startSection('page-title', 'Assignments'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3><i class="fas fa-tasks"></i> My Assignments</h3>
            <a href="<?php echo e(route('instructor.assignments.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Create Assignment
            </a>
        </div>
        
        <!-- Filters -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="<?php echo e(route('instructor.assignments.index')); ?>" style="display: flex; gap: 10px; flex-wrap: wrap;">
                <select name="course_id" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Courses</option>
                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($course->id); ?>" <?php echo e(request('course_id') == $course->id ? 'selected' : ''); ?>><?php echo e($course->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <select name="published" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Status</option>
                    <option value="1" <?php echo e(request('published') == '1' ? 'selected' : ''); ?>>Published</option>
                    <option value="0" <?php echo e(request('published') == '0' ? 'selected' : ''); ?>>Draft</option>
                </select>
                <button type="submit" class="btn btn-primary">Filter</button>
                <?php if(request()->anyFilled(['course_id', 'published'])): ?>
                    <a href="<?php echo e(route('instructor.assignments.index')); ?>" class="btn btn-secondary">Clear</a>
                <?php endif; ?>
            </form>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <?php if($assignments->count() > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Course</th>
                            <th>Due Date</th>
                            <th>Points</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $assignments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <strong><?php echo e($assignment->title); ?></strong>
                                    <?php if($assignment->chapter): ?>
                                        <br><small style="color: #888;">Chapter: <?php echo e($assignment->chapter->title); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($assignment->course->name); ?></td>
                                <td>
                                    <?php echo e($assignment->due_date->format('M d, Y')); ?>

                                    <?php if($assignment->due_time): ?>
                                        <br><small style="color: #888;"><?php echo e(date('h:i A', strtotime($assignment->due_time))); ?></small>
                                    <?php endif; ?>
                                    <?php if($assignment->isPastDue()): ?>
                                        <br><span style="color: #ff6b6b; font-size: 11px;">Past Due</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(number_format($assignment->total_points, 0)); ?> pts</td>
                                <td>
                                    <?php if($assignment->is_published): ?>
                                        <span style="color: #6bff6b;">Published</span>
                                    <?php else: ?>
                                        <span style="color: #888;">Draft</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div style="display: flex; gap: 8px;">
                                        <a href="<?php echo e(route('instructor.assignments.show', $assignment->id)); ?>" class="btn btn-primary" style="padding: 6px 12px; font-size: 12px;">
                                            <i class="fas fa-eye"></i> View
                                        </a>
                                        <a href="<?php echo e(route('instructor.assignments.submissions', $assignment->id)); ?>" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">
                                            <i class="fas fa-file-alt"></i> Submissions
                                        </a>
                                        <a href="<?php echo e(route('instructor.assignments.edit', $assignment->id)); ?>" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>
                                        <button type="button" onclick="openConfirmationModal('Delete Assignment', 'Are you sure you want to delete <?php echo e(addslashes($assignment->title)); ?>? This action cannot be undone.', '<?php echo e(route('instructor.assignments.destroy', $assignment->id)); ?>', 'DELETE')" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px; background: #dc3545; border: none;">
                                            <i class="fas fa-trash"></i> Delete
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div style="margin-top: 20px;"><?php echo e($assignments->links()); ?></div>
            <?php else: ?>
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p><i class="fas fa-tasks" style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;"></i></p>
                    <p>No assignments found.</p>
                    <a href="<?php echo e(route('instructor.assignments.create')); ?>" class="btn btn-primary" style="margin-top: 15px;">
                        <i class="fas fa-plus"></i> Create First Assignment
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.instructor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/instructor/assignments/index.blade.php ENDPATH**/ ?>