

<?php $__env->startSection('title', 'Instructors'); ?>
<?php $__env->startSection('page-title', 'Instructor Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>All Instructors</h3>
            <a href="<?php echo e(route('admin.instructors.create')); ?>" class="btn btn-primary">Add New Instructor</a>
        </div>
        
        <!-- Search Form -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="<?php echo e(route('admin.instructors.index')); ?>" style="display: flex; gap: 10px;">
                <input 
                    type="text" 
                    name="search" 
                    placeholder="Search by name, email, or phone..." 
                    value="<?php echo e(request('search')); ?>"
                    style="flex: 1; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;"
                >
                <button type="submit" class="btn btn-primary">Search</button>
                <?php if(request('search')): ?>
                    <a href="<?php echo e(route('admin.instructors.index')); ?>" class="btn btn-secondary">Clear</a>
                <?php endif; ?>
            </form>
        </div>
        
        <!-- Instructors Table -->
        <div style="padding: 0 30px 30px 30px;">
            <?php if($instructors->count() > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Registered</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $instructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><strong><?php echo e($instructor->name); ?></strong></td>
                                <td><?php echo e($instructor->email); ?></td>
                                <td><?php echo e($instructor->phone ?? 'N/A'); ?></td>
                                <td><?php echo e($instructor->created_at->format('M d, Y')); ?></td>
                                <td>
                                    <div style="display: flex; gap: 8px;">
                                        <a href="<?php echo e(route('admin.instructors.show', $instructor->id)); ?>" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">View</a>
                                        <a href="<?php echo e(route('admin.instructors.edit', $instructor->id)); ?>" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">Edit</a>
                                        <button type="button" onclick="openConfirmationModal('Delete Instructor', 'Are you sure you want to delete <?php echo e(addslashes($instructor->name)); ?>? This action cannot be undone.', '<?php echo e(route('admin.instructors.destroy', $instructor->id)); ?>', 'DELETE')" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px; background: #dc3545; border: none;">
                                            <i class="fas fa-trash"></i> Delete
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                
                <!-- Pagination -->
                <div style="margin-top: 20px;">
                    <?php echo e($instructors->links()); ?>

                </div>
            <?php else: ?>
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p>No instructors found.</p>
                    <a href="<?php echo e(route('admin.instructors.create')); ?>" class="btn btn-primary" style="margin-top: 15px;">Add First Instructor</a>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .pagination {
        display: flex;
        gap: 8px;
        justify-content: center;
        list-style: none;
        padding: 0;
    }
    
    .pagination li {
        display: inline-block;
    }
    
    .pagination a, .pagination span {
        padding: 8px 12px;
        background: #2d2d2d;
        border: 1px solid #404040;
        border-radius: 5px;
        color: #e0e0e0;
        text-decoration: none;
        display: inline-block;
    }
    
    .pagination a:hover {
        background: #4a9eff;
        border-color: #4a9eff;
    }
    
    .pagination .active span {
        background: #4a9eff;
        border-color: #4a9eff;
        color: white;
    }
</style>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/admin/instructors/index.blade.php ENDPATH**/ ?>