

<?php $__env->startSection('title', 'Reset Password'); ?>

<?php $__env->startSection('content'); ?>
<div class="card" style="max-width: 450px; margin: 0 auto;">
    <div class="text-center mb-4">
        <h1 style="color: #4a9eff; margin-bottom: 10px;"><?php echo e(\App\Models\Setting::get('system_name', 'Afrilen Technologies')); ?></h1>
        <h2 style="color: #e0e0e0; font-size: 24px;">Reset Password</h2>
        <p style="color: #888; margin-top: 10px;">
            <?php if(isset($role) && $role === 'admin'): ?>
                Admin Password Reset
            <?php elseif(isset($role) && $role === 'instructor'): ?>
                Instructor Password Reset
            <?php else: ?>
                Student Password Reset
            <?php endif; ?>
        </p>
    </div>

    <?php if(session('status')): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> <?php echo e(session('status')); ?>

        </div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul style="list-style: none; margin: 0; padding: 0;">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><i class="fas fa-exclamation-circle"></i> <?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('password.email')); ?>">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="role" value="<?php echo e($role ?? 'student'); ?>">

        <div class="form-group">
            <label for="email">Email Address *</label>
            <input 
                type="email" 
                id="email" 
                name="email" 
                value="<?php echo e(old('email')); ?>" 
                required 
                autofocus
                placeholder="Enter your email address"
            >
            <small style="color: #888; font-size: 12px; display: block; margin-top: 5px;">
                Enter your email address and we'll send you a link to reset your password.
            </small>
        </div>

        <button type="submit" class="btn btn-primary" style="width: 100%;">
            <i class="fas fa-paper-plane"></i> Send Password Reset Link
        </button>
    </form>

    <div class="text-center" style="margin-top: 20px;">
        <a href="<?php echo e(isset($role) && $role === 'admin' ? route('admin.login') : 
            (isset($role) && $role === 'instructor' ? route('instructor.login') : route('student.login'))); ?>">
            <i class="fas fa-arrow-left"></i> Back to Login
        </a>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iksoftte/portal.afrilen.com/resources/views/auth/passwords/email.blade.php ENDPATH**/ ?>