@extends('layouts.student')

@section('title', 'Class Videos')
@section('page-title', 'Class Videos')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-video"></i> Class Videos</h3>
        </div>
        
        <!-- Filters -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="{{ route('student.videos.index') }}" style="display: flex; gap: 10px; flex-wrap: wrap;">
                <select name="course_id" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Courses</option>
                    @foreach($courses as $course)
                        <option value="{{ $course->id }}" {{ request('course_id') == $course->id ? 'selected' : '' }}>{{ $course->name }}</option>
                    @endforeach
                </select>
                <button type="submit" class="btn btn-primary">Filter</button>
                @if(request('course_id'))
                    <a href="{{ route('student.videos.index') }}" class="btn btn-secondary">Clear</a>
                @endif
            </form>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            @if($videos->count() > 0)
                <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 20px;">
                    @foreach($videos as $video)
                        <div class="card" style="padding: 0; overflow: hidden;">
                            @if($video->thumbnail_url)
                            <div style="width: 100%; height: 180px; background: url('{{ $video->thumbnail_url }}') center/cover; background-color: #1a1a1a;"></div>
                            @else
                            <div style="width: 100%; height: 180px; background: #1a1a1a; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-video" style="font-size: 48px; color: #404040;"></i>
                            </div>
                            @endif
                            <div style="padding: 20px;">
                                <h4 style="color: #e0e0e0; margin-bottom: 10px; font-size: 16px;">{{ $video->title }}</h4>
                                <p style="color: #888; font-size: 13px; margin-bottom: 8px;">{{ $video->course->name }}</p>
                                @if($video->session_date)
                                <p style="color: #888; font-size: 12px; margin-bottom: 15px;">
                                    <i class="fas fa-calendar"></i> {{ \Carbon\Carbon::parse($video->session_date)->format('M d, Y') }}
                                </p>
                                @endif
                                <a href="{{ route('student.videos.show', $video->id) }}" class="btn btn-primary" style="width: 100%; padding: 8px; font-size: 13px;">
                                    <i class="fas fa-play"></i> Watch Video
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div style="margin-top: 20px;">{{ $videos->links() }}</div>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p><i class="fas fa-video" style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;"></i></p>
                    <p>No class videos available yet.</p>
                </div>
            @endif
        </div>
    </div>
@endsection

