@extends('layouts.student')

@section('title', 'Resources')
@section('page-title', 'Resources')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-folder-open"></i> Available Resources</h3>
        </div>
        
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="{{ route('student.resources.index') }}" style="display: flex; gap: 10px;">
                <input type="text" name="search" placeholder="Search resources..." value="{{ request('search') }}" style="flex: 1; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                <button type="submit" class="btn btn-primary">Search</button>
                @if(request('search'))
                    <a href="{{ route('student.resources.index') }}" class="btn btn-secondary">Clear</a>
                @endif
            </form>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            @if($resources->count() > 0)
                <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 20px;">
                    @foreach($resources as $resource)
                        <div class="card" style="padding: 0; overflow: hidden; cursor: pointer;" onclick="window.location='{{ route('student.resources.show', $resource->id) }}';" onmouseover="this.style.transform='translateY(-5px)'; this.style.boxShadow='0 8px 25px rgba(74, 158, 255, 0.3)';" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 4px 20px rgba(0,0,0,0.5)';" style="transition: all 0.3s;">
                            <div style="padding: 30px; text-align: center; background: linear-gradient(135deg, #4a9eff 0%, #6bff6b 100%);">
                                <i class="fas fa-file" style="font-size: 64px; color: white; opacity: 0.9;"></i>
                            </div>
                            <div style="padding: 20px;">
                                <h4 style="color: #e0e0e0; margin-bottom: 10px; font-size: 16px;">{{ $resource->title }}</h4>
                                @if($resource->resource_type)
                                    <p style="color: #888; font-size: 13px; margin-bottom: 8px;">
                                        <i class="fas fa-tag"></i> {{ $resource->resource_type }}
                                    </p>
                                @endif
                                @if($resource->description)
                                    <p style="color: #888; font-size: 12px; margin-bottom: 8px; line-height: 1.4;">
                                        {{ Str::limit($resource->description, 80) }}
                                    </p>
                                @endif
                                <div style="display: flex; justify-content: space-between; align-items: center; margin-top: 15px; padding-top: 15px; border-top: 1px solid #404040;">
                                    <small style="color: #888; font-size: 11px;">
                                        <i class="fas fa-download"></i> {{ $resource->download_count }} downloads
                                    </small>
                                    <small style="color: #888; font-size: 11px;">
                                        {{ $resource->formatted_file_size }}
                                    </small>
                                </div>
                                <a href="{{ route('student.resources.show', $resource->id) }}" class="btn btn-primary" style="width: 100%; padding: 8px; font-size: 13px; margin-top: 15px;">
                                    <i class="fas fa-eye"></i> View Details
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div style="margin-top: 20px;">{{ $resources->links() }}</div>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <i class="fas fa-folder-open" style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;"></i>
                    <p>No resources available at the moment.</p>
                    <p style="font-size: 14px; margin-top: 10px;">Check back later for new resources!</p>
                </div>
            @endif
        </div>
    </div>
@endsection

