@extends('layouts.student')

@section('title', 'Quiz Result')
@section('page-title', 'Quiz Result')

@push('styles')
<style>
    .result-container {
        max-width: 900px;
        margin: 0 auto;
    }
    
    .result-header {
        background: linear-gradient(135deg, #2d2d2d 0%, #1a1a1a 100%);
        padding: 40px;
        border-radius: 12px;
        margin-bottom: 30px;
        border: 1px solid #404040;
        text-align: center;
    }
    
    .score-circle {
        width: 150px;
        height: 150px;
        border-radius: 50%;
        margin: 0 auto 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 36px;
        font-weight: bold;
        border: 8px solid;
    }
    
    .score-excellent {
        background: #1a3a1a;
        border-color: #6bff6b;
        color: #6bff6b;
    }
    
    .score-good {
        background: #3a3a1a;
        border-color: #ffa500;
        color: #ffa500;
    }
    
    .score-poor {
        background: #3a1a1a;
        border-color: #ff6b6b;
        color: #ff6b6b;
    }
    
    .result-stats {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
        gap: 15px;
        margin-top: 30px;
    }
    
    .stat-card {
        background: #2d2d2d;
        padding: 20px;
        border-radius: 8px;
        border: 1px solid #404040;
        text-align: center;
    }
    
    .stat-value {
        font-size: 28px;
        font-weight: bold;
        color: #4a9eff;
        margin-bottom: 5px;
    }
    
    .stat-label {
        font-size: 12px;
        color: #888;
        text-transform: uppercase;
    }
    
    .review-section {
        margin-top: 30px;
    }
    
    .review-question {
        background: #2d2d2d;
        padding: 20px;
        border-radius: 8px;
        margin-bottom: 20px;
        border: 1px solid #404040;
    }
    
    .review-question.correct {
        border-color: #6bff6b;
        background: #1a3a1a;
    }
    
    .review-question.incorrect {
        border-color: #ff6b6b;
        background: #3a1a1a;
    }
    
    .review-answer {
        padding: 12px 15px;
        margin: 8px 0;
        border-radius: 6px;
        border: 2px solid #404040;
    }
    
    .review-answer.user-answer {
        border-color: #4a9eff;
        background: #2a2a3a;
    }
    
    .review-answer.correct-answer {
        border-color: #6bff6b;
        background: #1a3a1a;
        color: #6bff6b;
    }
    
    .review-answer.incorrect-answer {
        border-color: #ff6b6b;
        background: #3a1a1a;
        color: #ff6b6b;
    }
</style>
@endpush

@section('content')
    <div class="result-container">
        <div class="result-header">
            <h2 style="color: #4a9eff; margin-bottom: 20px;">{{ $quiz->title }}</h2>
            
            @php
                $percentage = $attempt->percentage;
                $scoreClass = $percentage >= 80 ? 'score-excellent' : ($percentage >= 60 ? 'score-good' : 'score-poor');
            @endphp
            
            <div class="score-circle {{ $scoreClass }}">
                {{ number_format($percentage, 1) }}%
            </div>
            
            <h3 style="color: #e0e0e0; margin-bottom: 10px;">
                @if($percentage >= 80)
                    Excellent! 🎉
                @elseif($percentage >= 60)
                    Good Job! 👍
                @else
                    Keep Practicing! 💪
                @endif
            </h3>
            
            <div class="result-stats">
                <div class="stat-card">
                    <div class="stat-value">{{ $attempt->correct_answers }}</div>
                    <div class="stat-label">Correct</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value">{{ $attempt->total_questions - $attempt->correct_answers }}</div>
                    <div class="stat-label">Incorrect</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value">{{ $attempt->total_questions }}</div>
                    <div class="stat-label">Total</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value">{{ $attempt->formatted_duration }}</div>
                    <div class="stat-label">Time Taken</div>
                </div>
            </div>
        </div>
        
        <div class="review-section">
            <h3 style="color: #4a9eff; margin-bottom: 20px;">
                <i class="fas fa-list-check"></i> Review Your Answers
            </h3>
            
            @foreach($quiz->questions as $index => $question)
                @php
                    $attemptAnswer = $attemptAnswersMap[$question->id] ?? null;
                    $userAnswer = $attemptAnswer ? $attemptAnswer->answer : null;
                    $isCorrect = $attemptAnswer ? $attemptAnswer->is_correct : false;
                    $correctAnswer = $question->getCorrectAnswer();
                @endphp
                
                <div class="review-question {{ $isCorrect ? 'correct' : 'incorrect' }}">
                    <div style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 15px;">
                        <span style="background: #4a9eff; color: white; padding: 5px 12px; border-radius: 4px; font-size: 12px; font-weight: bold;">
                            Question {{ $index + 1 }}
                        </span>
                        @if($isCorrect)
                            <span style="color: #6bff6b; font-weight: bold;">
                                <i class="fas fa-check-circle"></i> Correct
                            </span>
                        @else
                            <span style="color: #ff6b6b; font-weight: bold;">
                                <i class="fas fa-times-circle"></i> Incorrect
                            </span>
                        @endif
                    </div>
                    
                    <div style="font-size: 16px; font-weight: 500; margin-bottom: 15px; color: #e0e0e0;">
                        {{ $question->question }}
                    </div>
                    
                    <div style="margin-bottom: 10px;">
                        <strong style="color: #888; font-size: 13px;">Your Answer:</strong>
                        @if($userAnswer)
                            <div class="review-answer {{ $isCorrect ? 'correct-answer' : 'incorrect-answer' }}">
                                {{ $userAnswer->answer_text }}
                            </div>
                        @else
                            <div class="review-answer incorrect-answer">
                                <i class="fas fa-exclamation-circle"></i> No answer provided
                            </div>
                        @endif
                    </div>
                    
                    @if(!$isCorrect && $correctAnswer)
                        <div>
                            <strong style="color: #888; font-size: 13px;">Correct Answer:</strong>
                            <div class="review-answer correct-answer">
                                {{ $correctAnswer->answer_text }}
                            </div>
                        </div>
                    @endif
                    
                    @if($question->explanation)
                        <div style="margin-top: 15px; padding-top: 15px; border-top: 1px solid #404040;">
                            <strong style="color: #888; font-size: 13px;">Explanation:</strong>
                            <p style="color: #888; font-size: 14px; margin-top: 5px; font-style: italic;">
                                {{ $question->explanation }}
                            </p>
                        </div>
                    @endif
                </div>
            @endforeach
        </div>
        
        <div style="display: flex; gap: 15px; margin-top: 30px; flex-wrap: wrap;">
            <a href="{{ route('student.quizzes.show', $quiz->id) }}" class="btn btn-primary">
                <i class="fas fa-redo"></i> Retake Quiz
            </a>
            <a href="{{ route('student.quizzes.index') }}" class="btn btn-secondary">
                <i class="fas fa-list"></i> Browse More Quizzes
            </a>
            <a href="{{ route('student.quizzes.history') }}" class="btn btn-secondary">
                <i class="fas fa-history"></i> View History
            </a>
        </div>
    </div>
@endsection

