@extends('layouts.student')

@section('title', 'Test Your Brain')
@section('page-title', 'Test Your Brain - Quizzes')

@section('content')
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 15px;">
            <h3>Available Quizzes</h3>
            <a href="{{ route('student.quizzes.history') }}" class="btn btn-secondary">
                <i class="fas fa-history"></i> My Quiz History
            </a>
        </div>
        
        <!-- Filters -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="{{ route('student.quizzes.index') }}" style="display: flex; flex-wrap: wrap; gap: 10px;">
                <select name="level" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Levels</option>
                    <option value="1" {{ request('level') == '1' ? 'selected' : '' }}>Beginner</option>
                    <option value="2" {{ request('level') == '2' ? 'selected' : '' }}>Intermediate</option>
                    <option value="3" {{ request('level') == '3' ? 'selected' : '' }}>Advanced</option>
                </select>
                <select name="course_id" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Courses</option>
                    @foreach($courses as $course)
                        <option value="{{ $course->id }}" {{ request('course_id') == $course->id ? 'selected' : '' }}>
                            {{ $course->name }}
                        </option>
                    @endforeach
                </select>
                <select name="book_id" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Books</option>
                    @foreach($books as $book)
                        <option value="{{ $book->id }}" {{ request('book_id') == $book->id ? 'selected' : '' }}>
                            {{ $book->title }}
                        </option>
                    @endforeach
                </select>
                <button type="submit" class="btn btn-primary">Filter</button>
                @if(request()->anyFilled(['level', 'course_id', 'book_id']))
                    <a href="{{ route('student.quizzes.index') }}" class="btn btn-secondary">Clear</a>
                @endif
            </form>
        </div>
        
        <!-- Quizzes Grid -->
        <div style="padding: 0 30px 30px 30px;">
            @if($quizzes->count() > 0)
                <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 20px;">
                    @foreach($quizzes as $quiz)
                        <div class="card" style="background: #2d2d2d; border: 1px solid #404040; transition: transform 0.2s, box-shadow 0.2s;">
                            <div style="padding: 20px;">
                                <div style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 15px;">
                                    <div>
                                        <h4 style="margin: 0 0 5px 0; color: #4a9eff;">{{ $quiz->title }}</h4>
                                        <span style="padding: 4px 10px; border-radius: 4px; font-size: 11px; font-weight: bold;
                                            @if($quiz->level == 1)
                                                background: #1a3a1a; color: #6bff6b;
                                            @elseif($quiz->level == 2)
                                                background: #3a3a1a; color: #ffa500;
                                            @else
                                                background: #3a1a1a; color: #ff6b6b;
                                            @endif
                                        ">
                                            {{ $quiz->level_name }}
                                        </span>
                                    </div>
                                </div>
                                
                                @if($quiz->description)
                                    <p style="color: #888; font-size: 14px; margin-bottom: 15px; line-height: 1.5;">
                                        {{ Str::limit($quiz->description, 100) }}
                                    </p>
                                @endif
                                
                                <div style="margin-bottom: 15px; font-size: 13px; color: #888;">
                                    <div style="margin-bottom: 5px;">
                                        <i class="fas fa-question-circle"></i> {{ $quiz->total_questions }} Questions
                                    </div>
                                    @if($quiz->course)
                                        <div style="margin-bottom: 5px;">
                                            <i class="fas fa-book"></i> {{ $quiz->course->name }}
                                        </div>
                                    @endif
                                    @if($quiz->book)
                                        <div style="margin-bottom: 5px;">
                                            <i class="fas fa-book-open"></i> {{ $quiz->book->title }}
                                        </div>
                                    @endif
                                    @if($quiz->time_limit_minutes)
                                        <div style="color: #ffa500; margin-bottom: 5px;">
                                            <i class="fas fa-clock"></i> {{ $quiz->time_limit_minutes }} min time limit
                                        </div>
                                    @endif
                                    @if(isset($userBestScores[$quiz->id]) && $userBestScores[$quiz->id] !== null)
                                        <div style="color: #6bff6b;">
                                            <i class="fas fa-trophy"></i> Best Score: {{ number_format($userBestScores[$quiz->id], 1) }}%
                                        </div>
                                    @endif
                                </div>
                                
                                <div style="display: flex; gap: 10px;">
                                    <a href="{{ route('student.quizzes.show', $quiz->id) }}" class="btn btn-primary" style="flex: 1;">
                                        <i class="fas fa-play"></i> Start Quiz
                                    </a>
                                    <a href="{{ route('student.quizzes.show', ['quiz' => $quiz->id, 'study_mode' => 1]) }}" class="btn btn-secondary" style="flex: 1; background: #6bff6b; color: #1a1a1a;">
                                        <i class="fas fa-book-reader"></i> Study
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div style="text-align: center; padding: 60px 20px; color: #888;">
                    <i class="fas fa-question-circle" style="font-size: 48px; margin-bottom: 20px; opacity: 0.5;"></i>
                    <p style="font-size: 18px; margin-bottom: 10px;">No quizzes available</p>
                    <p style="font-size: 14px;">Check back later for new quizzes!</p>
                </div>
            @endif
        </div>
    </div>
@endsection

