@extends('layouts.student')

@section('title', 'Quiz History')
@section('page-title', 'My Quiz History')

@section('content')
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 15px;">
            <h3>My Quiz History</h3>
            <a href="{{ route('student.quizzes.index') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Take New Quiz
            </a>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            @if($attempts->count() > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Quiz</th>
                            <th>Level</th>
                            <th>Score</th>
                            <th>Correct</th>
                            <th>Total</th>
                            <th>Duration</th>
                            <th>Completed</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($attempts as $attempt)
                            <tr>
                                <td>
                                    <strong>{{ $attempt->quiz->title }}</strong>
                                    @if($attempt->quiz->course)
                                        <br><small style="color: #888;">{{ $attempt->quiz->course->name }}</small>
                                    @endif
                                </td>
                                <td>
                                    <span style="padding: 4px 8px; border-radius: 4px; font-size: 11px; font-weight: bold;
                                        @if($attempt->quiz->level == 1)
                                            background: #1a3a1a; color: #6bff6b;
                                        @elseif($attempt->quiz->level == 2)
                                            background: #3a3a1a; color: #ffa500;
                                        @else
                                            background: #3a1a1a; color: #ff6b6b;
                                        @endif
                                    ">
                                        {{ $attempt->quiz->level_name }}
                                    </span>
                                </td>
                                <td>
                                    <strong style="color: {{ $attempt->percentage >= 80 ? '#6bff6b' : ($attempt->percentage >= 60 ? '#ffa500' : '#ff6b6b') }};">
                                        {{ number_format($attempt->percentage, 1) }}%
                                    </strong>
                                </td>
                                <td style="color: #6bff6b;">{{ $attempt->correct_answers }}</td>
                                <td>{{ $attempt->total_questions }}</td>
                                <td>{{ $attempt->formatted_duration }}</td>
                                <td>{{ $attempt->completed_at->format('M d, Y H:i') }}</td>
                                <td>
                                    <a href="{{ route('student.quizzes.result', ['quiz' => $attempt->quiz->id, 'attempt' => $attempt->id]) }}" 
                                       class="btn btn-secondary" 
                                       style="padding: 6px 12px; font-size: 12px;">
                                        <i class="fas fa-eye"></i> View
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                
                <div style="margin-top: 20px;">
                    {{ $attempts->links() }}
                </div>
            @else
                <div style="text-align: center; padding: 60px 20px; color: #888;">
                    <i class="fas fa-history" style="font-size: 48px; margin-bottom: 20px; opacity: 0.5;"></i>
                    <p style="font-size: 18px; margin-bottom: 10px;">No quiz history yet</p>
                    <p style="font-size: 14px; margin-bottom: 20px;">Start taking quizzes to see your progress here!</p>
                    <a href="{{ route('student.quizzes.index') }}" class="btn btn-primary">
                        <i class="fas fa-play"></i> Take Your First Quiz
                    </a>
                </div>
            @endif
        </div>
    </div>
@endsection

