@extends('layouts.student')

@section('title', 'Bookmarked Questions')
@section('page-title', 'Bookmarked Questions')

@push('styles')
<style>
    .bookmarks-container {
        max-width: 1200px;
        margin: 0 auto;
    }
    
    .bookmarks-header {
        background: #2d2d2d;
        padding: 30px;
        border-radius: 8px;
        margin-bottom: 30px;
        border: 1px solid #404040;
    }
    
    .filters-section {
        background: #2d2d2d;
        padding: 20px;
        border-radius: 8px;
        margin-bottom: 30px;
        border: 1px solid #404040;
    }
    
    .bookmark-item {
        background: #2d2d2d;
        padding: 25px;
        border-radius: 8px;
        margin-bottom: 20px;
        border: 1px solid #404040;
        border-left: 4px solid #4a9eff;
    }
    
    .bookmark-header {
        display: flex;
        justify-content: space-between;
        align-items: start;
        margin-bottom: 15px;
        flex-wrap: wrap;
        gap: 15px;
    }
    
    .quiz-info {
        display: flex;
        align-items: center;
        gap: 10px;
        color: #4a9eff;
    }
    
    .bookmark-actions {
        display: flex;
        gap: 10px;
    }
    
    .question-text {
        font-size: 18px;
        font-weight: 500;
        margin-bottom: 20px;
        color: #e0e0e0;
        line-height: 1.6;
    }
    
    .notes-section {
        margin-top: 15px;
        padding: 15px;
        background: #1a1a1a;
        border-radius: 6px;
        border-left: 3px solid #4a9eff;
    }
    
    .notes-section textarea {
        width: 100%;
        min-height: 80px;
        padding: 10px;
        background: #2d2d2d;
        border: 1px solid #404040;
        border-radius: 5px;
        color: #e0e0e0;
        font-family: inherit;
        resize: vertical;
    }
    
    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: #888;
    }
    
    .empty-state i {
        font-size: 64px;
        margin-bottom: 20px;
        opacity: 0.5;
    }
</style>
@endpush

@section('content')
    <div class="bookmarks-container">
        <div class="bookmarks-header">
            <h2 style="color: #4a9eff; margin-bottom: 10px;">
                <i class="fas fa-bookmark"></i> Bookmarked Questions
            </h2>
            <p style="color: #888; margin: 0;">
                Review and study questions you've bookmarked for later.
            </p>
        </div>
        
        <!-- Filters -->
        <div class="filters-section">
            <form method="GET" action="{{ route('student.quizzes.bookmarks') }}" style="display: flex; gap: 15px; align-items: end; flex-wrap: wrap;">
                <div style="flex: 1; min-width: 200px;">
                    <label style="display: block; color: #888; font-size: 13px; margin-bottom: 8px;">Filter by Quiz</label>
                    <select name="quiz_id" style="width: 100%; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                        <option value="">All Quizzes</option>
                        @foreach($quizzes as $quiz)
                            <option value="{{ $quiz->id }}" {{ request('quiz_id') == $quiz->id ? 'selected' : '' }}>
                                {{ $quiz->title }}
                            </option>
                        @endforeach
                    </select>
                </div>
                
                <div style="flex: 0 0 auto;">
                    <label style="display: block; color: #888; font-size: 13px; margin-bottom: 8px;">&nbsp;</label>
                    <button type="submit" class="btn btn-primary" style="width: auto; padding: 10px 20px;">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                </div>
                
                @if(request()->has('quiz_id'))
                <div style="flex: 0 0 auto;">
                    <label style="display: block; color: #888; font-size: 13px; margin-bottom: 8px;">&nbsp;</label>
                    <a href="{{ route('student.quizzes.bookmarks') }}" class="btn btn-secondary" style="width: auto; padding: 10px 20px;">
                        <i class="fas fa-times"></i> Clear
                    </a>
                </div>
                @endif
            </form>
        </div>
        
        @if($bookmarks->count() > 0)
            <div style="margin-bottom: 20px; color: #888; font-size: 14px;">
                Found <strong style="color: #4a9eff;">{{ $bookmarks->total() }}</strong> bookmarked question(s)
            </div>
            
            @foreach($bookmarks as $bookmark)
                @php
                    $question = $bookmark->question;
                    $quiz = $question->quiz;
                @endphp
                
                <div class="bookmark-item" id="bookmark-{{ $bookmark->id }}">
                    <div class="bookmark-header">
                        <div>
                            <div class="quiz-info">
                                <i class="fas fa-question-circle"></i>
                                <strong>{{ $quiz->title }}</strong>
                            </div>
                            <div style="color: #888; font-size: 13px; margin-top: 5px;">
                                <i class="fas fa-calendar"></i> Bookmarked {{ $bookmark->created_at->diffForHumans() }}
                            </div>
                        </div>
                        <div class="bookmark-actions">
                            <button type="button" 
                                    class="btn btn-secondary" 
                                    onclick="toggleBookmark({{ $question->id }}, {{ $bookmark->id }})"
                                    style="padding: 8px 16px; font-size: 13px;">
                                <i class="fas fa-bookmark"></i> Remove Bookmark
                            </button>
                            <a href="{{ route('student.quizzes.show', $quiz->id) }}" class="btn btn-primary" style="padding: 8px 16px; font-size: 13px;">
                                <i class="fas fa-redo"></i> Take Quiz
                            </a>
                        </div>
                    </div>
                    
                    <div class="question-text">
                        {{ $question->question }}
                    </div>
                    
                    @if($question->explanation)
                    <div style="margin-top: 15px; padding: 15px; background: #1a1a1a; border-radius: 6px; border-left: 3px solid #6bff6b;">
                        <strong style="color: #6bff6b; display: block; margin-bottom: 8px;">Explanation:</strong>
                        <p style="color: #888; font-style: italic; margin: 0;">{{ $question->explanation }}</p>
                    </div>
                    @endif
                    
                    <div class="notes-section">
                        <strong style="color: #4a9eff; display: block; margin-bottom: 8px;">
                            <i class="fas fa-sticky-note"></i> My Notes:
                        </strong>
                        <textarea 
                            id="notes-{{ $bookmark->id }}" 
                            placeholder="Add your personal notes about this question..."
                            onblur="saveNotes({{ $bookmark->id }})"
                        >{{ $bookmark->notes }}</textarea>
                        <button type="button" onclick="saveNotes({{ $bookmark->id }})" class="btn btn-primary" style="margin-top: 10px; padding: 6px 12px; font-size: 12px;">
                            <i class="fas fa-save"></i> Save Notes
                        </button>
                    </div>
                </div>
            @endforeach
            
            <div style="margin-top: 30px;">
                {{ $bookmarks->links() }}
            </div>
        @else
            <div class="empty-state">
                <i class="fas fa-bookmark"></i>
                <h3 style="color: #4a9eff; margin-bottom: 10px;">No Bookmarked Questions</h3>
                <p style="margin-bottom: 20px;">Start bookmarking questions while taking quizzes to review them later!</p>
                <a href="{{ route('student.quizzes.index') }}" class="btn btn-primary">
                    <i class="fas fa-arrow-left"></i> Browse Quizzes
                </a>
            </div>
        @endif
    </div>
@endsection

@push('scripts')
<script>
    function toggleBookmark(questionId, bookmarkId) {
        fetch(`/student/quizzes/questions/${questionId}/bookmark`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success && !data.is_bookmarked) {
                document.getElementById(`bookmark-${bookmarkId}`).remove();
                if (document.querySelectorAll('.bookmark-item').length === 0) {
                    location.reload();
                }
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred. Please try again.');
        });
    }
    
    function saveNotes(bookmarkId) {
        const notes = document.getElementById(`notes-${bookmarkId}`).value;
        
        fetch(`/student/quizzes/bookmarks/${bookmarkId}/notes`, {
            method: 'PUT',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
            },
            body: JSON.stringify({ notes: notes })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Show a brief success indicator
                const button = event.target;
                const originalText = button.innerHTML;
                button.innerHTML = '<i class="fas fa-check"></i> Saved!';
                button.style.background = '#6bff6b';
                button.style.color = '#1a1a1a';
                
                setTimeout(() => {
                    button.innerHTML = originalText;
                    button.style.background = '';
                    button.style.color = '';
                }, 2000);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while saving notes.');
        });
    }
</script>
@endpush

