@extends('layouts.student')

@section('title', 'Profile')
@section('page-title', 'My Profile')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-user"></i> Profile Information</h3>
        </div>
        
        <div style="padding: 30px;">
            <form method="POST" action="{{ route('student.profile.update') }}" enctype="multipart/form-data" id="profileForm">
                @csrf
                @method('PUT')
                
                <!-- Profile Picture Section -->
                <div style="margin-bottom: 30px; text-align: center;">
                    <div style="position: relative; display: inline-block;">
                        <div id="profilePreview" style="position: relative; display: inline-block;">
                            @if($user->profile_picture)
                                @php
                                    try {
                                        $decrypted = \Illuminate\Support\Facades\Crypt::decryptString($user->profile_picture);
                                    } catch (\Exception $e) {
                                        $decrypted = null;
                                    }
                                @endphp
                                @if($decrypted)
                                    <img src="{{ $decrypted }}" alt="Profile Picture" 
                                         id="profileImage"
                                         style="width: 150px; height: 150px; border-radius: 50%; object-fit: cover; border: 3px solid #4a9eff;">
                                @else
                                    <div id="profilePlaceholder" style="width: 150px; height: 150px; border-radius: 50%; background: #2d2d2d; display: flex; align-items: center; justify-content: center; border: 3px solid #4a9eff; margin: 0 auto;">
                                        <i class="fas fa-user" style="font-size: 60px; color: #888;"></i>
                                    </div>
                                @endif
                            @else
                                <div id="profilePlaceholder" style="width: 150px; height: 150px; border-radius: 50%; background: #2d2d2d; display: flex; align-items: center; justify-content: center; border: 3px solid #4a9eff; margin: 0 auto;">
                                    <i class="fas fa-user" style="font-size: 60px; color: #888;"></i>
                                </div>
                            @endif
                        </div>
                        
                        <!-- Custom File Input Button -->
                        <label for="profile_picture" id="cameraLabel" style="position: absolute; bottom: 0; right: 50%; transform: translateX(50%) translateY(25%); background: #4a9eff; color: white; width: 40px; height: 40px; border-radius: 50%; display: flex; align-items: center; justify-content: center; cursor: pointer; border: 3px solid #1a1a1a; box-shadow: 0 2px 8px rgba(0,0,0,0.3); transition: all 0.3s ease; z-index: 10;">
                            <i class="fas fa-camera" style="font-size: 16px;"></i>
                        </label>
                        
                        <input 
                            type="file" 
                            id="profile_picture" 
                            name="profile_picture" 
                            accept="image/*"
                            style="display: none;"
                            onchange="previewProfilePicture(this)"
                        >
                    </div>
                    <div style="margin-top: 50px; text-align: center;">
                        <small style="color: #888; font-size: 12px;">Click the camera icon to change profile picture</small>
                        <br><small style="color: #888; font-size: 11px;">Max size: 1MB. Formats: JPG, PNG, GIF</small>
                        @error('profile_picture')
                            <br><span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <!-- Personal Information Section -->
                <div style="margin-bottom: 30px;">
                    <h4 style="color: #4a9eff; margin-bottom: 20px; padding-bottom: 10px; border-bottom: 1px solid #404040;">
                        <i class="fas fa-user-circle"></i> Personal Information
                    </h4>
                    
                    <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 20px; margin-bottom: 20px;" class="profile-form-grid">
                        <div class="form-group">
                            <label for="name">
                                <i class="fas fa-user"></i> Full Name *
                            </label>
                            <input 
                                type="text" 
                                id="name" 
                                name="name" 
                                value="{{ old('name', $user->name) }}" 
                                required
                                placeholder="Enter your full name"
                            >
                            @error('name')
                                <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="school_id">
                                <i class="fas fa-id-card"></i> School ID
                            </label>
                            <input 
                                type="text" 
                                id="school_id" 
                                name="school_id" 
                                value="{{ old('school_id', $user->school_id) }}"
                                disabled
                                style="background: #2d2d2d; cursor: not-allowed; opacity: 0.7;"
                                placeholder="School ID"
                            >
                            <small style="color: #888; font-size: 11px; display: block; margin-top: 5px;">
                                <i class="fas fa-info-circle"></i> School ID cannot be changed
                            </small>
                        </div>
                        
                        <div class="form-group">
                            <label for="t_shirt_size">
                                <i class="fas fa-tshirt"></i> T-Shirt Size *
                            </label>
                            <select 
                                id="t_shirt_size" 
                                name="t_shirt_size" 
                                required
                                style="width: 100%; padding: 12px; background: #2d2d2d; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0; font-size: 14px;"
                            >
                                <option value="">Select T-Shirt Size</option>
                                <option value="XS" {{ old('t_shirt_size', $user->t_shirt_size ?? null) == 'XS' ? 'selected' : '' }}>XS - Extra Small</option>
                                <option value="S" {{ old('t_shirt_size', $user->t_shirt_size ?? null) == 'S' ? 'selected' : '' }}>S - Small</option>
                                <option value="M" {{ old('t_shirt_size', $user->t_shirt_size ?? null) == 'M' ? 'selected' : '' }}>M - Medium</option>
                                <option value="L" {{ old('t_shirt_size', $user->t_shirt_size ?? null) == 'L' ? 'selected' : '' }}>L - Large</option>
                                <option value="XL" {{ old('t_shirt_size', $user->t_shirt_size ?? null) == 'XL' ? 'selected' : '' }}>XL - Extra Large</option>
                                <option value="XXL" {{ old('t_shirt_size', $user->t_shirt_size ?? null) == 'XXL' ? 'selected' : '' }}>XXL - 2X Large</option>
                                <option value="XXXL" {{ old('t_shirt_size', $user->t_shirt_size ?? null) == 'XXXL' ? 'selected' : '' }}>XXXL - 3X Large</option>
                            </select>
                            @error('t_shirt_size')
                                <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div style="display: grid; grid-template-columns: 1fr; gap: 20px; margin-bottom: 20px;" class="profile-form-grid">
                        <div class="form-group">
                            <label for="delivery_address">
                                <i class="fas fa-map-marker-alt"></i> Delivery Address *
                            </label>
                            <textarea 
                                id="delivery_address" 
                                name="delivery_address" 
                                rows="3"
                                required
                                placeholder="Enter your delivery address for receiving materials"
                                style="width: 100%; padding: 12px; background: #2d2d2d; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0; font-size: 14px; resize: vertical; font-family: inherit;"
                            >{{ old('delivery_address', $user->delivery_address ?? '') }}</textarea>
                            <small style="color: #888; font-size: 11px; display: block; margin-top: 5px;">
                                <i class="fas fa-info-circle"></i> Required for receiving course materials
                            </small>
                            @error('delivery_address')
                                <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 20px;" class="profile-form-grid">
                        <div class="form-group">
                            <label for="email">
                                <i class="fas fa-envelope"></i> Email Address *
                            </label>
                            <input 
                                type="email" 
                                id="email" 
                                name="email" 
                                value="{{ old('email', $user->email) }}" 
                                required
                                placeholder="your.email@example.com"
                            >
                            @error('email')
                                <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="phone">
                                <i class="fas fa-phone"></i> Phone Number
                            </label>
                            <input 
                                type="text" 
                                id="phone" 
                                name="phone" 
                                value="{{ old('phone', $user->phone) }}"
                                placeholder="+233 XX XXX XXXX"
                            >
                            @error('phone')
                                <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <!-- Address Section -->
                <div style="margin-bottom: 30px;">
                    <h4 style="color: #4a9eff; margin-bottom: 20px; padding-bottom: 10px; border-bottom: 1px solid #404040;">
                        <i class="fas fa-map-marker-alt"></i> Address Information
                    </h4>
                    
                    <div class="form-group" style="margin-bottom: 20px;">
                        <label for="address">
                            <i class="fas fa-home"></i> Address
                        </label>
                        <textarea 
                            id="address" 
                            name="address" 
                            rows="3"
                            placeholder="Enter your full address"
                        >{{ old('address', $user->address) }}</textarea>
                        @error('address')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group" style="margin-bottom: 20px;">
                        <label for="delivery_address">
                            <i class="fas fa-truck"></i> Delivery Address *
                            <small style="color: #888; font-size: 11px; margin-left: 5px;">(For receiving materials)</small>
                        </label>
                        <textarea 
                            id="delivery_address" 
                            name="delivery_address" 
                            rows="3"
                            placeholder="Enter your delivery address where materials will be sent"
                            required
                        >{{ old('delivery_address', $user->delivery_address) }}</textarea>
                        @error('delivery_address')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="t_shirt_size">
                            <i class="fas fa-tshirt"></i> T-Shirt Size *
                            <small style="color: #888; font-size: 11px; margin-left: 5px;">(Required for delivery)</small>
                        </label>
                        <select id="t_shirt_size" name="t_shirt_size" required style="width: 100%; padding: 12px; background: #2d2d2d; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                            <option value="">Select T-Shirt Size</option>
                            <option value="XS" {{ old('t_shirt_size', $user->t_shirt_size) == 'XS' ? 'selected' : '' }}>XS - Extra Small</option>
                            <option value="S" {{ old('t_shirt_size', $user->t_shirt_size) == 'S' ? 'selected' : '' }}>S - Small</option>
                            <option value="M" {{ old('t_shirt_size', $user->t_shirt_size) == 'M' ? 'selected' : '' }}>M - Medium</option>
                            <option value="L" {{ old('t_shirt_size', $user->t_shirt_size) == 'L' ? 'selected' : '' }}>L - Large</option>
                            <option value="XL" {{ old('t_shirt_size', $user->t_shirt_size) == 'XL' ? 'selected' : '' }}>XL - Extra Large</option>
                            <option value="XXL" {{ old('t_shirt_size', $user->t_shirt_size) == 'XXL' ? 'selected' : '' }}>XXL - 2X Large</option>
                            <option value="XXXL" {{ old('t_shirt_size', $user->t_shirt_size) == 'XXXL' ? 'selected' : '' }}>XXXL - 3X Large</option>
                        </select>
                        @error('t_shirt_size')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <!-- Delivery Status Section -->
                <div style="margin-bottom: 30px; padding: 20px; background: #1a1a1a; border-radius: 5px;">
                    <h4 style="color: #4a9eff; margin-bottom: 20px; padding-bottom: 10px; border-bottom: 1px solid #404040;">
                        <i class="fas fa-truck-loading"></i> Delivery Status
                    </h4>
                    
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px;">
                        @php
                            $items = [
                                't_shirt' => ['label' => 'T-Shirt', 'icon' => 'tshirt', 'size' => $user->t_shirt_size ?? null],
                                'cap' => ['label' => 'Cap', 'icon' => 'hat-cowboy'],
                                'id_card' => ['label' => 'ID Card', 'icon' => 'id-card'],
                                'handout_book' => ['label' => 'Handout Book', 'icon' => 'book'],
                            ];
                            
                            // Check if delivery fields exist in database
                            $hasDeliveryFields = \Illuminate\Support\Facades\Schema::hasColumn('users', 't_shirt_status');
                        @endphp
                        
                        @foreach($items as $key => $item)
                            @php
                                // Safely access fields that might not exist if migration hasn't run
                                if ($hasDeliveryFields) {
                                    $status = $user->{$key . '_status'} ?? 'pending';
                                    $updatedAt = $user->{$key . '_updated_at'} ?? null;
                                    $notes = $user->{$key . '_notes'} ?? null;
                                } else {
                                    $status = 'pending';
                                    $updatedAt = null;
                                    $notes = null;
                                }
                                $statusColors = [
                                    'pending' => '#888',
                                    'on_the_way' => '#ffa500',
                                    'delivered' => '#6bff6b',
                                    'canceled' => '#ff6b6b',
                                    'returned' => '#ff6b6b',
                                ];
                                $statusLabels = [
                                    'pending' => 'Pending',
                                    'on_the_way' => 'On The Way',
                                    'delivered' => 'Delivered',
                                    'canceled' => 'Canceled',
                                    'returned' => 'Returned',
                                ];
                            @endphp
                            <div style="padding: 15px; background: #2d2d2d; border-radius: 5px; border-left: 3px solid {{ $statusColors[$status] ?? '#888' }};">
                                <div style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 10px;">
                                    <div>
                                        <h5 style="margin: 0 0 5px 0; color: #e0e0e0; font-size: 14px;">
                                            <i class="fas fa-{{ $item['icon'] }}"></i> {{ $item['label'] }}
                                        </h5>
                                        @if(isset($item['size']) && $item['size'])
                                            <small style="color: #888; font-size: 11px;">Size: {{ $item['size'] }}</small>
                                        @endif
                                    </div>
                                    <span style="padding: 4px 10px; background: {{ $statusColors[$status] ?? '#888' }}; color: #1a1a1a; border-radius: 12px; font-size: 10px; font-weight: bold;">
                                        {{ $statusLabels[$status] ?? ucfirst($status) }}
                                    </span>
                                </div>
                                
                                @if($updatedAt)
                                    <small style="color: #888; display: block; margin-bottom: 5px; font-size: 10px;">
                                        Updated: {{ $updatedAt->format('M d, Y') }}
                                    </small>
                                @endif
                                
                                @if($notes)
                                    <p style="color: #e0e0e0; font-size: 11px; margin: 5px 0 0 0; padding: 8px; background: #1a1a1a; border-radius: 3px;">
                                        <strong>Note:</strong> {{ $notes }}
                                    </p>
                                @endif
                            </div>
                        @endforeach
                    </div>
                </div>
                
                <div style="margin-top: 30px;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Update Profile
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Fee Information Section -->
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-money-bill-wave"></i> Fee Information</h3>
        </div>
        <div style="padding: 30px;">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-bottom: 30px;">
                <div style="padding: 20px; background: #1a1a1a; border-radius: 5px; border-left: 3px solid #4a9eff;">
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Total Fees</strong>
                    <span style="color: #e0e0e0; font-size: 24px; font-weight: 600;">₵{{ number_format($totalFees, 2) }}</span>
                </div>
                <div style="padding: 20px; background: #1a1a1a; border-radius: 5px; border-left: 3px solid #6bff6b;">
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Total Paid</strong>
                    <span style="color: #e0e0e0; font-size: 24px; font-weight: 600;">₵{{ number_format($totalPaid, 2) }}</span>
                </div>
                <div style="padding: 20px; background: #1a1a1a; border-radius: 5px; border-left: 3px solid {{ $totalBalance > 0 ? '#ff6b6b' : '#6bff6b' }};">
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Outstanding Balance</strong>
                    <span style="color: #e0e0e0; font-size: 24px; font-weight: 600;">₵{{ number_format($totalBalance, 2) }}</span>
                    @if($totalBalance > 0)
                        <button type="button" onclick="openPaymentModal({{ $totalBalance }})" class="btn btn-primary" style="margin-top: 15px; width: 100%;">
                            <i class="fas fa-money-bill-wave"></i> Pay Now
                        </button>
                    @endif
                </div>
            </div>
            
            @if(count($feeData) > 0)
                <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Fee Details by Course</h4>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Course</th>
                            <th>Course Fee</th>
                            <th>Amount Paid</th>
                            <th>Balance</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($feeData as $data)
                            <tr>
                                <td>
                                    <strong>{{ $data['course']->name }}</strong>
                                    <br><small style="color: #888;">{{ $data['course']->code }}</small>
                                </td>
                                <td>₵{{ number_format($data['fee'], 2) }}</td>
                                <td>₵{{ number_format($data['paid'], 2) }}</td>
                                <td>
                                    <span style="color: {{ $data['balance'] > 0 ? '#ff6b6b' : '#6bff6b' }}; font-weight: 600;">
                                        ₵{{ number_format($data['balance'], 2) }}
                                    </span>
                                </td>
                                <td>
                                    @if($data['balance'] <= 0)
                                        <span style="color: #6bff6b;"><i class="fas fa-check-circle"></i> Paid</span>
                                    @else
                                        <span style="color: #ff6b6b;"><i class="fas fa-exclamation-circle"></i> Pending</span>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <p style="color: #888; text-align: center; padding: 20px;">No fee information available.</p>
            @endif
        </div>
    </div>
    
    <!-- Password Update Section -->
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-lock"></i> Change Password</h3>
        </div>
        
        <div style="padding: 30px;">
            <form method="POST" action="{{ route('student.profile.updatePassword') }}">
                @csrf
                @method('PUT')
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="current_password">Current Password *</label>
                        <input 
                            type="password" 
                            id="current_password" 
                            name="current_password" 
                            required
                        >
                        @error('current_password')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="password">New Password *</label>
                        <input 
                            type="password" 
                            id="password" 
                            name="password" 
                            required
                            minlength="8"
                        >
                        @error('password')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="password_confirmation">Confirm New Password *</label>
                        <input 
                            type="password" 
                            id="password_confirmation" 
                            name="password_confirmation" 
                            required
                            minlength="8"
                        >
                    </div>
                </div>
                
                <div style="margin-top: 30px;">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-key"></i> Update Password
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Payment Modal -->
    <div id="paymentModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.8); z-index: 10000; overflow-y: auto;">
        <div style="position: relative; max-width: 600px; margin: 50px auto; background: #1a1a1a; border-radius: 10px; padding: 30px;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
                <h2 style="color: #e0e0e0; margin: 0;"><i class="fas fa-money-bill-wave"></i> Payment Information</h2>
                <button type="button" onclick="closePaymentModal()" style="background: none; border: none; color: #888; font-size: 24px; cursor: pointer;">&times;</button>
            </div>
            
            <div style="background: #2d2d2d; padding: 20px; border-radius: 5px; margin-bottom: 20px;">
                <h3 style="color: #4a9eff; margin-top: 0;">Payment Details</h3>
                <p style="color: #e0e0e0; margin: 10px 0;"><strong>Amount to Pay:</strong> <span id="paymentAmount" style="color: #4a9eff; font-size: 20px;">₵0.00</span></p>
                
                <div style="margin-top: 20px; padding-top: 20px; border-top: 1px solid #404040;">
                    <p style="color: #888; margin-bottom: 15px;"><strong>Payment Instructions:</strong></p>
                    <div style="color: #e0e0e0; line-height: 1.8;">
                        @php
                            $paymentInfo = \App\Models\Setting::get('payment_info');
                            if (empty($paymentInfo)) {
                                $paymentInfo = "💳 Payment Methods\n\nMerchant Number (Recommended):\n📌 054 505 4754 — IKSOFT TECHNOLOGIES\n\nMTN MoMo:\n📌 0543261734 — ADU AMANKWAH ISAAC\n📌 0550138086 — AGYEKUM MARY\n\nTelecel Cash:\n📌 0206934488 — ADU AMANKWAH ISAAC";
                            }
                        @endphp
                        <div style="white-space: pre-line;">{{ $paymentInfo }}</div>
                    </div>
                </div>
            </div>
            
            <div id="transactionSection" style="display: none; margin-bottom: 20px;">
                <div class="form-group">
                    <label for="transaction_id">Transaction ID *</label>
                    <input type="text" id="transaction_id" name="transaction_id" required 
                           style="width: 100%; padding: 12px; background: #2d2d2d; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;"
                           placeholder="Enter your transaction ID">
                </div>
                
                <div class="form-group">
                    <label for="payment_method">Payment Method (Optional)</label>
                    <select id="payment_method" name="payment_method" 
                            style="width: 100%; padding: 12px; background: #2d2d2d; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                        <option value="">Select payment method</option>
                        <option value="Merchant Number (054 505 4754)">Merchant Number (054 505 4754)</option>
                        <option value="MTN MoMo">MTN MoMo</option>
                        <option value="Telecel Cash">Telecel Cash</option>
                        <option value="Bank Transfer">Bank Transfer</option>
                        <option value="Cash">Cash</option>
                        <option value="Other">Other</option>
                    </select>
                </div>
                
                <button type="button" onclick="notifyAdmin()" class="btn btn-success" style="width: 100%;">
                    <i class="fas fa-paper-plane"></i> Notify Administrator
                </button>
            </div>
            
            <div style="display: flex; gap: 10px;">
                <button type="button" onclick="showTransactionSection()" class="btn btn-primary" style="flex: 1;">
                    <i class="fas fa-check-circle"></i> Verify Transaction ID
                </button>
                <button type="button" onclick="closePaymentModal()" class="btn btn-secondary" style="flex: 1;">
                    <i class="fas fa-times"></i> Close
                </button>
            </div>
        </div>
    </div>

    @push('styles')
    <style>
        @media (max-width: 768px) {
            .profile-form-grid {
                grid-template-columns: 1fr !important;
            }
        }
        
        .form-group label {
            display: flex;
            align-items: center;
            gap: 8px;
            margin-bottom: 8px;
        }
        
        .form-group label i {
            color: #4a9eff;
            font-size: 14px;
        }
    </style>
    @endpush

    @push('scripts')
    <script>
        let paymentAmount = 0;
        
        function openPaymentModal(amount) {
            paymentAmount = amount;
            document.getElementById('paymentAmount').textContent = '₵' + amount.toFixed(2);
            document.getElementById('paymentModal').style.display = 'block';
            document.body.style.overflow = 'hidden';
        }
        
        function closePaymentModal() {
            document.getElementById('paymentModal').style.display = 'none';
            document.getElementById('transactionSection').style.display = 'none';
            document.getElementById('transaction_id').value = '';
            document.getElementById('payment_method').value = '';
            document.body.style.overflow = 'auto';
        }
        
        function showTransactionSection() {
            document.getElementById('transactionSection').style.display = 'block';
        }
        
        function notifyAdmin() {
            const transactionId = document.getElementById('transaction_id').value.trim();
            const paymentMethod = document.getElementById('payment_method').value;
            
            if (!transactionId) {
                alert('Please enter a transaction ID');
                return;
            }
            
            // Show loading
            const btn = event.target;
            const originalText = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
            btn.disabled = true;
            
            fetch('{{ route("student.profile.notifyPayment") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({
                    transaction_id: transactionId,
                    amount: paymentAmount,
                    payment_method: paymentMethod
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Payment notification sent successfully! Admin will verify your payment shortly.');
                    closePaymentModal();
                } else {
                    alert(data.message || 'Failed to send notification. Please try again.');
                    btn.innerHTML = originalText;
                    btn.disabled = false;
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred. Please try again.');
                btn.innerHTML = originalText;
                btn.disabled = false;
            });
        }
        
        // Close modal when clicking outside
        document.getElementById('paymentModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closePaymentModal();
            }
        });
        
        // Profile picture preview
        function previewProfilePicture(input) {
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                
                reader.onload = function(e) {
                    const previewDiv = document.getElementById('profilePreview');
                    const placeholder = document.getElementById('profilePlaceholder');
                    let img = document.getElementById('profileImage');
                    
                    if (!img) {
                        // Create image element if it doesn't exist
                        img = document.createElement('img');
                        img.id = 'profileImage';
                        img.alt = 'Profile Picture';
                        img.style.cssText = 'width: 150px; height: 150px; border-radius: 50%; object-fit: cover; border: 3px solid #4a9eff;';
                        
                        if (placeholder) {
                            placeholder.parentNode.replaceChild(img, placeholder);
                        } else {
                            previewDiv.innerHTML = '';
                            previewDiv.appendChild(img);
                        }
                    }
                    
                    img.src = e.target.result;
                };
                
                reader.readAsDataURL(input.files[0]);
            }
        }
        
        // Camera button hover effect
        const cameraLabel = document.getElementById('cameraLabel');
        if (cameraLabel) {
            cameraLabel.addEventListener('mouseenter', function() {
                this.style.background = '#5bb5ff';
                this.style.transform = 'translateX(50%) translateY(25%) scale(1.1)';
            });
            
            cameraLabel.addEventListener('mouseleave', function() {
                this.style.background = '#4a9eff';
                this.style.transform = 'translateX(50%) translateY(25%) scale(1)';
            });
        }
    </script>
    @endpush
@endsection

