@extends('layouts.student')

@section('title', 'Course Details')
@section('page-title', 'Course Details')

@section('content')
    <div style="margin-bottom: 20px;">
        <a href="{{ route('student.courses.index') }}" class="btn btn-secondary">← Back to My Courses</a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3>{{ $course->name }} ({{ $course->code }})</h3>
        </div>
        
        <div style="padding: 30px;">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px; margin-bottom: 30px;">
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Course Information</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Instructor</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $course->instructor->name ?? 'N/A' }}</span>
                    </div>
                    @if($course->description)
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Description</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $course->description }}</span>
                    </div>
                    @endif
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Credits</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $course->credits }}</span>
                    </div>
                </div>
                
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Progress</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Overall Progress</strong>
                        <div style="background: #1a1a1a; border-radius: 10px; height: 30px; position: relative; overflow: hidden; margin-top: 10px;">
                            <div style="background: linear-gradient(90deg, #4a9eff 0%, #6bff6b 100%); height: 100%; width: {{ $progressPercentage }}%; transition: width 0.3s;"></div>
                            <span style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); color: #e0e0e0; font-weight: 600; font-size: 14px;">{{ number_format($progressPercentage, 1) }}%</span>
                        </div>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Chapters Completed</strong>
                        <span style="color: #e0e0e0; font-size: 24px; font-weight: 600;">{{ $chapterProgress->where('status', 'completed')->count() }} / {{ $course->chapters->count() }}</span>
                    </div>
                </div>
            </div>
            
            <!-- Course Chapters Section -->
            <div style="margin-top: 30px;">
                <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Course Chapters</h4>
                @if($course->chapters->count() > 0)
                    <div style="display: flex; flex-direction: column; gap: 15px;">
                        @foreach($course->chapters as $chapter)
                            @php
                                $progress = $chapterProgress->get($chapter->id);
                                $isCompleted = $progress && $progress->status == 'completed';
                            @endphp
                            <div style="padding: 20px; background: #1a1a1a; border-radius: 5px; border-left: 3px solid {{ $isCompleted ? '#6bff6b' : '#4a9eff' }};">
                                <div style="display: flex; justify-content: space-between; align-items: start;">
                                    <div style="flex: 1;">
                                        <div style="display: flex; align-items: center; gap: 10px; margin-bottom: 8px;">
                                            <strong style="color: #e0e0e0; font-size: 16px;">Chapter {{ $chapter->chapter_number }}: {{ $chapter->title }}</strong>
                                            @if($isCompleted)
                                                <span style="color: #6bff6b; font-size: 14px;"><i class="fas fa-check-circle"></i> Completed</span>
                                            @endif
                                        </div>
                                        @if($chapter->description)
                                            <p style="color: #888; font-size: 14px; margin-bottom: 8px;">{{ $chapter->description }}</p>
                                        @endif
                                        @if($chapter->session_number)
                                            <span style="color: #888; font-size: 12px;">Session {{ $chapter->session_number }}</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <p style="color: #888; text-align: center; padding: 20px;">No chapters available yet.</p>
                @endif
            </div>
        </div>
    </div>
@endsection

