@extends('layouts.student')

@section('title', 'My Courses')
@section('page-title', 'My Courses')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3><i class="fas fa-book"></i> My Enrolled Courses</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            @if($enrollments->count() > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Course Code</th>
                            <th>Course Name</th>
                            <th>Instructor</th>
                            <th>Enrollment Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($enrollments as $enrollment)
                            <tr>
                                <td><strong>{{ $enrollment->course->code }}</strong></td>
                                <td>{{ $enrollment->course->name }}</td>
                                <td>{{ $enrollment->course->instructor->name ?? 'N/A' }}</td>
                                <td>{{ $enrollment->enrollment_date ? $enrollment->enrollment_date->format('M d, Y') : 'N/A' }}</td>
                                <td>
                                    @if($enrollment->status == 'active')
                                        <span style="color: #6bff6b;">Active</span>
                                    @else
                                        <span style="color: #888;">{{ ucfirst($enrollment->status) }}</span>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('student.courses.show', $enrollment->course_id) }}" class="btn btn-primary" style="padding: 6px 12px; font-size: 12px;">
                                        <i class="fas fa-eye"></i> View Course
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p><i class="fas fa-book" style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;"></i></p>
                    <p>You are not enrolled in any courses yet.</p>
                    <p style="font-size: 14px; margin-top: 10px;">Please contact the administrator to get enrolled.</p>
                </div>
            @endif
        </div>
    </div>
@endsection

